
package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"


include("asyncpirategenerator")
include("callable")
include("utility")
include("goods")
local WaveUtility = include("waveutility")
local AsyncPirateGenerator = include("asyncpirategenerator")
local SectorTurretGenerator = include("sectorturretgenerator")
local SectorGenerator = include ("SectorGenerator")
local SpawnUtility = include("spawnutility")

local data = {}
data.waves = {}
data.traitorId = nil
data.chatMessageSent = false
data.wavesStarted = false
data.initialEnemies = true
data.waveSpawned = false
data.waveNumber = 1
data.welcomeTimer = 10

--sets the scenario
function initializeWaves()
    -- initialize scenario
    local generator = AsyncPirateGenerator(nil, onTraitorCreated)
    generator:createScaledMarauder()
    data.waves = WaveUtility.getWaves()
    data.waveSpawned = false
end

function updateServer(timeStep)
    if Sector().numPlayers >= 1 then
        if not data.wavesStarted then
            initializeWaves()
            data.wavesStarted = true
        end

        if data.initialEnemies then
            if isPlayerClose() then
                startEncounter()
            end

            data.welcomeTimer = data.welcomeTimer - timeStep

            if data.welcomeTimer <= 0 then
                local enemy = WaveUtility.getWaveMember()
                Sector():broadcastChatMessage(enemy, ChatMessageType.Chatter, "We need to deal with a traitor. We don't need no witnesses."%_t)
                data.welcomeTimer = 40
            end
        end

        if data.waveSpawned == true then
            local numEnemies = WaveUtility.getNumEnemies()

            if numEnemies <= 2 then
                data.waveSpawned = false

                if data.waveNumber < WaveUtility.data.numWaves then
                    data.waveNumber = data.waveNumber + 1
                    WaveUtility.createPirateWave(data.waves[data.waveNumber], onPiratesGenerated)
                elseif data.waveNumber == WaveUtility.data.numWaves then
                    WaveUtility.createPirateBossWave(onBossWaveGenerated)
                end
            end
        end
    end
end

function onTraitorCreated(generated)
    local traitor = generated
    data.traitorId = traitor.index
    local pirateFaction = AsyncPirateGenerator():getPirateFaction()
    local faction = Galaxy():createFaction(pirateFaction.name .. " Traitor"%_t, Sector():getCoordinates())
    generated.factionIndex = faction.index
    local translation = dvec3(random():getFloat(-300, 300), random():getFloat(-300, 300), random():getFloat(-300, 300))
    generated.translation = translation
    generated:registerCallback("onDestroyed", "startEncounter")
    WaveUtility.createPirateWave(data.waves[data.waveNumber], onInitialPiratesGenerated)
end

-- checks if the playership is near the enemies
function isPlayerClose()
    local ships = {Sector():getEntitiesByType(EntityType.Ship)}
    local vicinity = false
    for _, ship in pairs(ships) do
        if ship:getValue("is_wave") == 1 then
            vicinity = WaveUtility.playerVicinityCheck(ship, 300)
            if vicinity then
                return vicinity
            end
        end
    end

    return vicinity
end

-- callback for generator in wavegenerator. Needed here because it doesn't work when set in wavegenerator
function onPiratesGenerated(generated)
    SpawnUtility.addEnemyBuffs(generated)
    for _, ship in pairs(generated) do
        if valid(ship) then
            ship:setValue("is_wave", 1)
        end
    end

    data.waveSpawned = true
end

function onInitialPiratesGenerated(generated)
    SpawnUtility.addEnemyBuffs(generated)
    for _, ship in pairs(generated) do
        if valid(ship) then
            ship:setValue("is_wave", 1)
            ship:registerCallback("onDamaged", "onDamaged")
            local x = getVectorValue()
            local y = getVectorValue()
            local z = getVectorValue()
            local traitor = Entity(data.traitorId)
            ship.translation = traitor.translation + dvec3(x, y, z)
            ShipAI(ship.id):setAttack(traitor)
        end
    end

    data.waveSpawned = true
end

function getVectorValue()
    local value = random():getFloat(-400, 0)
    if value > -200 then value = value + 400 end
    return value
end

function onDamaged(objectIndex, amount, inflictor, damageType)
    if data.initialEnemies then
        WaveUtility.onDamaged(objectIndex, amount, inflictor, damageType)
    end
end

-- used to activate pirates which will start wave encounter
function startEncounter()
    local enemies = {Sector():getEntitiesByType(EntityType.Ship)}
    for _, enemy in pairs(enemies) do
        if enemy:getValue("is_wave") == 1 then
            if not data.chatMessageSentd then
                Sector():broadcastChatMessage(enemy, ChatMessageType.Chatter, "We told you we need no witness, now we have to eradicte you."%_t)
                data.chatMessageSentd = true
        end
        ShipAI(enemy.id):setAggressive()
    end
end

    data.initialEnemies = false
end

function secure()
    return {dat = data, wdata = WaveUtility.data}
end

function restore(data_in)
    data = data_in.dat
    WaveUtility.data = data_in.wdata
end
