
package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include("utility")
include("goods")
local WaveUtility = include("waveutility")
local SpawnUtility = include("spawnutility")

local data = {}
data.waves = {}
data.chatMessageSent = false
data.wavesStarted = false
data.initialEnemies = true
data.waveSpawned = false
data.waveNumber = 1
data.welcomeTimer = 10
data.welcomeTimerPassed = false


--sets the scenario
function initializeWaves()
    -- initialize scenario
    x, y = Sector():getCoordinates()
    local distToCenter = math.sqrt(x * x + y * y)
    local waveStrength = round(lerp(distToCenter, 0, 500,  4, 1))

    data.waves = WaveUtility.getWaves(nil, 3, waveStrength, 5, 2)
    data.waveSpawned = false
    WaveUtility.createPirateWave(data.waves[data.waveNumber], onInitialPiratesGenerated)
end

function updateServer(timeStep)
    if Sector().numPlayers >= 1 then
        if not data.wavesStarted then
            initializeWaves()
            data.wavesStarted = true
        end

        if data.initialEnemies then
            if isPlayerClose() then
                startEncounter()
            end

            data.welcomeTimer = data.welcomeTimer - timeStep

            if data.welcomeTimer <= 0 then
                if data.welcomeTimerPassed then
                    startEncounter()
                end
                local enemy = WaveUtility.getWaveMember()
                Sector():broadcastChatMessage(enemy, ChatMessageType.Chatter, "You only get one warning! We will have a meeting here. Leave this sector or you will pay the price!"%_t)
                data.welcomeTimer = 60
                data.welcomeTimerPassed = true
            end
        end

        if data.waveSpawned == true then
            local numEnemies = WaveUtility.getNumEnemies()

            if numEnemies <= 1 then
                data.waveSpawned = false

                if data.waveNumber < WaveUtility.data.numWaves then
                    data.waveNumber = data.waveNumber + 1
                    WaveUtility.createPirateWave(data.waves[data.waveNumber], onPiratesGenerated)
                elseif data.waveNumber == WaveUtility.data.numWaves then
                    WaveUtility.createPirateBossWave(onBossWaveGenerated)
                end
            end
        end
    end
end

-- checks if the playership is near the enemies
function isPlayerClose()
    local ships = {Sector():getEntitiesByType(EntityType.Ship)}
    local vicinity = false
    for _, ship in pairs(ships) do
        if ship:getValue("is_wave") == 1 then
            vicinity = WaveUtility.playerVicinityCheck(ship, 300)
            if vicinity then
                break
            end
        end
    end

    return vicinity
end

-- callback for generator in wavegenerator. Needed here because it doesn't work when set in wavegenerator
function onPiratesGenerated(generated)
    SpawnUtility.addEnemyBuffs(generated)
    for _, ship in pairs(generated) do
        if valid(ship) then
            ship:setValue("is_wave", 1)
        end
    end

    data.waveSpawned = true
end

function onInitialPiratesGenerated(generated)
    SpawnUtility.addEnemyBuffs(generated)
    for _, ship in pairs(generated) do
        ship:setValue("is_wave", 1)
        ship:removeScript("patrol.lua")
        ship:addScript("ai/patrolpeacefully")
        ship:registerCallback("onDamaged", "onDamaged")
        local x = getVectorValue()
        local y = getVectorValue()
        local z = getVectorValue()
        ship.translation = dvec3(x, y, z)
    end

    data.waveSpawned = true
end

function onDamaged(objectIndex, amount, inflictor, damageType)
    if data.initialEnemies then
        WaveUtility.onDamaged(objectIndex, amount, inflictor, damageType)
    end
end

function getVectorValue()
    local value = random():getFloat(-300, 0)
    if value > -150 then value = value + 300 end
    return value
end

-- sets loot for boss
function onBossWaveGenerated(generated)
    SpawnUtility.addEnemyBuffs(generated)

    for _, ship in pairs(generated) do
        if valid(ship) then
            ship:setValue("is_wave", 1)
        end
    end
    local boss = generated[4]
    local bossLoot = Loot(boss.id)

    for _, turret in pairs(WaveUtility.generateTurrets()) do
        bossLoot:insert(turret)
    end
end


-- used to activate pirates which will start wave encounter
function startEncounter()
    local enemies = {Sector():getEntitiesByType(EntityType.Ship)}
    for _, enemy in pairs(enemies) do
        if enemy:getValue("is_wave") == 1 then
            if not data.chatMessageSent then
                Sector():broadcastChatMessage(enemy, ChatMessageType.Chatter, "We warned you! Now see what you get from knowing stuff better!"%_t)
                data.chatMessageSent = true
            end
            enemy:removeScript("patrolpeacefully.lua")
            enemy:addScript("ai/patrol")
        end
    end

    data.initialEnemies = false
end

function secure()
    return {dat = data, wdata = WaveUtility.data}
end

function restore(data_in)
    data = data_in.dat
    WaveUtility.data = data_in.wdata
end
