
package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

local SectorGenerator = include ("SectorGenerator")

include("callable")
include("utility")
include("goods")
local WaveUtility = include("waveutility")
local SpawnUtility = include("spawnutility")

function getDefaults()
    return {
        waves = {},
        firstSpawnTimer = 10,
        timerEnded = false,
        chatMessageSent = false,
        wavesStarted = false,
        initialEnemies = true,
        encounterJustStarted = false,
        waveSpawned = false,
        stashGenerated = false,
        waveNumber = 1,
    }
end

local data = getDefaults()


--sets the scenario
function initializeWaves()
    -- initialize scenario
    local generator = SectorGenerator(Sector():getCoordinates())
    local mat = generator:createAsteroidField()
    local stash = generator:createPirateStash(mat)
    data.stashGenerated = true
end

-- starts the encounter
-- is called from fakestash
function startEncounter()
    if onClient() then invokeServerFunction("startEncounter") return end
    data.waves = WaveUtility.getWaves()
    data.encounterJustStarted = true
end
callable(nil, "startEncounter")

function updateServer(timeStep)
        -- timer
        if data.encounterJustStarted then
            data.firstSpawnTimer = data.firstSpawnTimer - timeStep
        end

        if data.firstSpawnTimer <= 0 and not data.timerEnded then
            WaveUtility.createPirateWave(data.waves[data.waveNumber], onPiratesGenerated)
            data.timerEnded = true
        end

    if Sector().numPlayers >= 1 then
        if not data.stashGenerated then
            initializeWaves()
        end

        if data.waveSpawned == true then
            local numEnemies = WaveUtility.getNumEnemies()

            if numEnemies <= 1 then
                data.waveSpawned = false

                if data.waveNumber < WaveUtility.data.numWaves then
                    data.waveNumber = data.waveNumber + 1
                    WaveUtility.createPirateWave(data.waves[data.waveNumber], onPiratesGenerated)
                elseif data.waveNumber == WaveUtility.data.numWaves and not bossWaveSpawned then
                    WaveUtility.createPirateBossWave(onBossWaveGenerated)
                end
            end
        end
    end
end

-- callback for generator in wavegenerator. Needed here because it doesn't work when set in wavegenerator
function onPiratesGenerated(generated)
    SpawnUtility.addEnemyBuffs(generated)
    for _, ship in pairs(generated) do
        if valid(ship) then
            ship:setValue("is_wave", 1)
        end
    end

    data.waveSpawned = true
end

-- callback for generator in wavegenerator. Needed here because it doesn't work when set in wavegenerator
function onBossWaveGenerated(generated)
    SpawnUtility.addEnemyBuffs(generated)
    for _, ship in pairs(generated) do
        if valid(ship) then
            ship:setValue("is_wave", 1)
        end
    end
    local boss = generated[4]
    local bossLoot = Loot(boss.id)

    for _, turret in pairs(WaveUtility.generateTurrets()) do
        bossLoot:insert(turret)
    end
end

function secure()
    return {dat = data, wdata = WaveUtility.data}
end

function restore(data_in)
    data_in = data_in or {}

    data = data_in.dat or getDefaults()
    WaveUtility.data = data_in.wdata or {}
end
