package.path = package.path .. ";data/scripts/lib/?.lua"

include("randomext")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace EntityRadioChatter
EntityRadioChatter = {}

local data = {}
data.minFrequency = 45
data.maxFrequency = 65
data.timeToFirst = random():getInt(5, data.minFrequency)

local frequencyQueried

if onServer() then

function EntityRadioChatter.getUpdateInterval()
    if not frequencyQueried then
        frequencyQueried = true;
        return data.timeToFirst or data.minFrequency
    end

    return random():getInt(data.minFrequency, data.maxFrequency)
end

function EntityRadioChatter.initialize(lines, minFrequency, maxFrequency, timeToFirst)
    if not _restoring then
        data = lines
        data.minFrequency = minFrequency or data.minFrequency
        data.maxFrequency = maxFrequency or data.maxFrequency
        data.timeToFirst = timeToFirst or random():getInt(5, data.minFrequency)
    end
end

function EntityRadioChatter.update(timeStep)
    local message = randomEntry(random(), data)

    Sector():broadcastChatMessage(Entity(), ChatMessageType.Chatter, message)
end

function EntityRadioChatter.secure()
    return data
end

function EntityRadioChatter.restore(data_in)
    data = data_in
end


end

