-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace DelayedDelete
DelayedDelete = {}

if onServer() then

function DelayedDelete.initialize(time)
    local faction = Faction()
    if not faction or faction.isPlayer or faction.isAlliance then
        terminate()
        return
    end

    if time and not _restoring then
        DelayedDelete.time = time
        deferredCallback(time, "delete")
    else
        eprint("DelayedDelete: time is nil")
        terminate()
    end
end

function DelayedDelete.delete()
    Sector():deleteEntityJumped(Entity())
end

function DelayedDelete.secure()
    return {time = DelayedDelete.time}
end

function DelayedDelete.restore(data)
    DelayedDelete.time = data.time
    deferredCallback(DelayedDelete.time, "delete")
end

end
