
package.path = package.path .. ";data/scripts/lib/?.lua"
include ("factioneconomyutility")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace RestoreOnDelete
RestoreOnDelete = {}

if onServer() then

local factionIndex

function RestoreOnDelete.initialize()
    local entity = Entity()
    factionIndex = entity.factionIndex

    entity:registerCallback("onSetForDeletion", "onSetForDeletion")
end

function RestoreOnDelete.onSetForDeletion(entityId, deletionType)
    -- don't restore counter for destroyed entities
    if deletionType and deletionType == DeletionType.Destroyed then return end

    local faction = Faction(factionIndex)
    if not faction then return end

    FactionEconomyUtility.despawnMilitaryShips(faction, 1)
end

end
