
package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include ("randomext")
include ("galaxy")
include ("stringutility")
include ("faction")
include ("callable")

-- if this function returns false, the script will not be listed in the interaction window,
-- even though its UI may be registered
function interactionPossible(playerIndex, option)

    local player = Player(playerIndex)
    local self = Entity()

    local craft = player.craft
    if craft == nil then return false end

    local dist = craft:getNearestDistance(self)

    if dist < 20.0 then
        return true
    end

    return false, "You're not close enough to open the object."%_t
end

function initialize()
    local entity = Entity()

    if entity.title == "" then entity.title = "Smuggler's Cache"%_t end

end

-- create all required UI elements for the client side
function initUI()

    local res = getResolution()
    local size = vec2(800, 600)

    local menu = ScriptUI()
    window = menu:createWindow(Rect(vec2(0, 0), vec2(0, 0)))

    menu:registerWindow(window, "Open"%_t);
end

function onShowWindow()
    invokeServerFunction("startAlert")
    ScriptUI():stopInteraction()
end

function startAlert()
    Sector():broadcastChatMessage(Entity(), ChatMessageType.Chatter, "Alarm system initalized...Response forces will arrive soon...")
    Sector():invokeFunction("data/scripts/events/waveencounters/hiddentreasurewaves.lua", "startEncounter")
    print("test")
end
callable(nil, "startAlert")








