package.path = package.path .. ";data/scripts/lib/?.lua"

include ("stringutility")
include ("randomext")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace MissionBulletins
MissionBulletins = {}

if onServer() then

local r = Random(Seed(os.time()))

function MissionBulletins.initialize()
end

function MissionBulletins.getUpdateInterval()
    return 1
end

function MissionBulletins.updateServer(timeStep)
    MissionBulletins.updateBulletins(timeStep)
end

local updateFrequency = 60 * 60
local updateTime
function MissionBulletins.updateBulletins(timeStep)

    if not updateTime then
        -- by adding half the time here, we have a chance that a military outpost immediately has a bulletin
        updateTime = 0

        local minutesSimulated = r:getInt(10, 80)
        minutesSimulated = 65
        for i = 1, minutesSimulated do -- simulate bulletin posting / removing
            MissionBulletins.updateBulletins(60)
        end
    end

    updateTime = updateTime + timeStep

    -- don't execute the following code if the time hasn't exceeded the posting frequency
    if updateTime < updateFrequency then return end
    updateTime = updateTime - updateFrequency


    MissionBulletins.addOrRemoveMissionBulletin()
end

function MissionBulletins.addOrRemoveMissionBulletin()
    local scripts = MissionBulletins.getPossibleMissions()

    local scriptPath = MissionBulletins.getWeightedRandomEntry(r, scripts)
    local ok, bulletin = run(scriptPath, "getBulletin", Entity())

    if ok == 0 and bulletin then
        -- since in this case "add" can override "remove", adding a bulletin is slightly more likely than removing one
        local add = r:getFloat() < 0.15
        local remove = r:getFloat() < 0.25

        if add then
            -- add bulletins
            Entity():invokeFunction("bulletinboard", "postBulletin", bulletin)
        elseif remove then
            -- ... or remove bulletins
            Entity():invokeFunction("bulletinboard", "removeBulletin", bulletin.brief)
        end
    end
end

function MissionBulletins.getWeightedRandomEntry(random, scripts)
    -- ... determine which mission will be generated at this station
    local scriptsByWeight = {}

    for i, script in pairs(scripts) do
        if script then
            scriptsByWeight[i] = script.prob
        end
    end

    local i = selectByWeight(random, scriptsByWeight)
    return scripts[i].path
end

function MissionBulletins.getPossibleMissions()
    local station = Entity()
    local stationTitle = station.title

    local scripts = {}

    -- general mission that are available at every type of station
    table.insert(scripts, {path = "data/scripts/player/missions/freeslaves.lua", prob = 0.1})

    -- delivery and organize are done by tradingmanager.lua without getBulletin-Function
--    table.insert(scripts, {path = "data/scripts/player/missions/delivery.lua", prob = 0})
--    table.insert(scripts, {path = "data/scripts/player/missions/organizegoods.lua", prob = 0})



    -- use this to have missions only spawn at certain stations
    if stationTitle == "Habitat" then
        table.insert(scripts, {path = "data/scripts/player/missions/settlertreck/settlertreck.lua", prob = 0.1})
    end

    if stationTitle == "${faction} Headquarters" then
        table.insert(scripts, {path = "data/scripts/player/missions/settlertreck/settlertreck.lua", prob = 0.1})
        table.insert(scripts, {path = "data/scripts/player/missions/hideevidence.lua", prob = 0.2})
        table.insert(scripts, {path = "data/scripts/player/missions/exploresector/exploresector.lua", prob = 0.4})
        table.insert(scripts, {path = "data/scripts/player/missions/clearpiratesector.lua", prob = 0.4})
        table.insert(scripts, {path = "data/scripts/player/missions/clearxsotansector.lua", prob = 0.3})
    end

    if stationTitle == "Research Station" then
        table.insert(scripts, {path = "data/scripts/player/missions/exploresector/exploresector.lua", prob = 0.5})
    end

    if stationTitle == "Trading Post" then
        table.insert(scripts, {path = "data/scripts/player/missions/transfervessel.lua", prob = 0.05})
        table.insert(scripts, {path = "data/scripts/player/missions/investigatemissingfreighters.lua", prob = 0.1})
    end

    if stationTitle == "Military Outpost" then
        table.insert(scripts, {path = "data/scripts/player/missions/hideevidence.lua", prob = 0.2})
        table.insert(scripts, {path = "data/scripts/player/missions/exploresector/exploresector.lua", prob = 0.5})
        table.insert(scripts, {path = "data/scripts/player/missions/clearpiratesector.lua", prob = 0.4})
        table.insert(scripts, {path = "data/scripts/player/missions/clearxsotansector.lua", prob = 0.3})
        table.insert(scripts, {path = "data/scripts/player/missions/settlertreck/settlertreck.lua", prob = 0.2})
        table.insert(scripts, {path = "data/scripts/player/missions/coverretreat.lua", prob = 0.2})
    end

    if stationTitle == "Shipyard" then
        table.insert(scripts, {path = "data/scripts/player/missions/transfervessel.lua", prob = 0.5})
        table.insert(scripts, {path = "data/scripts/player/missions/investigatemissingfreighters.lua", prob = 0.1})
    end

    if stationTitle == "Repair Dock" then
        table.insert(scripts, {path = "data/scripts/player/missions/transfervessel.lua", prob = 0.2})
        table.insert(scripts, {path = "data/scripts/player/missions/investigatemissingfreighters.lua", prob = 0.1})

    end

    return scripts
end

end
