package.path = package.path .. ";data/scripts/lib/?.lua"
include ("utility")
include ("randomext")
include ("faction")
local ShopAPI = include ("shop")
local UpgradeGenerator = include("upgradegenerator")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace EquipmentDock
EquipmentDock = {}
EquipmentDock = ShopAPI.CreateNamespace()

-- if this function returns false, the script will not be listed in the interaction window,
-- even though its UI may be registered
function EquipmentDock.interactionPossible(playerIndex, option)
    return CheckFactionInteraction(playerIndex, -10000)
end

local function sortSystems(a, b)
    if a.rarity.value == b.rarity.value then
        return a.price > b.price
    end

    return a.rarity.value > b.rarity.value
end

function EquipmentDock.shop:addItems()

    local systems = {}
    EquipmentDock.addStaticOffers(systems)

    local generator = UpgradeGenerator()
    local counter = 0
    while counter < 9 do

        local x, y = Sector():getCoordinates()
        local rarities = generator:getSectorRarityDistribution(x, y)

        rarities[4] = rarities[4] * 0.25 -- strongly reduced probability for normal high rarity equipment
        rarities[5] = 0 -- no legendaries in equipment dock

        local prototype = generator:generateSystem(nil, rarities)

        local script = prototype.script
        local rarity = prototype.rarity
        local seed = generator:getUpgradeSeed(x, y, script, rarity)

        local system = SystemUpgradeTemplate(script, rarity, seed)

        -- only add "petty" upgrades with a 25% chance
        if system.rarity.value >= 0 or random():test(0.25) then
            table.insert(systems, system)
            counter = counter + 1
        end
    end

    table.sort(systems, sortSystems)

    for _, system in pairs(systems) do
        EquipmentDock.shop:add(system, getInt(1, 2))
    end
end

-- adds most commonly used upgrades
function EquipmentDock.addStaticOffers(systems)

    if not systems then return end

    local rarities = {RarityType.Common, RarityType.Uncommon}
    local rand = random()
    local possible =
    {
        "data/scripts/systems/arbitrarytcs.lua",
        "data/scripts/systems/energybooster.lua",
        "data/scripts/systems/hyperspacebooster.lua",
        "data/scripts/systems/radarbooster.lua",
    }

    for _, script in pairs(possible) do
        local rarity = randomEntry(rand, rarities)
        table.insert(systems, SystemUpgradeTemplate(script, Rarity(rarity), rand:createSeed()))
    end
end

-- sets the special offer that gets updated every 20 minutes
function EquipmentDock.shop:onSpecialOfferSeedChanged()
    local generator = UpgradeGenerator(EquipmentDock.shop:generateSeed())

    local x, y = Sector():getCoordinates()
    local rarities = generator:getSectorRarityDistribution(x, y)

    rarities[-1] = 0
    rarities[0] = 0
    rarities[1] = 0
    rarities[4] = rarities[4] * 0.25 -- strongly reduced probability for normal high rarity equipment
    rarities[5] = 0 -- no legendaries in equipment dock

    local prototype = generator:generateSystem(nil, rarities)

    local script = prototype.script
    local rarity = prototype.rarity
    local seed = generator:getUpgradeSeed(x, y, script, rarity)

    EquipmentDock.shop:setSpecialOffer(SystemUpgradeTemplate(script, rarity, seed))
end

function EquipmentDock.initialize()
    EquipmentDock.shop:initialize("Equipment Dock"%_t)

    if onClient() and EntityIcon().icon == "" then
        EntityIcon().icon = "data/textures/icons/pixel/sdwhite.png"
    end

    Entity():setValue("remove_permanent_upgrades", true)
end

function EquipmentDock.initUI()
    EquipmentDock.shop:initUI("Trade Equipment"%_t, "Equipment Dock"%_t, "Upgrades"%_t, "data/textures/icons/bag_circuitry.png")
end

function EquipmentDock.initializationFinished()
    -- use the initilizationFinished() function on the client since in initialize() we may not be able to access Sector scripts on the client
    if onClient() then
        local ok, r = Sector():invokeFunction("radiochatter", "addSpecificLines", Entity().id.string,
        {
            "That's sold out, sorry."%_t,
            "Problems with pirates? No more with our weaponry!"%_t,
            "Equipment of all sorts, for a great price! No refunds."%_t,
            "No refunds."%_t,
            "Guns Guns Guns!"%_t,
            "Buy turrets! Your crew will thank you for it!"%_t,
            "Only the best turrets, upgrades and fighters!"%_t,
            "Show the Xsotan who's boss with our chain guns!"%_t,
            "Not enough resources? Get a mining laser and change that!"%_t,
            "Tired of being chronically unarmed? We're here for you!"%_t,
            "Our fighters are ready for you! Pilots not included."%_t,
            "Pilots not included."%_t,
            "Gunners not included."%_t,
        })
    end
end
