package.path = package.path .. ";data/scripts/lib/?.lua"

include ("randomext")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace Blinker
Blinker = {}
local self = Blinker

self.enabledCounter = 0

function Blinker.initialize()
    if onServer() then
        local entity = Entity()
        entity:registerCallback("onHullHit", "onHit")
        entity:registerCallback("onShieldHit", "onHit")
    end
end

function Blinker.getUpdateInterval()
    if self.enabledCounter > 12 then
        return random():getFloat(0.5, 3)
    elseif self.enabledCounter > 7 then
        return random():getFloat(3, 5)
    end

    return random():getFloat(5, 7)
end

function Blinker.updateServer(timeStep)
    if self.enabledCounter <= 0 then return end
    self.enabledCounter = self.enabledCounter - timeStep

    local entity = Entity()
    local distance = entity.radius * (2 + random():getFloat(0, 3))
    local direction = random():getDirection()

    broadcastInvokeClientFunction("animation", direction)

    entity.translation = dvec3(entity.translationf + direction * distance)
end

function Blinker.animation(direction)
    Sector():createHyperspaceAnimation(Entity(), direction, ColorRGB(0.6, 0.5, 0.3), 0.2)
end

function Blinker.onHit()
    if self.enabledCounter < 7 then
        deferredCallback(random():getFloat(0, 1.5), "updateServer", 0)
    end

    if self.enabledCounter < 0.5 and random():test(0.5) then
        self.cascade(6)
    elseif random():test(0.01) then
        self.cascade(6)
    end

    self.enabledCounter = 15

end

function Blinker.cascade(amount)
    if amount == 0 then return end

    deferredCallback(0.4, "cascade", amount - 1)
    self.updateServer(0)
end
