using RimWorld;
using Verse;
using Verse.AI;

namespace rjw
{
	/// <summary>
	/// Assigns a pawn to breed animal(active)
	/// </summary>
	public class WorkGiver_BestialityForMale : WorkGiver_Sexchecks
	{
		public override bool MoreChecks(Pawn pawn, Thing t, bool forced = false)
		{
			//Log.Message("[RJW]" + this.GetType().ToString() + " base checks: pass");
			if (!RJWSettings.bestiality_enabled) return false;

			Pawn target = t as Pawn;
			if (!WorkGiverChecks(pawn, t, forced))
				return false;

			if (!xxx.can_be_fucked(target))
			{
				if (RJWSettings.DevMode) JobFailReason.Is("target cant be fucked");
				return false;
			}

			if (!pawn.IsDesignatedHero())
				if (!RJWSettings.WildMode)
				{
					if (!xxx.is_zoophile(pawn) && !xxx.is_frustrated(pawn))
					{
						if (RJWSettings.DevMode) JobFailReason.Is("not willing to have sex with animals");
						return false;
					}
					if (xxx.need_some_sex(pawn) < 2f)
					{
						if (RJWSettings.DevMode) JobFailReason.Is("not horny enough");
						return false;
					}
					if (!xxx.is_healthy_enough(target)
						|| !xxx.is_not_dying(target) && (xxx.is_bloodlust(pawn) || xxx.is_psychopath(pawn) || xxx.has_quirk(pawn, "Somnophile")))
					{
						if (RJWSettings.DevMode) JobFailReason.Is("target not healthy enough");
						return false;
					}

					//Log.Message("[RJW]WorkGiver_BestialityForMale::" + SexAppraiser.would_fuck_animal(pawn, target));
					if (SexAppraiser.would_fuck_animal(pawn, target) < 0.1f)
					{
						return false;
					}
					//add some more fancy conditions from JobGiver_Bestiality?
				}

			//Log.Message("[RJW]" + this.GetType().ToString() + ":: extended checks: can start sex");
			return true;
		}

		public override bool WorkGiverChecks(Pawn pawn, Thing t, bool forced = false)
		{
			Pawn target = t as Pawn;
			if (!xxx.is_animal(target))
			{
				return false;
			}
			if (!xxx.can_fuck(pawn))
			{
				if (RJWSettings.DevMode) JobFailReason.Is("cant fuck");
				return false;
			}
			return true;
		}

		public override Job JobOnThing(Pawn pawn, Thing t, bool forced = false)
		{
			return JobMaker.MakeJob(xxx.bestiality, t);
		}
	}
}