using System;
using UnityEngine;
using Verse;

namespace rjw
{
	public class RJWHookupSettings : ModSettings
	{
		public static bool HookupsEnabled = true;
		public static bool NoHookupsDuringWorkHours = true;
		public static bool ColonistsCanHookup = true;
		public static bool ColonistsCanHookupWithVisitor = false;
		public static bool CanHookupWithPrisoner = false;
		public static bool VisitorsCanHookupWithColonists = false;
		public static bool VisitorsCanHookupWithVisitors = true;
		public static bool PrisonersCanHookupWithNonPrisoner = false;
		public static bool PrisonersCanHookupWithPrisoner = false;
		public static float HookupChanceForNonNymphos = 0.3f;
		public static float MinimumFuckabilityToHookup = 0.1f;
		public static float MinimumAttractivenessToHookup = 0.5f;
		public static float MinimumRelationshipToHookup = 20f;

		public static bool NymphosCanPickAnyone = true;
		public static bool NymphosCanCheat = true;
		public static bool NymphosCanHomewreck = true;
		public static bool NymphosCanHomewreckReverse = true;


		public static void DoWindowContents(Rect inRect)
		{
			MinimumFuckabilityToHookup = Mathf.Clamp(MinimumFuckabilityToHookup, 0.1f, 1f);
			MinimumAttractivenessToHookup = Mathf.Clamp(MinimumAttractivenessToHookup, 0.0f, 1f);
			MinimumRelationshipToHookup = Mathf.Clamp(MinimumRelationshipToHookup, -100, 100);

			Listing_Standard listingStandard = new Listing_Standard();
			listingStandard.ColumnWidth = inRect.width / 2.05f;
			listingStandard.Begin(inRect);
			listingStandard.Gap(4f);

			// Casual sex settings
			listingStandard.CheckboxLabeled("SettingHookupsEnabled".Translate(), ref HookupsEnabled, "SettingHookupsEnabled_desc".Translate());
			listingStandard.CheckboxLabeled("SettingNoHookupsDuringWorkHours".Translate(), ref NoHookupsDuringWorkHours, "SettingNoHookupsDuringWorkHours_desc".Translate());

			listingStandard.Gap(10f);
			listingStandard.CheckboxLabeled("SettingColonistsCanHookup".Translate(), ref ColonistsCanHookup, "SettingColonistsCanHookup_desc".Translate());
			listingStandard.CheckboxLabeled("SettingColonistsCanHookupWithVisitor".Translate(), ref ColonistsCanHookupWithVisitor, "SettingColonistsCanHookupWithVisitor_desc".Translate());
			listingStandard.CheckboxLabeled("SettingVisitorsCanHookupWithColonists".Translate(), ref VisitorsCanHookupWithColonists, "SettingVisitorsCanHookupWithColonists_desc".Translate());
			listingStandard.CheckboxLabeled("SettingVisitorsCanHookupWithVisitors".Translate(), ref VisitorsCanHookupWithVisitors, "SettingVisitorsCanHookupWithVisitors_desc".Translate());

			listingStandard.Gap(10f);
			listingStandard.CheckboxLabeled("SettingPrisonersCanHookupWithNonPrisoner".Translate(), ref PrisonersCanHookupWithNonPrisoner, "SettingPrisonersCanHookupWithNonPrisoner_desc".Translate());
			listingStandard.CheckboxLabeled("SettingPrisonersCanHookupWithPrisoner".Translate(), ref PrisonersCanHookupWithPrisoner, "SettingPrisonersCanHookupWithPrisoner_desc".Translate());
			listingStandard.CheckboxLabeled("SettingCanHookupWithPrisoner".Translate(), ref CanHookupWithPrisoner, "SettingCanHookupWithPrisoner_desc".Translate());

			listingStandard.Gap(10f);
			listingStandard.CheckboxLabeled("SettingNymphosCanPickAnyone".Translate(), ref NymphosCanPickAnyone, "SettingNymphosCanPickAnyone_desc".Translate());
			listingStandard.CheckboxLabeled("SettingNymphosCanCheat".Translate(), ref NymphosCanCheat, "SettingNymphosCanCheat_desc".Translate());
			listingStandard.CheckboxLabeled("SettingNymphosCanHomewreck".Translate(), ref NymphosCanHomewreck, "SettingNymphosCanHomewreck_desc".Translate());
			listingStandard.CheckboxLabeled("SettingNymphosCanHomewreckReverse".Translate(), ref NymphosCanHomewreckReverse, "SettingNymphosCanHomewreckReverse_desc".Translate());

			listingStandard.Gap(10f);
			listingStandard.Label("SettingHookupChanceForNonNymphos".Translate() + ": " + (int)(HookupChanceForNonNymphos * 100) + "%", -1f, "SettingHookupChanceForNonNymphos_desc".Translate());
			HookupChanceForNonNymphos = listingStandard.Slider(HookupChanceForNonNymphos, 0.0f, 1.0f);
			listingStandard.Label("SettingMinimumFuckabilityToHookup".Translate() + ": " + (int)(MinimumFuckabilityToHookup * 100) + "%", -1f, "SettingMinimumFuckabilityToHookup_desc".Translate());
			MinimumFuckabilityToHookup = listingStandard.Slider(MinimumFuckabilityToHookup, 0.1f, 1.0f); // Minimum must be above 0.0 to avoid breaking SexAppraiser.would_fuck()'s hard-failure cases that return 0f
			listingStandard.Label("SettingMinimumAttractivenessToHookup".Translate() + ": " + (int)(MinimumAttractivenessToHookup * 100) + "%", -1f, "SettingMinimumAttractivenessToHookup_desc".Translate());
			MinimumAttractivenessToHookup = listingStandard.Slider(MinimumAttractivenessToHookup, 0.0f, 1.0f);
			listingStandard.Label("SettingMinimumRelationshipToHookup".Translate() + ": " + (MinimumRelationshipToHookup), -1f, "SettingMinimumRelationshipToHookup_desc".Translate());
			MinimumRelationshipToHookup = listingStandard.Slider((int)MinimumRelationshipToHookup, -100f, 100f);

			listingStandard.NewColumn();
			listingStandard.Gap(4f);

			listingStandard.End();
		}

		public override void ExposeData()
		{
			base.ExposeData();
			Scribe_Values.Look(ref HookupsEnabled, "SettingHookupsEnabled", true, true);
			Scribe_Values.Look(ref NoHookupsDuringWorkHours, "NoHookupsDuringWorkHours", true, true);
			Scribe_Values.Look(ref ColonistsCanHookup, "SettingColonistsCanHookup", false, true);
			Scribe_Values.Look(ref ColonistsCanHookupWithVisitor, "SettingColonistsCanHookupWithVisitor", false, true);
			Scribe_Values.Look(ref VisitorsCanHookupWithColonists, "SettingVisitorsCanHookupWithColonists", false, true);
			Scribe_Values.Look(ref VisitorsCanHookupWithVisitors, "SettingVisitorsCanHookupWithVisitors", true, true);

			// Prisoner settings
			Scribe_Values.Look(ref CanHookupWithPrisoner, "SettingCanHookupWithPrisoner", false, true);
			Scribe_Values.Look(ref PrisonersCanHookupWithNonPrisoner, "SettingPrisonersCanHookupWithNonPrisoner", false, true);
			Scribe_Values.Look(ref PrisonersCanHookupWithPrisoner, "SettingPrisonersCanHookupWithPrisoner", false, true);

			// Nympho settings
			Scribe_Values.Look(ref NymphosCanPickAnyone, "SettingNymphosCanPickAnyone", true, true);
			Scribe_Values.Look(ref NymphosCanCheat, "SettingNymphosCanCheat", true, true);
			Scribe_Values.Look(ref NymphosCanHomewreck, "SettingNymphosCanHomewreck", true, true);
			Scribe_Values.Look(ref NymphosCanHomewreckReverse, "SettingNymphosCanHomewreckReverse", true, true);

			Scribe_Values.Look(ref HookupChanceForNonNymphos, "SettingHookupChanceForNonNymphos", 0.3f, true);
			Scribe_Values.Look(ref MinimumFuckabilityToHookup, "SettingMinimumFuckabilityToHookup", 0.1f, true);
			Scribe_Values.Look(ref MinimumAttractivenessToHookup, "SettingMinimumAttractivenessToHookup", 0.5f, true);
			Scribe_Values.Look(ref MinimumRelationshipToHookup, "SettingMinimumRelationshipToHookup", 20f, true);
		}
	}
}
