﻿using HarmonyLib;
using Verse;

namespace rjw
{
	[HarmonyPatch(typeof(PawnGenerator), "GenerateTraits")]
	internal static class Patch_PawnGenerator_GenerateTraits
	{
		[HarmonyPostfix]
		static void After_GenerateTraits(Pawn pawn, PawnGenerationRequest request)
		{
			// This needs to be first because the trait mods can affect sexualization.
			if (Nymph_Generator.IsNymph(request))
			{
				Nymph_Generator.set_story(pawn);
			}

			if (CompRJW.Comp(pawn) != null && CompRJW.Comp(pawn).orientation == Orientation.None)
			{
				CompRJW.Comp(pawn).Sexualize(pawn);
			}
		}
	}
}
