﻿using HarmonyLib;
using Verse;
using RimWorld;
using System;
using System.Collections.Generic;

namespace rjw.Source.Harmony
{
	[HarmonyPatch(typeof(PawnGenerator), "GenerateNewPawnInternal")]
	static class Patch_PawnGenerator_GenerateNewPawnInternal
	{
		// Debug action "Spawn Pawn" doesn't always use the kinddef so will not always spawn a nymph.
		[HarmonyPrefix]
		static void Before_GenerateNewPawnInternal(ref PawnGenerationRequest request)
		{
			if (Nymph_Generator.IsNymph(request))
			{
				//public PawnGenerationRequest(
				//	PawnKindDef kind,
				//	Faction faction = null,
				//	PawnGenerationContext context = PawnGenerationContext.NonPlayer,
				//	int tile = -1,
				//	bool forceGenerateNewPawn = false,
				//	bool newborn = false,
				//	bool allowDead = false,
				//	bool allowDowned = false,
				//	bool canGeneratePawnRelations = true,
				//	bool mustBeCapableOfViolence = false,
				//	float colonistRelationChanceFactor = 1,
				//	bool forceAddFreeWarmLayerIfNeeded = false,
				//	bool allowGay = true,
				//	bool allowFood = true,
				//	bool allowAddictions = true,
				//	bool inhabitant = false,
				//	bool certainlyBeenInCryptosleep = false,
				//	bool forceRedressWorldPawnIfFormerColonist = false,
				//	bool worldPawnFactionDoesntMatter = false,
				//	float biocodeWeaponChance = 0,
				//	Pawn extraPawnForExtraRelationChance = null,
				//	float relationWithExtraPawnChanceFactor = 1,
				//	Predicate<Pawn> validatorPreGear = null,
				//	Predicate<Pawn> validatorPostGear = null,
				//	IEnumerable<TraitDef> forcedTraits = null,
				//	IEnumerable<TraitDef> prohibitedTraits = null,
				//	float? minChanceToRedressWorldPawn = null,
				//	float? fixedBiologicalAge = null,
				//	float? fixedChronologicalAge = null,
				//	Gender? fixedGender = null,
				//	float? fixedMelanin = null, 
				//	string fixedLastName = null, 
				//	string fixedBirthName = null, 
				//	RoyalTitleDef fixedTitle = null);

				request = new PawnGenerationRequest(
					Nymph_Generator.GetFixedNymphPawnKindDef(),
					request.Faction,
					request.Context,
					request.Tile,   // tile(default is -1)
					request.ForceGenerateNewPawn, // Force generate new pawn
					request.Newborn, // Newborn
					request.AllowDead, // Allow dead
					request.AllowDowned, // Allow downed
					false, // Can generate pawn relations
					request.MustBeCapableOfViolence, // Must be capable of violence
					request.ColonistRelationChanceFactor, // Colonist relation chance factor
					request.ForceAddFreeWarmLayerIfNeeded, // Force add free warm layer if needed
					request.AllowGay, // Allow gay
					request.AllowFood, // Allow food
					request.AllowAddictions, // Allow Addictions
					request.Inhabitant, // Inhabitant
					request.CertainlyBeenInCryptosleep, // Been in Cryosleep
					request.ForceRedressWorldPawnIfFormerColonist, //forceRedressWorldPawnIfFormerColonist
					request.WorldPawnFactionDoesntMatter, //worldPawnFactionDoesntMatter
					request.BiocodeWeaponChance,
					request.ExtraPawnForExtraRelationChance,
					request.RelationWithExtraPawnChanceFactor,
					Nymph_Generator.IsNymphBodyType, // Validator
					Nymph_Generator.IsNymphBodyType, // Validator
					request.ForcedTraits,
					request.ProhibitedTraits,
					request.MinChanceToRedressWorldPawn,
					request.FixedBiologicalAge, // Fixed biological age
					request.FixedChronologicalAge, // Fixed chronological age
					request.FixedGender ?? Nymph_Generator.RandomNymphGender(), // Fixed gender
					request.FixedMelanin, // Fixed melanin
					request.FixedLastName, // Fixed last name
					request.FixedBirthName, // Fixed birth name
					request.FixedTitle
					);
			}
		}

		[HarmonyPostfix]
		static void After_GenerateNewPawnInternal(ref PawnGenerationRequest request, ref Pawn __result)
		{
			if (Nymph_Generator.IsNymph(request))
			{
				Nymph_Generator.set_skills(__result);
			}
		}
	}
}
