using System.Text;
using Verse;
using RimWorld;
using Multiplayer.API;

namespace rjw
{
	/// <summary>
	/// Comp for rjw hediff parts
	/// </summary>
	public class CompHediffBodyPart : HediffComp
	{
		public string Size;					//eventually replace with below, maybe
		public float SizeBase;				//base size when part created, someday alter by operation
		public float SizeOwner = 0;			//modifier of 1st owner race body size
		public float EffSize;				//SizeBase x SizeOwner
		public string FluidType;			//cummies/milk - insectjelly/honey etc
		public float FluidAmmount;			//ammount of Milk/Ejaculation/Wetness
		public string Eggs;                 //for ovi eggs, maybe

		/// <summary>
		/// part size in labels
		/// </summary>
		public override string CompLabelInBracketsExtra
		{
			get
			{
				if (Size != "")
					return Size;

				return null;
			}
		}

		/// <summary>
		/// save data
		/// </summary>
		public override void CompExposeData()
		{
			base.CompExposeData();
			Scribe_Values.Look(ref Size, "Size");
			Scribe_Values.Look(ref SizeBase, "SizeBase");
			Scribe_Values.Look(ref SizeOwner, "SizeOwner");
			Scribe_Values.Look(ref FluidType, "FluidType");
			Scribe_Values.Look(ref FluidAmmount, "FluidAmmount");
			Scribe_Values.Look(ref Eggs, "Eggs");

		}

		/// <summary>
		/// show part info in healthab
		/// </summary>
		public override string CompTipStringExtra
		{
			get
			{
				if (SizeOwner == 0)
					initComp();

				//Log.Message("[RJW] CompTipStringExtra " + xxx.get_pawnname(Pawn) + " " + parent.def.defName);
				StringBuilder stringBuilder = new StringBuilder();
				if (parent.def.defName.ToLower().Contains("breasts"))
				{
					if (FluidAmmount != 0)
					{
						if (FluidType != "")
							stringBuilder.AppendLine("Milk: " + FluidType);
						stringBuilder.AppendLine("Amount: " + FluidAmmount.ToString("F2"));
					}
					//if (Size != "")
					//	stringBuilder.AppendLine("Size: " + Size);
				}
				else if (parent.def.defName.ToLower().Contains("penis") || parent.def.defName.ToLower().Contains("vagina"))
				{
					if (FluidAmmount != 0)
					{
						if (FluidType != "")
							stringBuilder.AppendLine("Cum: " + FluidType);
						if (parent.def.defName.ToLower().Contains("penis"))
							stringBuilder.AppendLine("Ejaculation: " + FluidAmmount.ToString("F2") + "ml");
						if (parent.def.defName.ToLower().Contains("vagina"))
							stringBuilder.AppendLine("Wetness: " + FluidAmmount.ToString("F2"));
					}
					//if (Size != "")
					//	stringBuilder.AppendLine("Size: " + Size);
				}
				else if (parent.def.defName.ToLower().Contains("anus"))
				{
					if (FluidType != "" && FluidAmmount != 0)
					{
						stringBuilder.AppendLine("Lube: " + FluidType);
						if (parent.def.defName.ToLower().Contains("anus"))
							stringBuilder.AppendLine("Wetness: " + FluidAmmount.ToString("F2"));
					}
					//if (Size != "")
					//	stringBuilder.AppendLine("Size: " + Size);
				}
				else if (parent.def.defName.ToLower().Contains("ovi"))
				{
					if (Eggs != "")
						stringBuilder.AppendLine("Eggs: " + Eggs);
				}

				return stringBuilder.ToString();
			}
		}

		public void updatesize(float value = 0)
		{
			if (value == 0)
			{
				// CompHediff.Size = CompThing.Size;
				//Log.Message("CompHediffBodyPart::updatesize increase( " + (SizeOwner > parent.pawn.BodySize) + " )");
				if (SizeOwner > parent.pawn.BodySize)
				{
					// decrease
					value = (SizeOwner - parent.pawn.BodySize) / SizeOwner;
					//Log.Message("CompHediffBodyPart::updatesize - decrease");
					//Log.Message("CompHediffBodyPart::updatesize( " + SizeOwner + " )");
					//Log.Message("CompHediffBodyPart::updatesize( " + parent.pawn.BodySize + " )");
					//Log.Message("CompHediffBodyPart::updatesize - value");
					//Log.Message("CompHediffBodyPart::updatesize( " + value + " )");

					value = SizeBase * (1 + value);
				}
				else
				{
					// increase
					value = (parent.pawn.BodySize - SizeOwner) / parent.pawn.BodySize;
					//Log.Message("CompHediffBodyPart::updatesize - increase");
					//Log.Message("CompHediffBodyPart::updatesize( " + SizeOwner + " )");
					//Log.Message("CompHediffBodyPart::updatesize( " + parent.pawn.BodySize + " )");
					//Log.Message("CompHediffBodyPart::updatesize - value");
					//Log.Message("CompHediffBodyPart::updatesize( " + value + " )");

					value = SizeBase * (1 - value);
				}

				//Log.Message("CompHediffBodyPart::updatesize - value offset");
				//Log.Message("CompHediffBodyPart::updatesize( " + value + " )");
			}
			else
			{
			// idk do something here? (operation etc)
			}
			//Log.Message("CompHediffBodyPart::updatesize - severity");
			//Log.Message("CompHediffBodyPart::updatesize( " + parent.Severity + " )");

			parent.Severity = value;
			//Log.Message("CompHediffBodyPart::updatesize( " + parent.Severity + " )");
		}

		/// <summary>
		/// fill comp data
		/// </summary>
		[SyncMethod]
		public void initComp(Pawn pawn = null)
		{
			if (pawn == null)
				pawn = parent.pawn;

			double value = SexPartAdder.GenderTechLevelCheck(pawn);
			bool trap = false;
			while (value == 0)
			{
				value = SexPartAdder.GenderTechLevelCheck(pawn);
			};

			{
				if (parent.def.defName.ToLower().Contains("breast"))
				{
					//TODO: replace with cups or not
					FluidType = "Milk";
					FluidAmmount = 0;

					if (pawn.gender == Gender.Male && RJWSettings.MaleTrap)
						if (pawn.Faction != null && !xxx.is_animal(pawn)) //null faction throws error
						{
							//natives/spacer futa
							float chance = (int)pawn.Faction.def.techLevel < 5 ? RJWSettings.futa_natives_chance : RJWSettings.futa_spacers_chance;
							//nymph futa gender
							chance = xxx.is_nympho(pawn) ? RJWSettings.futa_nymph_chance : chance;

							if (Rand.Chance(chance))
							{
								//make trap
								trap = true;
							}
						}

					if (pawn.gender == Gender.Male && !trap)
						value = 0.01f;

					SizeBase = (float)value;

					if (value < 0.05)
						Size = "Flat";
					else if (value < 0.20)
						Size = "Small";
					else if (value < 0.70)
						Size = "Average";
					else if (value < 0.80)
						Size = "Large";
					else if (value < 0.90)
						Size = "Huge";

					if (parent.def.defName == Genital_Helper.hydraulic_breasts.defName ||
						parent.def.defName == Genital_Helper.bionic_breasts.defName || 
						parent.def.defName == Genital_Helper.archotech_breasts.defName)
					{
						Size = "Average";
						SizeBase = 0.5f;
					}
				}
				else if (parent.def.defName.ToLower().Contains("penis"))
				{
					FluidType = "Cum";
					FluidAmmount = (float)value * 10 * 2;
					SizeBase = (float)value;

					if (value < 0.05)
						Size = "Micro";
					else if (value < 0.20)
						Size = "Small";
					else if (value < 0.70)
						Size = "Average";
					else if (value < 0.80)
						Size = "Big";
					else if (value < 0.90)
						Size = "Huge";

					if (parent.def.defName == Genital_Helper.hydraulic_penis.defName ||
						parent.def.defName == Genital_Helper.bionic_penis.defName || 
						parent.def.defName == Genital_Helper.archotech_penis.defName)
					{
						Size = "Average";
						SizeBase = 0.5f;
					}
				}
				else if (parent.def.defName.ToLower().Contains("vagina"))
				{
					FluidType = "Cum";
					FluidAmmount = (float)value * 10;
					SizeBase = (float)value;

					if (value < 0.05)
						Size = "Micro";
					else if (value < 0.20)
						Size = "Tight";
					else if (value < 0.70)
						Size = "Average";
					else if (value < 0.80)
						Size = "Loose";
					else if (value < 0.90)
						Size = "Gaping";

					if (parent.def.defName == Genital_Helper.hydraulic_vagina.defName ||
						parent.def.defName == Genital_Helper.bionic_vagina.defName ||
						parent.def.defName == Genital_Helper.archotech_vagina.defName)
					{
						Size = "Average";
						SizeBase = 0.5f;
					}
				}
				else if (parent.def.defName.ToLower().Contains("anus"))
				{
					FluidType = "";
					FluidAmmount = 0;
					SizeBase = (float)value;

					//TODO move this to severity
					if (value < 0.05)
						Size = "Micro";
					else if (value < 0.20)
						Size = "Tight";
					else if (value < 0.70)
						Size = "Average";
					else if (value < 0.80)
						Size = "Loose";
					else if (value < 0.90)
						Size = "Gaping";

					if (parent.def.defName == Genital_Helper.hydraulic_anus.defName ||
						parent.def.defName == Genital_Helper.bionic_anus.defName ||
						parent.def.defName == Genital_Helper.archotech_anus.defName)
					{
						Size = "Average";
						SizeBase = 0.5f;
					}
				}
				else if (parent.def.defName.ToLower().Contains("tentacle"))
				{
					FluidType = "Cum";
					value *= 2;
					FluidAmmount = (float)value * 10 * 2;
					SizeBase = (float)value;

					if (value < 0.05)
						Size = "Micro";
					else if (value < 0.20)
						Size = "Small";
					else if (value < 0.70)
						Size = "Average";
					else if (value < 0.80)
						Size = "Big";
					else if (value < 0.90)
						Size = "Huge";
				}
				else if ((parent.def.defName.ToLower().Contains("ovi")))
				{
					Eggs = pawn?.kindDef?.label ?? "";
					Size = "";
					SizeBase = 0.5f;
					FluidType = ThingDefOf.InsectJelly.label;
					FluidAmmount = 0;
				}

				SizeOwner = pawn.BodySize;
				EffSize = SizeOwner*SizeBase;
				updatesize();
			}
		}
	}
}