﻿using System;
using System.Collections.Generic;
using System.Linq;
using Verse;
using Multiplayer.API;

namespace rjw
{
	class RaceGroupDef_Helper
	{
		public static readonly IDictionary<SexPartType, BodyPartDef> BodyPartDefBySexPartType = new Dictionary<SexPartType, BodyPartDef>();

		/// <summary>
		/// Cache for TryGetRaceGroupDef.
		/// </summary>
		public static readonly IDictionary<PawnKindDef, RaceGroupDef> RaceGroupByPawnKind = new Dictionary<PawnKindDef, RaceGroupDef>();

		static RaceGroupDef_Helper()
		{
			BodyPartDefBySexPartType.Add(SexPartType.Anus, xxx.anusDef);
			BodyPartDefBySexPartType.Add(SexPartType.FemaleBreast, xxx.breastsDef);
			BodyPartDefBySexPartType.Add(SexPartType.FemaleGenital, xxx.genitalsDef);
			BodyPartDefBySexPartType.Add(SexPartType.MaleBreast, xxx.breastsDef);
			BodyPartDefBySexPartType.Add(SexPartType.MaleGenital, xxx.genitalsDef);
		}

		static bool IsThisMod(Def def)
		{
			var rjwContent = LoadedModManager.RunningMods.Single(pack => pack.Name == "RimJobWorld");
			return rjwContent.AllDefs.Contains(def);
		}

		/// <summary>
		/// Returns the best match RaceGroupDef for the given pawn, or null if none is found.
		/// </summary>
		static RaceGroupDef GetRaceGroupDefInternal(Pawn pawn)
		{
			var kindDef = pawn.kindDef;
			var raceName = kindDef.race.defName;
			var pawnKindName = kindDef.defName;
			var groups = DefDatabase<RaceGroupDef>.AllDefs;

			var kindMatches = groups.Where(group => group.pawnKindNames?.Contains(pawnKindName) ?? false).ToList();
			var raceMatches = groups.Where(group => group.raceNames?.Contains(raceName) ?? false).ToList();
			var count = kindMatches.Count() + raceMatches.Count();
			if (count == 0)
			{
				//Log.Message($"[RJW] Pawn named '{pawn.Name}' matched no RaceGroupDef. If you want to create a matching RaceGroupDef you can use the raceName '{raceName}' or the pawnKindName '{pawnKindName}'.");
				return null;
			}
			else if (count == 1)
			{
				// Log.Message($"[RJW] Pawn named '{pawn.Name}' matched 1 RaceGroupDef.");
				return kindMatches.Concat(raceMatches).Single();
			}
			else
			{
				// Log.Message($"[RJW] Pawn named '{pawn.Name}' matched {count} RaceGroupDefs.");

				// If there are multiple RaceGroupDef matches, choose one of them.
				// First prefer defs NOT defined in rjw.
				// Then prefer a match by kind over a match by race.
				return kindMatches.FirstOrDefault(match => !IsThisMod(match))
					?? raceMatches.FirstOrDefault(match => !IsThisMod(match))
					?? kindMatches.FirstOrDefault()
					?? raceMatches.FirstOrDefault();
			}
		}

		public static bool TryGetRaceGroupDef(Pawn pawn, out RaceGroupDef raceGroupDef)
		{
			if (RaceGroupByPawnKind.TryGetValue(pawn.kindDef, out raceGroupDef))
			{
				return raceGroupDef != null;
			}
			else
			{
				raceGroupDef = GetRaceGroupDefInternal(pawn);
				RaceGroupByPawnKind.Add(pawn.kindDef, raceGroupDef);
				return raceGroupDef != null;
			}
		}

		public static List<string> GetParts(RaceGroupDef raceGroupDef, SexPartType sexPartType)
		{
			switch(sexPartType)
			{
				case SexPartType.Anus:
					return raceGroupDef.anuses;
				case SexPartType.FemaleBreast:
					return raceGroupDef.femaleBreasts;
				case SexPartType.FemaleGenital:
					return raceGroupDef.femaleGenitals;
				case SexPartType.MaleBreast:
					return raceGroupDef.maleBreasts;
				case SexPartType.MaleGenital:
					return raceGroupDef.maleGenitals;
				default:
					throw new ApplicationException($"Unrecognized sexPartType: {sexPartType}");
			}
		}

		public static List<float> GetPartsChances(RaceGroupDef raceGroupDef, SexPartType sexPartType)
		{
			switch(sexPartType)
			{
				case SexPartType.Anus:
					return raceGroupDef.chanceanuses;
				case SexPartType.FemaleBreast:
					return raceGroupDef.chancefemaleBreasts;
				case SexPartType.FemaleGenital:
					return raceGroupDef.chancefemaleGenitals;
				case SexPartType.MaleBreast:
					return raceGroupDef.chancemaleBreasts;
				case SexPartType.MaleGenital:
					return raceGroupDef.chancemaleGenitals;
				default:
					throw new ApplicationException($"Unrecognized sexPartType: {sexPartType}");
			}
		}

		/// <summary>
		/// Returns true if a sex part was chosen (even if that part is "no part").
		/// </summary>
		[SyncMethod]
		public static bool TryAddSexPart(Pawn pawn, SexPartType sexPartType)
		{
			if (!TryGetRaceGroupDef(pawn, out var raceGroupDef))
			{
				// No race, so nothing was chosen.
				return false;
			}

			var parts = GetParts(raceGroupDef, sexPartType);
			if (parts == null)
			{
				// Missing list, so nothing was chosen.
				return false;
			}
			else if (!parts.Any())
			{
				// Empty list, so "no part" was chosen.
				return true;
			}

			var target = BodyPartDefBySexPartType[sexPartType];
			var part = pawn.RaceProps.body.AllParts.Find(bpr => bpr.def == target);
			var chances = GetPartsChances(raceGroupDef, sexPartType);
			var hasChances = chances != null && chances.Count() > 0;

			if (hasChances && chances.Count() != parts.Count())
			{
				Log.Error($"[RJW] RaceGroupDef named {raceGroupDef.defName} has {parts.Count()} parts but {chances.Count()} chances for {sexPartType}.");
				return false;
			}

			string name;
			
			if (hasChances)
			{
				var indexes = parts.Select((x, i) => i);
				name = parts[indexes.RandomElementByWeight(i => chances[i])];
			}
			else
			{
				name = parts.RandomElement();
			}

			if (string.IsNullOrEmpty(name))
			{
				// Randomly chose "no part".
				return true;
			}

			var hediffDef = DefDatabase<HediffDef>.GetNamedSilentFail(name);
			if (hediffDef == null)
			{
				Log.Error($"[RJW] Could not find a HediffDef named {name} referenced by RaceGroupDef named {raceGroupDef.defName}.");
				return false;
			}

			pawn.health.AddHediff(SexPartAdder.PartMaker(hediffDef, pawn, part), part);
			//add some sort of basesize/size override
			// A part was chosen and added.
			return true;
		}
	}
}
