function DialogTestFunc() {

    var _self = this;
	
	this.init = function() {

        if (typeof nx_api !== "undefined") {
            nx_api.init();            
            nx_api.initialState.get().then(_prepareDialog);            
        }
        else {
            _prepareDialog();
        }
    };

    var _prepareDialog = function(params) {

        _setAppearance(params);
        _setDialogText(params);
        _createButtons(params);
        _handleKeys(params);
    };

    var _setAppearance = function(params) {
        if (params && params.chrome) {
            if (params.chrome.foregroundColor) {
                $('body').css('color', params.chrome.foregroundColor);
            }
            if (params.chrome.backgroundColor) {
                $('body').css('background-color', params.chrome.backgroundColor);
            }
        }
    }

    var _setDialogText = function(params) {

        var dTitle = "";
        var dText = "";
        if (params) {
            if (typeof params.title === "string") {
                dTitle = params.title;
            }
            if (typeof params.text === "string") {
                dText = params.text;
            }
        }
        else {
            dTitle = "Alert!";
            dText = "You can provide a custom message here via NxApiRoot::setInitialState()";
        }
        $('#d_title').empty().append(dTitle);
        $('#d_text').empty().append(dText);
    }

    var _createButtons = function(params) {

        if (params && params.hasCancel) {

            var cancelTitle = "Cancel";
            if (params.chrome && params.chrome.cancelButtonTitle) {
                cancelTitle = params.chrome.cancelButtonTitle;
            }

            var cancelDiv = $('<div class="d_button">'+cancelTitle+'</div>');
            cancelDiv.click(_onCancel);
            $('#button_wrapper').append(cancelDiv);
            $('#button_wrapper').append('<div class="d_spacer"></div>');
            _hasCancel = true;
        }

        var okTitle = "OK";
        if (params && params.chrome && params.chrome.okButtonTitle) {
            okTitle = params.chrome.okButtonTitle;
        }

        var okDiv = $('<div class="d_button defaultChoice">'+okTitle+'</div>');
        okDiv.click(_onOk);
        $('#button_wrapper').append(okDiv);
    };

    var _handleKeys = function(params) {

        $(document).keydown(function(e){

            if (e.keyCode === 13) {
                // Enter
                _onOk();
            }
            else if (e.keyCode === 27) {
                // Escape
                if (params && params.hasCancel) {
                    _onCancel();
                }
            }
        });
    }

    var _onCancel = function(e) {
        nx_api.nx_window.setDialogResult(0);
        nx_api.nx_window.close();
    };

    var _onOk = function(e) {
        nx_api.nx_window.setDialogResult(1, {status:"success!"});
        nx_api.nx_window.close();
    };
}

var TestPageApp = new DialogTestFunc();
$(document).ready(function() {   
	TestPageApp.init();
}); 