local script = {}
local utils = {}
utils.gamedata = require("base.utils.gamedata")
utils.gamedatahelper = require("base.utils.gamedatahelper")
utils.buildables = require("base.utils.buildables")
utils.notifications = require("base.utils.notifications")


--- will try to unlock a decoration and if set also add it to the buildablePossibilities
---@param company number
---@param buildable_name string
---@param add_to_session boolean
---@return number
script.unlock_decoration = function(company, buildable_name, add_to_session, send_notification)
    if type(buildable_name) ~= "string" and utils.gamedatahelper.get_buildable_id_by_name(buildable_name) == 0 then
        LogError("utils.profile > add_decoration: buildable_id could not be found - "..tostring(buildable_name))
        return -1
    end

    if profile.HasValue(buildable_name) and profile.GetValue(buildable_name, buildable_name) == "1" then
        LogInfo("utils.profile > add_decoration: buildable_id was already added - "..tostring(buildable_name))
        return 0
    end

    profile.SetValue(buildable_name, "1")
    
    if send_notification then
        utils.notifications.unlocked_decoration(buildable_name)
    end

    if add_to_session then
        utils.buildables.add_buildable_options(company, buildable_name)
    end
    LogInfo("utils.profile > add_decoration: buildable_id has been added - "..tostring(buildable_name))
    return 1
end


--- returns a list of buildables unlocked on this account
---@param company number
---@return number
script.get_decorations = function(company)
    local list = {}
    for buildable_name,buildable_id in pairs(utils.gamedata.buildables) do
        if profile.HasValue(buildable_name) and profile.GetValue(buildable_name, buildable_name) == "1" then
            table.insert(list, buildable_name)
        end
    end
    return list
end


--- sets a list of buildables unlocked on this account
---@param company number
---@return boolean
script.use_profile_decorations = function(company)
    if company == nil or type(company) ~= "number" then
        LogError("utils.buildables > add_buildable_options: company not found - "..tostring(company))
        return false
    end

    local component = entities:GetConstructionPossibilitiesComponent(company)
    if component == nil then
        LogError("utils.buildables > add_buildable_options: company not found - "..tostring(company))
        return false
    end

    for buildable_name,buildable_id in pairs(utils.gamedata.buildables) do
        if profile.HasValue(buildable_name) and profile.GetValue(buildable_name, buildable_name) == "1" then
            component:MakeBuildablePossible(buildable_id)
            entities:UpdateConstructionPossibilitiesComponent(company)
        end
    end
    return true
end

return script