local script = {}
local utils = {}
utils.notifications = require("base.utils.notifications")
utils.gamedatahelper = require("base.utils.gamedatahelper")
utils.profile = require("base.utils.profile")
utils.session = require("base.utils.session")


require("files")
local json = require("json")

-------------------------------------------------------------------------------------
-- init/start/load
-------------------------------------------------------------------------------------
script.on_init = function(file_path, isload)
    script.data = {}
    script.data = json.decode(readFile(file_path))
    if isload then
        script.on_load()
    else
        script.on_start()
    end
    return script.data
end

script.on_start = function(path)
end


script.on_load = function(path)
end


-------------------------------------------------------------------------------------
-- in case of campaign level, use this
-- will load or start a level
-------------------------------------------------------------------------------------
script.set_level = function (path, isload)
    if isload then
        script.level_id = challengeservice:FindCampaign(path)
    else
        script.level_id = challengeservice:CreateCampaign(path)
        challengeservice:SetProgressTier(script.level_id, 0, 1)
        challengeservice:SetProgressTier(script.level_id, 1, 2)
        challengeservice:SetProgressTier(script.level_id, 2, 3)
    end
    return script.level_id
end

-------------------------------------------------------------------------------------
-- sets all of the current milestone texts at once
-------------------------------------------------------------------------------------
script.set_all_messages = function(company, ms_data)
    local list = {}
    for i=0, #ms_data.MessageTexts-1 do
        table.insert(list, i)
    end  
    milestones:SetActiveMessageTexts(company, list)
end


-------------------------------------------------------------------------------------
-- setting simple trigger counter for a milestone
-- not usable for more complex tracking
-------------------------------------------------------------------------------------
script.set_counter = function(company, goal, index, param1)
    if company == nil or goal == nil or index == nil then
        LogError("milestones: set counter got nil, expected 3 values - company id, goal data, milestone index")
        return nil
    end

    if goal.TimeframeDays == nil then
        goal.TimeframeDays = 0
    end

    if goal.ForDays == nil then
        goal.ForDays = 0
    end

    if type(goal.ID) == "nil" then
        goal.ID = 0
    end

    if type(param1) == "nil" then
        param1 = 0
    end

    local counter = triggercount:GetOrCreateTriggerCount("mstrigger_"..tostring(index) , company)
  
    if goal.Counter == "CountBankBalance" then
      counter:CountBankBalance(TriggerCountType[goal.CountType], goal.TimeframeDays)

    elseif  goal.Counter == "CountNetworth" then
      counter:CountNetworth(TriggerCountType[goal.CountType], goal.TimeframeDays)

    elseif  goal.Counter == "CountEmployees" then
      counter:CountEmployees(TriggerCountType[goal.CountType], goal.TimeframeDays)

    elseif  goal.Counter == "CountSoldProducts" then
        goal.ID = utils.gamedatahelper.get_product_type_id_by_name(goal.ID)
        counter:CountSoldProducts(TriggerCountType[goal.CountType], goal.ID, goal.TimeframeDays)

    elseif  goal.Counter == "CountSoldModules" then
        goal.ID = utils.gamedatahelper.get_module_id_by_name(goal.ID)
        counter:CountSoldModules(TriggerCountType[goal.CountType], goal.ID, goal.TimeframeDays)

    elseif  goal.Counter == "CountProducts" then
        goal.ID = utils.gamedatahelper.get_product_type_id_by_name(goal.ID)
        counter:CountProducts(TriggerCountType[goal.CountType], goal.ID, goal.TimeframeDays)

    elseif  goal.Counter == "CountModules" then
        goal.ID = utils.gamedatahelper.get_module_id_by_name(goal.ID)
        counter:CountModules(TriggerCountType[goal.CountType], goal.ID, goal.TimeframeDays)

    elseif  goal.Counter == "CountBuildables" then
        goal.ID = utils.gamedatahelper.get_buildable_id_by_name(goal.ID)
        counter:CountBuildables(TriggerCountType[goal.CountType], goal.ID, goal.TimeframeDays)

    elseif  goal.Counter == "CountResearchProjects" then
        goal.ID = utils.gamedatahelper.get_research_id_by_name(goal.ID)
      counter:CountResearchProjects(TriggerCountType[goal.CountType], goal.ID, goal.TimeframeDays)

    elseif  goal.Counter == "CountSamplingData" then
        goal.ID = utils.gamedatahelper.get_data_type_id_by_name(goal.ID)
      counter:CountSamplingData(TriggerCountType[goal.CountType], goal.ID, goal.TimeframeDays)

    elseif  goal.Counter == "CountSoldProductsWithBlueprint" then
      counter:CountSoldProductsWithBlueprint(TriggerCountType[goal.CountType], param1, goal.TimeframeDays)

    elseif  goal.Counter == "CountProductsWithBlueprint" then
        counter:CountProductsWithBlueprint(TriggerCountType[goal.CountType], param1, goal.TimeframeDays)

    elseif  goal.Counter == "Custom" then
        counter:CountCustom(goal.TimeframeDays)
    else
        LogError("milestones: counter function not found, if you want to make a custom counter set Counter to Custom")
        return nil
    end

    if goal.Trigger == "TriggerWhenGreaterThan" then
      counter:TriggerWhenGreaterThan(goal.Target, goal.ForDays)
    elseif goal.Trigger == "TriggerWhenLessThan" then
      counter:TriggerWhenLessThan(goal.Target, goal.ForDays)
    elseif goal.Trigger == "TriggerWhenEqual" then
      counter:TriggerWhenEqual(goal.Target, goal.ForDays)
    elseif goal.Trigger == "TriggerWhenGreaterThanOrEqual" then
      counter:TriggerWhenGreaterThanOrEqual(goal.Target, goal.ForDays)
    elseif goal.Trigger == "TriggerWhenLessThanOrEqual" then
      counter:TriggerWhenLessThanOrEqual(goal.Target, goal.ForDays)
    elseif goal.Trigger ~= "None" then
        LogError("milestones: trigger not found, if you do not want to use a trigger set Trigger to None")
        return nil
    end
    
    counter:SetTriggerFunction(function(ent, tc, tct)
        local ms = entities:GetMilestoneComponent(company)
        if ms.CurrentMilestoneIndex+1 == index then
            milestones:ActivateNextMilestone(company)
        end
        triggercount:RemoveTrigger("mstrigger_"..tostring(index))
    end)
  
    counter:SetProgressFunction(function(ent, tc, tct)
        local ms = entities:GetMilestoneComponent(company)
        if ms.CurrentMilestoneIndex+1 == index then
            milestones:SetProgress(company, tct.CurrentCount)
        else
            triggercount:RemoveTrigger("mstrigger_"..tostring(index))
        end
    end)

    return counter
end

-------------------------------------------------------------------------------------
-- call this function with the reward data from the json
-- contains the most common reward types to save time on scripting
-------------------------------------------------------------------------------------
script.give_rewards = function(company, reward_data)
    for i = 1, #reward_data do
        if reward_data[i].RewardType == "research" then
            reward_data[i].RewardID = utils.gamedatahelper.get_research_id_by_name(reward_data[i].RewardID)
            if type(reward_data[i].RewardID) ~= "number" then
                LogError("milestone rewards: invalid type for [research] reward, should be number - "..tostring(reward_data[i].RewardID))
            elseif gamedata:GetResearchProject(reward_data[i].RewardID) == nil then
                LogError("milestone rewards: [research] id not found - "..tostring(reward_data[i].RewardID))
            else
                researchservice:UnlockResearchProject(company, reward_data[i].RewardID, false, false)
            end


        elseif reward_data[i].RewardType == "buildable" then
            utils.notifications.unlocked_buildable(reward_data[i].RewardID)
            reward_data[i].RewardID = utils.gamedatahelper.get_buildable_id_by_name(reward_data[i].RewardID)
            if type(reward_data[i].RewardID) ~= "number" then
                LogError("milestone rewards: invalid type for [buildable] reward, should be number - "..tostring(reward_data[i].RewardID))
            else
                local component = entities:GetConstructionPossibilitiesComponent(company)
                component.PossibleBuildables:add(reward_data[i].RewardID)
                entities:UpdateConstructionPossibilitiesComponent(company)
            end


        elseif reward_data[i].RewardType == "profile_buildable" then
            utils.profile.unlock_decoration(world.PlayerCompanyID, reward_data[i].RewardID, true, true)


        elseif reward_data[i].RewardType == "ui" then
            if type(reward_data[i].RewardID) == "number" then
                uigatingservice:MakeUIElementAvailable(reward_data[i].RewardID, true)
            elseif type(reward_data[i].RewardID) == "string" then
                uigatingservice:MakeUIElementAvailable(UIElement[reward_data[i].RewardID], true)
            end


        elseif reward_data[i].RewardType == "market" then
            reward_data[i].RewardID = utils.gamedatahelper.get_product_type_id_by_name(reward_data[i].RewardID)
            if type(reward_data[i].RewardID) ~= "number" then
                LogError("milestone rewards: invalid type for [market] reward, should be number - "..tostring(reward_data[i].RewardID))
            elseif gamedata:GetProductType(reward_data[i].RewardID) == nil then
                LogError("milestone rewards: [market] id not found - "..tostring(reward_data[i].RewardID))
            else
                marketdiscoveryservice:UnlockMarket(reward_data[i].RewardID)
            end


        elseif reward_data[i].RewardType == "gredits" then
            if type(reward_data[i].Parameter) ~= "number" then
                LogError("milestone rewards: invalid type for [money] parameter, should be number - "..tostring(reward_data[i].Parameter))
            else
                transactionservice:AddMoney(company, reward_data[i].Parameter, 7, true)
                utils.notifications.money_added("not_milestone_money", reward_data[i].Parameter)
            end


        elseif reward_data[i].RewardType == "data" then
            reward_data[i].RewardID = utils.gamedatahelper.get_data_type_id_by_name(reward_data[i].RewardID)
            if type(reward_data[i].Parameter) ~= "number" then
                LogError("milestone rewards: invalid type for [market] reward, should be number")
            else
                local dataAmount = SamplingDataAmount.new()
                dataAmount.DataTypeID = reward_data[i].RewardID
                dataAmount.Amount = reward_data[i].Parameter
                samplingservice:AddSamplingDataToStorage(company, dataAmount)
                utils.notifications.data_added("not_milestone_data", reward_data[i].RewardID, reward_data[i].Parameter)
            end


        elseif reward_data[i].RewardType == "trophy" then
            if type(reward_data[i].RewardID) ~= "number" or reward_data[i].RewardID < 1 or reward_data[i].RewardID > 3 then
                LogError("milestone rewards: invalid type for [trophy] reward, should be number from 1-3")
            else
                if reward_data[i].DisplayNoddy == nil then
                    reward_data[i].DisplayNoddy = true
                end
                challengeservice:SetProgress(script.level_id, reward_data[i].RewardID)
                world:ExecuteFunctionInTime(0, function()
                    if reward_data[i].RewardID == 1 and reward_data[i].DisplayNoddy then
                        noddyservice:DisplayNoddy(
                        NoddyEventFlags.Success +
                        NoddyEventFlags.ContinueButton +
                        NoddyEventFlags.BackToMapButton)
                    end
                    if reward_data[i].RewardID == 3 and reward_data[i].DisplayNoddy then
                        noddyservice:DisplayNoddy(
                        NoddyEventFlags.Success +
                        NoddyEventFlags.ContinueButton +
                        NoddyEventFlags.BackToMapButton)
                    end
                end)
                if reward_data[i].RewardID == 3 then
                    challengeservice:SetChallengeState(script.level_id, 1)
                end
            end


        elseif reward_data[i].RewardType == "show_projects" then
            if type(reward_data[i].RewardID) == "string" then
                reward_data[i].RewardID = utils.gamedatahelper.get_research_id_by_name(reward_data[i].RewardID)
            end
            if type(reward_data[i].RewardID) == "number" then
                reward_data[i].RewardID = {reward_data[i].RewardID}
            end

            for reward_id_index=1, #reward_data[i].RewardID do
                reward_data[i].RewardID[reward_id_index] = utils.gamedatahelper.get_research_id_by_name(reward_data[i].RewardID[reward_id_index])
            end

            if type(reward_data[i].RewardID) ~= "table" or #reward_data[i].RewardID <= 0 or type(reward_data[i].RewardID[1]) ~= "number" then
                LogError("milestone rewards: invalid type for [show_projects] reward, an array of numbers")
            else
                researchservice:ShowProjects(company, reward_data[i].RewardID)
            end


        elseif reward_data[i].RewardType == "market_phase" then
            reward_data[i].RewardID = utils.gamedatahelper.get_product_type_id_by_name(reward_data[i].RewardID)
            if type(reward_data[i].RewardID) ~= "number" or gamedata:GetProductType(reward_data[i].RewardID) == nil then
                LogError("milestone rewards: invalid product for [market_phase] reward, should be number of product that exists")
            else
                local market_entity = marketsegmentservice:GetMarketSegmentEntityID(1, reward_data[i].RewardID)
                if market_entity ~= 0 then
                    local market_expectation_segment = entities:GetMarketSegmentExpectationsComponent(market_entity)
                    marketprogression:SetMarketPhase(reward_data[i].RewardID, market_expectation_segment.CurrentMarketPhase + 2)
                else
                    LogError("milestone rewards: invalid product for [market_phase] reward, could not find active market")
                end
            end
        else
            LogWarning("milestone rewards: reward type not found - "..tostring(reward_data[i].RewardType))
        end
    end
end

--- takes the json data of a milestone and automatically new handbook pages
---@param ms_data table
script.add_handbook_pages = function(ms_data)
    if ms_data == nil or type(ms_data) ~= "table" then
        LogError("milestone utility, add_handbook_pages - missing data")
    end
    if ms_data.HandbookPages ~= nil then
        -- Do not remove the delay by 1 frame. If you do it, milestone 1 handbook unlocks will B_R_E_A_K game_setup handbook unlocks!!!
        world:ExecuteFunctionInTime(0, function()
            if type(ms_data.HandbookPages) == "number" then
                utils.session.unlockHandbookPages({ms_data.HandbookPages})
            elseif type(ms_data.HandbookPages) == "table" and #ms_data.HandbookPages >= 1 and type(ms_data.HandbookPages[1]) == "number" then
                utils.session.unlockHandbookPages(ms_data.HandbookPages)
            else
                LogError("milestone utility, unlocking handbook pages gone wrong!")
            end
        end)
    end
end

--- takes the json data of a milestone and automatically sets a notification
---@param ms_index number
---@param ms_data table
script.display_notification = function(ms_index, ms_data)
    if ms_data == nil then
        LogError("milestone utility, milestone_notification - missing data")
    end

    if ms_index == nil or type(ms_index) ~= "number" then
        ms_index = 0
    end
    local notification_data = ms_data.Notification

    if notification_data == nil then
        notification_data = {}
    end

    if notification_data.Type == nil then
        notification_data.Type = "milestone"
    end

    if notification_data.Title == nil then
        notification_data.Title = ms_data.Title
    end

    notificationservice:DismissNotification("gcm_milestone_notification", true)
    local entity = notificationservice:CreateOrGetNotification("gcm_milestone_notification")
    local notification = entities:GetNotificationComponent(entity)
    notification.Flags = NotificationFlags.CanBeDismissed + NotificationFlags.PopUp

    if notification_data.Type == "milestone" then
        notification.Type = NotificationType.MilestoneComplete
        notification.IdParameter = ms_index - 1
        if notification_data.StringID == nil then
            notification_data.StringID = "not_milestone_complete"
        end

    elseif notification_data.Type == "trophy" then
        notification.Type = NotificationType.Custom

        if notification_data.TrophyID ~= nil and type(notification_data.TrophyID) ~= "number" then
            notification_data.TrophyID = 1
        end
        
        if notification_data.StringID == nil then
            if notification_data.TrophyID == 1 then
                notification_data.StringID = "not_campaign_trophy_earned_1"
                notification.Icon = "icons_common/trophyC"
            elseif notification_data.TrophyID == 2 then
                notification_data.StringID = "not_campaign_trophy_earned_2"
                notification.Icon = "icons_common/trophy_double"
            elseif notification_data.TrophyID == 3 then
                notification_data.StringID = "not_campaign_trophy_earned_3"
                notification.Icon = "icons_common/trophy_tripple"
            else --this should not really happen, so pls don't ask why'd add it
                notification_data.StringID = "not_campaign_trophy_lost"
                notification.Icon = "icons_common/trophyCnoShadow"
            end
        end

    else --if you want a custom notifcation define >any< type but those actually used
        notification.Type = NotificationType.Custom
        if notification_data.StringID == nil then
            notification_data.StringID = "not_missing"
        end
        
        if notification_data.Icon ~= nil and type(notification_data.Icon) == "string" then
            notification.Icon = notification_data.Icon
        end
    end
    
    notification.StringIdentifier = notification_data.StringID
    notification.ReplacementParameters:clear()
    notification.ReplacementParameters:add("title:T!"..tostring(notification_data.Title))

    if notification_data.Param1 ~= nil and type(notification_data.Param1) == "string" then
        notification.ReplacementParameters:add("Param1:T!"..tostring(notification_data.Title))
    end
    if notification_data.Param2 ~= nil and type(notification_data.Param2) == "string" then
        notification.ReplacementParameters:add("Param2:T!"..tostring(notification_data.Title))
    end
end

return script