local script = {}

--- this function is a helper to quickly transform a list of module ids etc. gotten via json into the vector like format used by the backend sometimes
---@param tbl table
---@param index_name string
---@param value_name string
---@return table
script.table_to_array = function(tbl, index_name, value_name)
    if type(tbl) ~= "table" then
        LogError("helper > table_to_array: tbl is wrong data type, expected table")
        return nil
    end

    if type(index_name) ~= "string" or type(value_name) ~= "string" then
        LogError("helper > table_to_array: names have wrong data type, expected strings")
        return nil
    end

    local array = {}
    for table_index, table_data in pairs(tbl) do
        if table_data[index_name] ~= nil and type(table_data[index_name]) == "number" and table_data[value_name] ~= nil then
            array[table_data[index_name]] = table_data[value_name]
        else
            LogWarning("helper > table_to_string: index or name in entry could not be found")
        end
    end
    return array
end

return script