local script = {}
local utils = {}
utils.gamedata = require("base.utils.gamedata")

--- looks up given identifier if there exists an entry for it, if not it returns 0
---@param name string
---@return number
script.get_product_type_id_by_name = function(name)
  if type(name) == "number" then
    return name
  end

  if type(name) == "string" and utils.gamedata.product_types[name] ~= nil then
    return utils.gamedata.product_types[name]
  end

  LogWarning("gamedatahelper could not find product_types, default to 0 - "..tostring(name))
  return 0
end


--- looks up ids from a list of product names and returns that list
---@param list table
---@return table
script.product_type_list_to_ids = function(list)
  local id_list = {}
  for index, content in pairs(list) do
    id_list[index] = script.get_product_type_id_by_name(content)
  end
  return id_list
end


--- looks up given identifier if there exists an entry for it, if not it returns 0
---@param name string
---@return number
script.get_module_id_by_name = function(name)
  if type(name) == "number" then
    return name
  end

  if type(name) == "string" and utils.gamedata.modules[name] ~= nil then
    return utils.gamedata.modules[name]
  end

  LogWarning("gamedatahelper could not find module, default to 0 - "..tostring(name))
  return 0
end


--- looks up ids from a list of module names and returns that list
---@param list table
---@return table
script.module_list_to_ids = function(list)
  local id_list = {}
  for index, content in pairs(list) do
    id_list[index] = script.get_module_id_by_name(content)
  end
  return id_list
end


--- looks up given identifier if there exists an entry for it, if not it returns 0
---@param name string
---@return number
script.get_material_id_by_name = function(name)
  if type(name) == "number" then
    return name
  end

  if type(name) == "string" and utils.gamedata.materials[name] ~= nil then
    return utils.gamedata.materials[name]
  end

  LogWarning("gamedatahelper could not find materials, default to 0 - "..tostring(name))
  return 0
end


--- looks up ids from a list of material names and returns that list
---@param list table
---@return table
script.material_list_to_ids = function(list)
  local id_list = {}
  for index, content in pairs(list) do
    id_list[index] = script.get_material_id_by_name(content)
  end
  return id_list
end


--- looks up given identifier if there exists an entry for it, if not it returns 0
---@param name string
---@return number
script.get_feature_id_by_name = function(name)
  if type(name) == "number" then
    return name
  end

  if type(name) == "string" and utils.gamedata.features[name] ~= nil then
    return utils.gamedata.features[name]
  end

  LogWarning("gamedatahelper could not find features, default to 0 - "..tostring(name))
  return 0
end


--- looks up given identifier if there exists an entry for it, if not it returns 0
---@param name string
---@return number
script.get_buildable_id_by_name = function(name)
  if type(name) == "number" then
    return name
  end

  if type(name) == "string" and utils.gamedata.buildables[name] ~= nil then
    return utils.gamedata.buildables[name]
  end

  LogWarning("gamedatahelper could not find buildables, default to 0 - "..tostring(name))
  return 0
end


--- looks up given identifier if there exists an entry for it, if not it returns 0
---@param name string
---@return number
script.get_data_type_id_by_name = function(name)
  if type(name) == "number" then
    return name
  end

  if type(name) == "string" and utils.gamedata.data_types[name] ~= nil then
    return utils.gamedata.data_types[name]
  end

  LogWarning("gamedatahelper could not find data_types, default to 0 - "..tostring(name))
  return 0
end


--- looks up given identifier if there exists an entry for it, if not it returns 0
---@param name string
---@return number
script.get_module_category_id_by_name = function(name)
  if type(name) == "number" then
    return name
  end

  if type(name) == "string" and utils.gamedata.module_categories[name] ~= nil then
    return utils.gamedata.module_categories[name]
  end

  LogWarning("gamedatahelper could not find module_categories, default to 0 - "..tostring(name))
  return 0
end


--- looks up given identifier if there exists an entry for it, if not it returns 0
---@param name string
---@return number
script.get_research_id_by_name = function(name)
  if type(name) == "number" then
    return name
  end

  if type(name) == "string" and utils.gamedata.researches[name] ~= nil then
    return utils.gamedata.researches[name]
  end

  LogWarning("gamedatahelper could not find research, default to 0 - "..tostring(name))
  return 0
end


--- quick check what the given material id is:
--- 0 = does not exist
--- 1 = material
--- 2 = component
--- 3 = module
--- 4 = case
---@param material string|number
---@return number
script.get_item_type = function(material)
  local material_id = script.get_material_id_by_name(material)
  local material_data = gamedata:GetMaterial(material_id)

  if material_data == nil then
    return 0
  end

  if material_data.StackBuyPrice > 0 then
    return 1
  end

  local module_data = gamedata:GetModule(gamedata:GetModuleIDFromMaterialID(material_id))
  if module_data == nil then
    return 1
  end

  if #module_data.Features == 0 and #module_data.GridDimensions == 0 then
    return 2
  end

  if #module_data.GridDimensions > 0 then
    return 3
  end

  if #module_data.GridDimensions == 0 then
    return 4
  end

  return -1
end



script.get_random_module = function()
  local component = entities:GetProductionPossibilitiesComponent(world.PlayerCompanyID)
  if #component.PossibleModuleTypes == 0 then return nil end
  return component.PossibleModuleTypes:at(math.random(1, #component.PossibleModuleTypes))
end


script.get_random_product = function()
  local component = entities:GetProductionPossibilitiesComponent(world.PlayerCompanyID)
  if #component.PossibleProductTypes == 0 then return nil end
  return component.PossibleProductTypes:at(math.random(1, #component.PossibleProductTypes))
end

return script