local finances = {}

-------------------------------------------------------------------------------------
-- Used for a company paying for something, it also udpated the tendency           --
-------------------------------------------------------------------------------------
finances.ChangeCompanyMoney = function(entityID, changeAmount, category)
  if entityID == nil then
    LogError("ChangeCompanyMoney: CompanyID was nil!")
    return false
  end
    
  if changeAmount == nil then
    LogError("ChangeCompanyMoney: changeAmount was not set!")
    return false
  end
  changeAmount = math.floor(changeAmount)
  
  if category == nil then
    LogWarning("ChangeCompanyMoney: category not set. Default to 4")
    category = 4
  end
  
  transactionservice:AddMoney(entityID, changeAmount, category, false)
  return true
end


-------------------------------------------------------------------------------------
-- Gets the player networth by category, if non is entered, gives back the total   --
-------------------------------------------------------------------------------------

finances.GetPlayerNetworth = function(category)
  local networth = entities:GetNetWorthComponent(world.PlayerCompanyID)
  if category ~= nil and category > 0 then
    if category == 1 then
      return networth.AccountBalanceWorth
    elseif category == 2 then
      return networth.MaterialAssetsWorth 
    elseif category == 3 then
      return networth.ProductStorageWorth
    elseif category == 4 then
      return networth.MachineAssetsWorth
    elseif category == 5 then
      return networth.ResearchWorth
    else
      LogError("Tried to lookup invalid networth category: "..tostring(category))
      return 0
    end
  else
    return networth:GetTotalNetworth()
  end
end

-------------------------------------------------------------------------------------
-- Returning based on the given projectID the networth based on Data Points        --
-------------------------------------------------------------------------------------

finances.GetResearchNetworth = function(projectID)
  local project = gamedata:GetResearchProject(projectID)
  local worth = 0
  for i=1, #project.RequiredData do
    local dataType = gamedata:GetSamplingDataType(project.RequiredData[i].DataTypeID)
    worth = worth + (project.RequiredData[i].Amount * dataType.NetWorth)
  end
  return worth * 1.6 --static variable in c++ code
end

-------------------------------------------------------------------------------------
-- Returns the player company's total net worth                                    --
-------------------------------------------------------------------------------------

finances.GetTotalPlayerNetworth = function(companyID)
  local networth = entities:GetNetWorthComponent(world.PlayerCompanyID)
  return networth:GetTotalNetworth()
end

return finances