local exporter = {}

exporter.exportEquipment = function ()
    local buildableDefinition = "{\n\t\"equipment\": [\n"
    local first = true
    entities:ForEachConstructComponent(function (entityID, construct)
        local transform = entities:GetTileTransformComponent(entityID)
        local name = entities:GetNameComponent(entityID)
        if first then
            buildableDefinition = buildableDefinition.."\t\t{\n"
            first = false
        else
            buildableDefinition = buildableDefinition..",\n\t\t{\n"
        end

        buildableDefinition = buildableDefinition.."\t\t\t\"Name\": \""..name.Name.."\""
        buildableDefinition = buildableDefinition..",\n\t\t\t\"ID\": "..tostring(construct.objectType)
        buildableDefinition = buildableDefinition..",\n\t\t\t\"X\": "..tostring(transform.Position.X)
        buildableDefinition = buildableDefinition..",\n\t\t\t\"Y\": "..tostring(transform.Position.Y)
        buildableDefinition = buildableDefinition..",\n\t\t\t\"Rotation\": "..tostring(transform.Orientation)
        local crafter = entities:GetCrafterComponent(entityID)
        if crafter and crafter.SelectedModule ~= 0 then
            buildableDefinition = buildableDefinition..",\n\t\t\t\"SwitchModule\": "..tostring(crafter.SelectedModule)
        end
        local analysis = entities:GetSamplingStationComponent(entityID)
        if analysis then
            local modulesstr = ""
            for i =1,#analysis.AllowedModules do
                local m = analysis.AllowedModules:at(i)
                if m ~= 0 then
                    if #modulesstr > 0 then modulesstr = modulesstr.."," end
                    modulesstr = modulesstr..tostring(m)
                end
            end
            if #modulesstr > 0 then
                buildableDefinition = buildableDefinition..",\n\t\t\t\"SwitchModule\": ["..modulesstr.."]"
            end
        end
        buildableDefinition = buildableDefinition..",\n\t\t\t\"LogisticsID\": \""..name.Name..tostring(entityID).."\""

        buildableDefinition = buildableDefinition.."\n\t\t}"
    end)
    buildableDefinition = buildableDefinition.."\n\t]\n}"
    local f = io.open("equipment.json", "w")
    f:write(buildableDefinition)
    f:close()
end

return exporter