local equipment = {}


--- returns the object id of the selected construct
---@param construct number|ConstructComponent
---@return number
equipment.get_object_id = function(construct)
  if type(construct) == "number" then
    construct = entities:GetConstructComponent(construct)
  end
  if construct ~= nil then
    return construct.objectType
  else
    return 0
  end
end

-------------------------------------------------------------------------------------
-- sets equipment ad the desired position. Use the constructable ID!               --
-------------------------------------------------------------------------------------
equipment.SetPlayerEquipment = function(buildableId, positionX, positionY, rotation, name)  
    if positionX == nil or positionY == nil then
      LogError("SetPlayerEquipment: Position can't be nil!")
      return nil
    end
    
    if rotation== nil then
      LogWarning("SetPlayerEquipment: Rotation was nil! Default to 0.")
      rotation = 0
    elseif rotation < 0 or rotation > 3 then
      LogWarning("SetPlayerEquipment: Rotation was out of bounds (0-3)! Default to 0.")
      rotation = 0
    end
  
    local position = Coordinate2.new(positionX, positionY)
    if buildableservice:CanBeBuiltAtWorldPos(buildableId, position, rotation, 0) == 0 then
      local entityID = buildableservice:PlaceBuildable(buildableId, position, rotation, world.PlayerCompanyID)
      if buildableId == 11 or buildableId == 12 then
        -- this is a bit hacky, but buy and sellzones were never meant to
        -- be built by the buildableservice. and as such should not have
        -- a ConstructComponent (which would make them movable and deconstructable)
        entities:RemoveConstructComponent(entityID)
      end
      if name ~= nil and name ~= "" then
        local component = entities:GetOrAssignNameComponent(entityID)
        component.Name = name
        entities:UpdateNameComponent(entityID)
      end
      return entityID
    else
      LogError("position blocked - objectID:" .. buildableId .. " - position: " .. position.X .."/".. position.Y)
    end
    return nil
end


-------------------------------------------------------------------------------------
-- sets equipment ad the desired position. Used with Json Data!                    --
--      "Name": "shelf01",
--      "BuildableID": 20,
--      "CoordinateX": 3,
--      "CoordinateY": -4,
--      "Rotation": 1
-------------------------------------------------------------------------------------
equipment.SetPlayerEquipmentFromJson = function(data)
  return equipment.SetPlayerEquipment(data.BuildableID, data.CoordinateX, data.CoordinateY, data.Rotation, data.Name)
end


-------------------------------------------------------------------------------------
-- Removes a constructable from the construction list                              --
-------------------------------------------------------------------------------------
equipment.RemoveBuildableOption = function(buildableId)
  local removed = false
  entities:ForEachConstructionPossibilitiesComponent(function(eid, component)
    local buildIndex = component.PossibleBuildables:find(buildableId)
    if buildIndex ~= nil then
      component.PossibleBuildables:erase(buildIndex)
      removed = true
    end
    entities:UpdateConstructionPossibilitiesComponent(eid)
  end)
  return removed
end

-------------------------------------------------------------------------------------
-- Add a constructable from the construction list                              --
-------------------------------------------------------------------------------------
equipment.AddBuildableOption = function(buildableId)
  entities:ForEachConstructionPossibilitiesComponent(function(eid, component)
      component.PossibleBuildables:add(buildableId)
    entities:UpdateConstructionPossibilitiesComponent(eid)
  end)
end

return equipment