local script = {}

script.InitCustomValues = function(entityID)
  if not entities:HasCustomValuesComponent(entityID) then
    entities:AssignCustomValuesComponent(entityID)
  end
  return entities:GetCustomValuesComponent(entityID)
end

script.InitCustomValuesAsDictionary = function(entityID, length)
  local customValuesComponent = script.InitCustomValues(entityID)
  if #customValuesComponent.CustomNumbers < length then
    for _ = #customValuesComponent.CustomNumbers, length do
      customValuesComponent.CustomNumbers:add(0)
    end
  end
  return customValuesComponent
end


--- will create an entity with a CustomValueComponent with the first value being the id
---@param id number
---@return number
script.create_tagged_entity = function(id)
  local e = entities:createEntity()
  entities:AssignCustomValuesComponent(e)
  local c = entities:GetCustomValuesComponent(e)
  c.CustomNumbers:add(id)
  entities:UpdateCustomValuesComponent(e)
  return e
end


--- will find an entity with a CustomValueComponent with the first value being the id
---@param id number
---@return number
script.find_tagged_entity = function(id)
  local entity = 0
  entities:ForEachCustomValuesComponent(function(e)
    local c = entities:GetCustomValuesComponent(e)
    if c.CustomNumbers[1] == id then
      entity = e
    end
  end)
  return entity
end


--- will find or create an entity with a CustomValueComponent with the first value being the id
---@param id number
---@return number
script.find_or_create_tagged_entity = function(id)
  local e = script.find_tagged_entity(id)
  if e == 0 then
    e = script.create_tagged_entity(id)
  end
  return e
end

return script