local company = {}

company.SetAppearence = function(companyID, appearenceData)
  if companyID == nil or not entities:HasCompanyComponent(companyID) then
    LogError("SetAppearence: companyID was nil/not found!")
    return false
  end
  
  local company = entities:GetCompanyComponent(companyID)
  
  if appearenceData == nil then
    appearenceData = {}
    LogWarning("SetAppearence: No appearenceData found!")
  end
  
  if appearenceData.Logo == nil then
    appearenceData.Logo = math.random(0, 55)
  elseif type(appearenceData.Logo) == "table" then
    appearenceData.Logo = appearenceData.Logo[math.random(1, #appearenceData.Logo)]
  end
  company.Logo = appearenceData.Logo
  
  if appearenceData.LogoBGShape == nil then
    appearenceData.LogoBGShape = math.random(0, 15)
  elseif type(appearenceData.LogoBGShape) == "table" then
    appearenceData.LogoBGShape = appearenceData.LogoBGShape[math.random(1, #appearenceData.LogoBGShape)]
  end
  company.LogoBGShape = appearenceData.LogoBGShape
  
  if appearenceData.LogoColor == nil then
    appearenceData.LogoColor = math.random(0, 23)
  elseif type(appearenceData.LogoColor) == "table" then
    appearenceData.LogoColor = appearenceData.LogoColor[math.random(1, #appearenceData.LogoColor)]
  end
  company.LogoColor = appearenceData.LogoColor
  
  if appearenceData.LogoBGColor == nil then
    appearenceData.LogoBGColor = math.random(0, 23)
  elseif type(appearenceData.LogoBGColor) == "table" then
    appearenceData.LogoBGColor = appearenceData.LogoBGColor[math.random(1, #appearenceData.LogoBGColor)]
  end
  company.LogoBGColor = appearenceData.LogoBGColor
  
  if appearenceData.TextColor == nil then
    appearenceData.TextColor = math.random(0, 23)
  elseif type(appearenceData.TextColor) == "table" then
    appearenceData.TextColor = appearenceData.TextColor[math.random(1, #appearenceData.TextColor)]
  end
  company.TextColor = appearenceData.TextColor
  
  if appearenceData.TextAlign == nil then
    appearenceData.TextAlign = math.random(0, 1)
  end
  company.TextAlign = appearenceData.TextAlign
  
  entities:UpdateCompanyComponent(companyID)
  return true
end


company.GetNotificationData = function(companyID)
  if companyID == nil or not entities:HasCompanyComponent(companyID) then
    LogError("SetAppearence: companyID was nil/not found!")
    return false
  end  
  local component = entities:GetCompanyComponent(companyID)
  
  local data = {}
  
  data.Icon = "icons_companylogos/icons_companylogos_"..tostring(component.Logo)
  data.BGColor = company.GetCompanyColor(component.LogoBGColor)  
  data.IconColor = company.GetCompanyColor(component.LogoColor)
  data.TextColor = company.GetCompanyColor(component.TextColor)
  
  return data
end

company.GetCompanyColor = function(colorID)
  if colorID == 0 then return 0xD5CFBBAA
  elseif colorID == 1 then return 0xD03B3BAA
  elseif colorID == 2 then return 0x529039AA
  elseif colorID == 3 then return 0xB4B60CAA
  elseif colorID == 4 then return 0x452727AA
  elseif colorID == 5 then return 0x0F4565AA
  elseif colorID == 6 then return 0x7E2B2BAA
  elseif colorID == 7 then return 0xC96D0CAA
  elseif colorID == 8 then return 0xBF3398AA
  elseif colorID == 9 then return 0xBF3333AA
  elseif colorID == 10 then return 0x2274BFAA
  elseif colorID == 11 then return 0x33BFA2AA
  elseif colorID == 12 then return 0x43BF33AA
  elseif colorID == 13 then return 0x6DA0CBAA
  elseif colorID == 14 then return 0xFFFFFFAA
  elseif colorID == 15 then return 0x808080AA
  elseif colorID == 16 then return 0x000000AA
  elseif colorID == 17 then return 0x689543AA
  elseif colorID == 18 then return 0x3D3327AA
  elseif colorID == 19 then return 0xC8360FAA
  elseif colorID == 20 then return 0xE56814AA
  elseif colorID == 21 then return 0xD5BB7EAA
  elseif colorID == 22 then return 0x4E82AAAA
  elseif colorID == 23 then return 0x773ECCAA
  end
  return 0x808080AA
end

return company