local challenges = {}

require("files")
local json = require("json")

-------------------------------------------------------------------------------------
-- Loads a challenge from a json file and creates it according to the data.
-- Returns a table containing the challenge id, minimumTier and data from json file.
-------------------------------------------------------------------------------------
challenges.StartChallenge = function(json_file_path)
    local challenge = {}
    challenge.data = json.decode(readFile(json_file_path))
    
    LogInfo("Starting challenge '" .. challenge.data.Title .. "'!")
    LogInfo("Setting challenge script: '" .. challenge.data.ScriptName .. "'.")

    challenge.id = challengeservice:CreateChallenge(challenge.data.ScriptName)
    challenges.active_id = challenge.id
    LogInfo("### challenge created: " .. tostring(challenge.id))

    challenge.minimumTier = challenge.data.Metrics.Tiers[1]
    challengeservice:SetProgressTier(challenge.id, 0, challenge.minimumTier)
    challengeservice:SetProgressTier(challenge.id, 1, challenge.data.Metrics.Tiers[2])
    challengeservice:SetProgressTier(challenge.id, 2, challenge.data.Metrics.Tiers[3])
    LogInfo("### progress tiers set")
    
    if entities:HasProgressComponent(challenge.id) then
      challenge.progress = entities:GetProgressComponent(challenge.id)
    end
    
    if entities:HasGoalsComponent(challenge.id) then
      challenge.goals = entities:GetGoalsComponent(challenge.id)
    end

    return challenge
end

-------------------------------------------------------------------------------------
-- Loads a challenge from a json file and tries to find it in the existing components.
-- Returns a table containing the challenge id, minimumTier and data from json file.
-------------------------------------------------------------------------------------
challenges.LoadChallenge = function(json_file_path)
    local challenge = {}
    challenge.data = json.decode(readFile(json_file_path))
    challenge.minimumTier = challenge.data.Metrics.Tiers[1]
    challenge.id = challengeservice:FindChallenge(challenge.data.ScriptName)
    challenges.active_id = challenge.id
    if challenge.id == 0 then
      LogError("### challenge "..challenge.data.ScriptName.." not found!")
    end
    
    if entities:HasProgressComponent(challenge.id) then
      challenge.progress = entities:GetProgressComponent(challenge.id)
    end
    
    if entities:HasGoalsComponent(challenge.id) then
      challenge.goals = entities:GetGoalsComponent(challenge.id)
    end
    
    return challenge
end

-------------------------------------------------------------------------------------
-- depricated                                                                      --
-------------------------------------------------------------------------------------
challenges.UpdateGoal = function(challengeID, goal, value)
  local goals = entities:GetGoalsComponent(challengeID)
  LogInfo("Updated goal "..tostring(goal).." from "..tostring(goals.Goals[goal].Current).." to "..tostring(value))
  goals.Goals[goal].Current = value
  entities:UpdateGoalsComponent(challengeID)
end


-------------------------------------------------------------------------------------
-- one liner to set a goal to a specific value
-------------------------------------------------------------------------------------
challenges.set_goal_value = function(goal_id, value)
  local c = entities:GetGoalsComponent(challenges.active_id)
  LogInfo("Updated goal "..tostring(goal_id).." from "..tostring(c.Goals[goal_id].Current).." to "..tostring(value))
  c.Goals[goal_id].Current = value
  entities:UpdateGoalsComponent(challenges.active_id)
  return value
end

-------------------------------------------------------------------------------------
-- one liner to add a specific value upon a goal
-------------------------------------------------------------------------------------
challenges.add_goal_value = function(goal_id, value)
  local c = entities:GetGoalsComponent(challenges.active_id)
  c.Goals[goal_id].Current = c.Goals[goal_id].Current + value
  LogInfo("Updated goal "..tostring(goal_id).." by "..tostring(value).." to "..tostring(c.Goals[goal_id].Current))
  entities:UpdateGoalsComponent(challenges.active_id)
  return c.Goals[goal_id].Current
end


-------------------------------------------------------------------------------------
-- one liner to get a specific goal value
-------------------------------------------------------------------------------------
challenges.get_goal_value = function(goal_id)
  local c = entities:GetGoalsComponent(challenges.active_id)
  return c.Goals[goal_id].Current
end


-------------------------------------------------------------------------------------
-- one liner to check if a goal is fulfilled
-------------------------------------------------------------------------------------
challenges.check_goal = function(goal_id)
  local c = entities:GetGoalsComponent(challenges.active_id)
  if c.Goals[goal_id].Current >= c.Goals[goal_id].Target then
    return true
  else
    return false
  end
end

challenges.get_progress = function(challenge_id)
  progress_comp = entities:GetProgressComponent(challenge_id)
  return progress_comp
end

return challenges