local script = {}
local gamedatahelper = require("base.utils.gamedatahelper")

--- will add list or single entry for the selected company to the buildable possibilities list
---@param object_list string|number|table
---@param company number
---@return number
script.add_buildable_options = function(company, object_list)
    if company == nil or type(company) ~= "number" then
        LogError("utils.buildables > add_buildable_options: company not found - "..tostring(company))
        return -1
    end

    local component = entities:GetConstructionPossibilitiesComponent(company)
    if component == nil then
        LogError("utils.buildables > add_buildable_options: company not found - "..tostring(company))
        return -1
    end

    if type(object_list) == "table" then
        local n = 0
        for _,object_id in pairs(object_list) do
            local buildable_id = gamedatahelper.get_buildable_id_by_name(object_id)
            if buildable_id == 0 then
                LogWarning("utils.buildables > add_buildable_options: buildable not found - "..tostring(object_id))
            else
                component:MakeBuildablePossible(buildable_id)
                n = n + 1
            end
        end
        entities:UpdateConstructionPossibilitiesComponent(company)
        return n
    else
        local buildable_id = gamedatahelper.get_buildable_id_by_name(object_list)
        if buildable_id == 0 then
            LogWarning("utils.buildables > add_buildable_options: buildable not found - "..tostring(object_list))
            return -1
        end
        component:MakeBuildablePossible(buildable_id)
        entities:UpdateConstructionPossibilitiesComponent(company)
        return 1
    end
    return 0
end

return script