local json = require("json")
require("files")

local SuccessTokens = {}

SuccessTokens.data = json.decode(readFile(scriptPath().."base/successtokens/successtokens.json"))

SuccessTokens.getTokendata = function (tokenIdentifier)
    for _, token in pairs(SuccessTokens.data.SuccessTokens) do
        if token.Identifier == tokenIdentifier then
            return token
        end
    end
    return nil
end

SuccessTokens.productionTokens = require("base.successtokens.productiontokens")
SuccessTokens.financesTokens = require("base.successtokens.financestokens")
SuccessTokens.researchTokens = require("base.successtokens.researchtokens")
SuccessTokens.marketTokens = require("base.successtokens.markettokens")

SuccessTokens.create = function()
    SuccessTokens.productionTokens.create(SuccessTokens)
    SuccessTokens.financesTokens.create(SuccessTokens)
    SuccessTokens.researchTokens.create(SuccessTokens)
    SuccessTokens.marketTokens.create(SuccessTokens)
end

SuccessTokens.init = function()
    SuccessTokens.productionTokens.init(SuccessTokens)
    SuccessTokens.financesTokens.init(SuccessTokens)
    SuccessTokens.researchTokens.init(SuccessTokens)
    SuccessTokens.marketTokens.init(SuccessTokens)
    world:ExecuteFunctionOnMonthEnd(SuccessTokens.notifyDossier)
end

SuccessTokens.notify = function(tokenIdentifier, tokenTitle)
    local notif_ent = notificationservice:CreateOrGetNotification(tokenIdentifier)
    local notification = entities:GetNotificationComponent(notif_ent)
    notification.Type = NotificationType.SuccessToken
    notification.StringIdentifier = "Success token granted: '[name]'"
    notification.ReplacementParameters:add("name:T!"..tokenTitle)
end

SuccessTokens.notifyDossier = function()
    local notif_ent = notificationservice:CreateOrGetNotification("success_dossier_notification")
    local notification = entities:GetNotificationComponent(notif_ent)
    notification.Type = NotificationType.SuccessDossier
    notification.StringIdentifier = "Success dossier updated!"
    world:ExecuteFunctionOnMonthEnd(SuccessTokens.notifyDossier)
end

return SuccessTokens