local researchTokens = {}
researchTokens.tokens = {}

researchTokens.create = function(SuccessTokens)
    researchTokens.tokens = SuccessTokens
    local totalNumResearchData = SuccessTokens.getTokendata("research_total")

    for i,metric in pairs(totalNumResearchData.Metrics) do
        local points = totalNumResearchData.Points[i]
        local tokenIdentifier = "research_total_"..tostring(i)
        successtokenservice:InitToken(world.PlayerCompanyID, tokenIdentifier, points)
        if i == 1 then
            successtokenservice:UpdateProgress(world.PlayerCompanyID, tokenIdentifier, 0)
        end
    end
end

researchTokens.init = function(SuccessTokens)
    researchTokens.totalNumResearchData = SuccessTokens.getTokendata("research_total")

    local researchTC = triggercount:GetOrCreateTriggerCount("research_total_1", world.PlayerCompanyID)
    researchTC:CountResearchProjects(TriggerCountType.Total, 0, 0)
    researchTC:SetProgressFunction(function (te, tc, tct)
        local currentProgress = tct.CurrentCount
        successtokenservice:UpdateProgress(world.PlayerCompanyID, "research_total_1", currentProgress)
        for i,metric in pairs(researchTokens.totalNumResearchData.Metrics) do
            local tokenIdentifier = "research_total_"..tostring(i)
            if currentProgress >= metric then
                -- this token is permanent once earned and thus is never dropped
                if successtokenservice:AwardToken(world.PlayerCompanyID, tokenIdentifier) then
                    researchTokens.tokens.notify(tokenIdentifier, researchTokens.totalNumResearchData.Title)
                end
            end
        end
    end)
end

return researchTokens