local productionTokens = {}

productionTokens.create = function(SuccessTokens)
    local productProductionData = SuccessTokens.getTokendata("production_products")

    for i,metric in pairs(productProductionData.Metrics) do
        local points = productProductionData.Points[i]
        local tokenIdentifier = "production_products_"..tostring(i)
        successtokenservice:InitToken(world.PlayerCompanyID, tokenIdentifier, points)
        if i == 1 then
            successtokenservice:UpdateProgress(world.PlayerCompanyID, tokenIdentifier, 0)
        end
    end

    local moduleProductionData = SuccessTokens.getTokendata("production_modules")

    for i,metric in pairs(moduleProductionData.Metrics) do
        local points = moduleProductionData.Points[i]
        local tokenIdentifier = "production_modules_"..tostring(i)
        successtokenservice:InitToken(world.PlayerCompanyID, tokenIdentifier, points)
        if i == 1 then
            successtokenservice:UpdateProgress(world.PlayerCompanyID, tokenIdentifier, 0)
        end
    end
end

productionTokens.init = function(SuccessTokens)
    productionTokens.productProductionData = SuccessTokens.getTokendata("production_products")

    local productTC = triggercount:GetOrCreateTriggerCount("production_products_1", world.PlayerCompanyID)
    productTC:CountProducts(TriggerCountType.Accumulative, 0, 0)
    productTC:SetProgressFunction(function (te, tc, tct)
        local currentProgress = tct.CurrentCount
        successtokenservice:UpdateProgress(world.PlayerCompanyID, "production_products_1", currentProgress)
    end)

    productionTokens.moduleProductionData = SuccessTokens.getTokendata("production_modules")

    local moduleTC = triggercount:GetOrCreateTriggerCount("production_modules_1", world.PlayerCompanyID)
    moduleTC:CountModules(TriggerCountType.Accumulative, 0, 0)
    moduleTC:SetProgressFunction(function (te, tc, tct)
        local currentProgress = tct.CurrentCount
        successtokenservice:UpdateProgress(world.PlayerCompanyID, "production_modules_1", currentProgress)
    end)


    world:ExecuteFunctionOnMonthEnd(productionTokens.endOfMonthChecker)
end

productionTokens.endOfMonthChecker = function ()
    local productTC = triggercount:GetOrCreateTriggerCount("production_products_1", world.PlayerCompanyID)
    local productProgress = productTC:GetCount()
    for i,metric in pairs(productionTokens.productProductionData.Metrics) do
        local tokenIdentifier = "production_products_"..tostring(i)
        if productProgress >= metric then
            successtokenservice:AwardToken(world.PlayerCompanyID, tokenIdentifier)
        else
            successtokenservice:DropToken(world.PlayerCompanyID, tokenIdentifier)
        end
    end
    productTC:SetCount(0)
    successtokenservice:UpdateProgress(world.PlayerCompanyID, "production_products_1", 0)

    local moduleTC = triggercount:GetOrCreateTriggerCount("production_modules_1", world.PlayerCompanyID)
    local moduleProgress = moduleTC:GetCount()
    for i,metric in pairs(productionTokens.moduleProductionData.Metrics) do
        local tokenIdentifier = "production_modules_"..tostring(i)
        if moduleProgress >= metric then
            successtokenservice:AwardToken(world.PlayerCompanyID, tokenIdentifier)
        else
            successtokenservice:DropToken(world.PlayerCompanyID, tokenIdentifier)
        end
    end
    moduleTC:SetCount(0)
    successtokenservice:UpdateProgress(world.PlayerCompanyID, "production_modules_1", 0)

    world:ExecuteFunctionOnMonthEnd(productionTokens.endOfMonthChecker)
end

return productionTokens