local marketTokens = {}
marketTokens.initializedMarkets = {}
marketTokens.tokens = {}

local productmarketType = 1

marketTokens.create = function(SuccessTokens)
    marketTokens.tokens = SuccessTokens
    entities:ForEachMarketSegmentComponent(function(entity, marketSegment)
        if marketSegment.MarketType == productmarketType then
            local tokenIdentifier = "markets_"..tostring(marketSegment.MarketTargetID).."entered"
            local segmentTokenData = SuccessTokens.getTokendata(tokenIdentifier)
            if segmentTokenData ~= nil then
                local points = segmentTokenData.Points[1]
                successtokenservice:InitToken(world.PlayerCompanyID, tokenIdentifier, points)
                marketTokens.initializedMarkets[marketSegment.MarketTargetID] = true
            else
                LogError("SuccessToken markets scripting encountered a market for which there is no markets_xentered token! marketID: "..marketSegment.MarketTargetID)
            end
        end
    end)
end

marketTokens.init = function(SuccessTokens)
    marketsegmentservice:AddProductsSoldCallback(marketTokens.onProductsSold)
    entities:ForEachMarketSegmentComponent(function(entity, marketSegment)
        if marketSegment.MarketType == productmarketType then
            -- all the markets that exist at this point should already be initialized!
            marketTokens.initializedMarkets[marketSegment.MarketTargetID] = true
        end
    end)
    entities:AddMarketSegmentComponentUpdatedCallback(function (marketSegmentID)
        local marketSegment = entities:GetMarketSegmentComponent(marketSegmentID)
        if marketSegment.MarketType == productmarketType and not marketTokens.initializedMarkets[marketSegment.MarketTargetID] then
            local tokenIdentifier = "markets_"..tostring(marketSegment.MarketTargetID).."entered"
            local segmentTokenData = SuccessTokens.getTokendata(tokenIdentifier)
            if segmentTokenData ~= nil then
                local points = segmentTokenData.Points[1]
                successtokenservice:InitToken(world.PlayerCompanyID, tokenIdentifier, points)
            else
                LogError("SuccessToken markets scripting encountered a market for which there is no markets_xentered token! marketID: "..marketSegment.MarketTargetID)
            end
            -- we set this to true even if there was ne segmentTokenData so that
            -- the if condition is false next time around
            marketTokens.initializedMarkets[marketSegment.MarketTargetID] = true
        end
    end)
end

marketTokens.onProductsSold = function(companyID, blueprintID, amount, moneyReceived)
    local blueprintDef = entities:GetBlueprintDefinitionComponent(blueprintID)
    local marketID = blueprintDef.ProductType
    local tokenIdentifier = "markets_"..tostring(marketID).."entered"
    if successtokenservice:AwardToken(companyID, tokenIdentifier) then
        local tokenData = marketTokens.tokens.getTokendata(tokenIdentifier)
        marketTokens.tokens.notify(tokenIdentifier, tokenData.Title)
    end
end

return marketTokens