local financesTokens = {}
financesTokens.tokens = {}

financesTokens.create = function(SuccessTokens)
    financesTokens.tokens = SuccessTokens
    local totalNetworthData = SuccessTokens.getTokendata("finances_networthtotal")

    for i,metric in pairs(totalNetworthData.Metrics) do
        local points = totalNetworthData.Points[i]
        local tokenIdentifier = "finances_networthtotal_"..tostring(i)
        successtokenservice:InitToken(world.PlayerCompanyID, tokenIdentifier, points)
        if i == 1 then
            successtokenservice:UpdateProgress(world.PlayerCompanyID, tokenIdentifier, 0)
        end
    end

    local monthlyRevenueData = SuccessTokens.getTokendata("finances_revenuemonthly")

    for i,metric in pairs(monthlyRevenueData.Metrics) do
        local points = monthlyRevenueData.Points[i]
        local tokenIdentifier = "finances_revenuemonthly_"..tostring(i)
        successtokenservice:InitToken(world.PlayerCompanyID, tokenIdentifier, points)
        if i == 1 then
            successtokenservice:UpdateProgress(world.PlayerCompanyID, tokenIdentifier, 0)
        end
    end
end

financesTokens.init = function(SuccessTokens)
    financesTokens.totalNetworthData = SuccessTokens.getTokendata("finances_networthtotal")

    local networthTC = triggercount:GetOrCreateTriggerCount("finances_networthtotal_1", world.PlayerCompanyID)
    networthTC:CountNetworth(TriggerCountType.Total, 0)
    networthTC:SetProgressFunction(function (te, tc, tct)
        local currentProgress = tct.CurrentCount
        successtokenservice:UpdateProgress(world.PlayerCompanyID, "finances_networthtotal_1", currentProgress)
        for i,metric in pairs(financesTokens.totalNetworthData.Metrics) do
            local tokenIdentifier = "finances_networthtotal_"..tostring(i)
            if currentProgress >= metric then
                -- this token is permanent once earned and thus is never dropped
                if successtokenservice:AwardToken(world.PlayerCompanyID, tokenIdentifier) then
                    financesTokens.tokens.notify(tokenIdentifier, financesTokens.totalNetworthData.Title)
                end
            end
        end
    end)

    financesTokens.monthlyRevenueData = SuccessTokens.getTokendata("finances_revenuemonthly")

    local revenueTC = triggercount:GetOrCreateTriggerCount("finances_revenuemonthly_1", world.PlayerCompanyID)
    revenueTC:CountBankBalance(TriggerCountType.Accumulative, 0)
    revenueTC:SetProgressFunction(function (te, tc, tct)
        local currentProgress = tct.CurrentCount
        successtokenservice:UpdateProgress(world.PlayerCompanyID, "finances_revenuemonthly_1", currentProgress)
    end)

    world:ExecuteFunctionOnMonthEnd(financesTokens.endOfMonthChecker)
end

financesTokens.endOfMonthChecker = function ()
    local revenueTC = triggercount:GetOrCreateTriggerCount("finances_revenuemonthly_1", world.PlayerCompanyID)
    local revenueProgress = revenueTC:GetCount()
    for i,metric in pairs(financesTokens.monthlyRevenueData.Metrics) do
        local tokenIdentifier = "finances_revenuemonthly_"..tostring(i)
        if revenueProgress >= metric then
            successtokenservice:AwardToken(world.PlayerCompanyID, tokenIdentifier)
        else
            successtokenservice:DropToken(world.PlayerCompanyID, tokenIdentifier)
        end
    end
    revenueTC:SetCount(0)
    successtokenservice:UpdateProgress(world.PlayerCompanyID, "finances_revenuemonthly_1", 0)

    world:ExecuteFunctionOnMonthEnd(financesTokens.endOfMonthChecker)
end

return financesTokens