local script = {}
script.activate = {}
script.initfunc = {}
script.deactivate = {}

local utils = {}
utils.products = require("base.utils.products")
utils.gdh = require("base.utils.gamedatahelper")
utils.milestones = require("base.utils.milestones")
utils.markets = require("base.utils.markets")

-----------------------------------------------------------------------------
--                          start / load / init                            --
-----------------------------------------------------------------------------
script.on_init = function(file_path, folder_path, isload)
  script.json = utils.milestones.on_init(scriptPath()..file_path, isload)
  script.level_id = utils.milestones.set_level(folder_path, isload)
  milestones:SetMilestoneJsonFile("Mods/"..file_path)

  script.set_milestones()
  if isload then
    script.on_load()
  else
    script.on_start()
  end
end


script.on_start = function()
  milestones:ActivateNextMilestone(world.PlayerCompanyID)

  --skip milestones
  for i=1, 0 do 
    world:ExecuteFunctionInTime(i/10, function()
      milestones:ActivateNextMilestone(world.PlayerCompanyID)
    end)
  end
end


script.on_load = function()
end


-----------------------------------------------------------------------------
--                    set all milestone functions                          --
-----------------------------------------------------------------------------
script.set_milestones = function()
  for i = 1, #script.json.Data do
    if script.activate[i] ~= nil then
      milestones:MilestoneActivatedFunction(i-1, script.activate[i])
    else
      milestones:MilestoneActivatedFunction(i-1, script.activate[0])
    end

    if script.initfunc[i] ~= nil then
      milestones:MilestoneInitFunction(i-1, script.initfunc[i])
    else
      milestones:MilestoneInitFunction(i-1, script.initfunc[0])
    end

    if script.deactivate[i] ~= nil then
      milestones:MilestoneDeactivatedFunction(i-1, script.deactivate[i])
    else
      milestones:MilestoneDeactivatedFunction(i-1, script.deactivate[0])
    end
  end
end


-----------------------------------------------------------------------------
--                           default functions                             --
-----------------------------------------------------------------------------
script.activate[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  milestones:SetProgress(company, 0)
  utils.milestones.add_handbook_pages(script.json.Data[ms.CurrentMilestoneIndex+1])
  --Utils.milestones.set_all_messages(company, script.json.Data[ms.CurrentMilestoneIndex+1])
end

script.initfunc[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  utils.milestones.set_counter(company, goal, index)
end

script.deactivate[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)
end

return script