--------------------------------------------------------------------
-- !uigate console command: sets the current UI gating state
--------------------------------------------------------------------

local uigate = {}
local run = require("run")

uigate.PrintHelpString = function()
    print_info("<b>!uigate</b> ( <i>uiElementEnum, state</i> )\nLocks/unlocks a UI element.")
end

uigate.ExecuteCommand = function(uiElement, state)
    local lua_code = [[
    uigatingservice:MakeUIElementAvailable (uiElement, state)
    ]]
    
    lua_code = lua_code:gsub("uiElement", uiElement)
    lua_code = lua_code:gsub("state", state)
    
    run.ExecuteCommand(lua_code)
end

return uigate