--------------------------------------------------------------------
-- !teachme console command: unlocks a research project
--------------------------------------------------------------------

local teachme = {}
local run = require("run")

teachme.PrintHelpString = function()
    print_info("<b>!teachme</b> ( <i>projectID</i> )\nUnlocks a research project.")
end

teachme.ExecuteCommand = function(projectID)
    local lua_code = [[
        if projectID == 0 or "projectID" == "all" then
            local gamedata = require("base.utils.gamedata")
            for name, id in pairs(gamedata.researches) do
                researchservice:UnlockResearchProject(world.PlayerCompanyID, id, false, false)
            end
            return "all research projects unlocked."
        else
            local pid = projectID
            if type(pid) ~= "number" then
                local gdh = require("base.utils.gamedatahelper")
                pid = gdh.get_research_id_by_name("projectID")
            end
            if type(pid) == "number" and pid ~= 0 then
                if gamedata:GetResearchProject(pid) ~= nil then
                    researchservice:UnlockResearchProject(world.PlayerCompanyID, pid, true, true)
                    return "research project 'projectID' unlocked."
                else
                    return "research project 'projectID' not found."
                end
            else
                return "research project 'projectID' not found."
            end
        end
    ]]
    
    lua_code = lua_code:gsub("projectID", projectID)
    
    run.ExecuteCommand(lua_code)
end

return teachme