-----------------------------------------------------------------------
-- !player_show console command: shows or hides the player character
-----------------------------------------------------------------------

local player_show = {}
local run = require("run")

player_show.PrintHelpString = function()
    print_info("<b>!player_show</b> ( <i>visible</i> )\nShows or hides the player character.")
end

player_show.ExecuteCommand = function(visible)
    local playerID = root.CurrentSession.Player.ID
    local lua_code = [[
    local lookComponent = entities:GetCharacterLookComponent(playerID)
	lookComponent.Visible = visible
	entities:UpdateCharacterLookComponent(playerID)
	if visible then
		return "player character visible."
	else
		return "player character hidden."
	end
    ]]
    lua_code = lua_code:gsub("playerID", playerID)
    lua_code = lua_code:gsub("visible", tostring(visible))
    run.ExecuteCommand(lua_code)
end

return player_show