--------------------------------------------------------------------
-- !notify console command: creates a new notification
--------------------------------------------------------------------

local notify = {}
local run = require("run")

notify.PrintHelpString = function()
    print_info("<b>!notify</b> ( <i>identifier, type, flags [, parameter, icon, text]</i> )\ncreates a new notification.")
end

notify.ExecuteCommand = function(identifier, notificationType, flags, parameter, icon, text)
    local lua_code = [[
        local n = notificationservice:CreateOrGetNotification("identifier")
        ncomp = entities:GetNotificationComponent(n)
        ncomp.Type = notificationType
        ncomp.Flags = flags
        ncomp.Icon = "icon"
        ncomp.StringIdentifier = "text"
        ncomp.IdParameter = parameter
        entities:UpdateNotificationComponent(n)
        return "notification 'identifier' created."
        ]]


    lua_code = lua_code:gsub("identifier", identifier)
    lua_code = lua_code:gsub("notificationType", tostring(notificationType))
    lua_code = lua_code:gsub("flags", flags)
    lua_code = lua_code:gsub("parameter", tostring(parameter))
    
    if text ~= nil then
        lua_code = lua_code:gsub("icon", tostring(icon))
    else
        lua_code = lua_code:gsub("icon", "icons_common/star")
    end
    
    if text ~= nil then
        lua_code = lua_code:gsub("text", text)
    else
        lua_code = lua_code:gsub("text", "(empty string)")
    end
    
    run.ExecuteCommand(lua_code)
end

return notify