----------------------------------------------------------------------------------
-- !list_modules console command: lists all modules with their ids and slot types 
----------------------------------------------------------------------------------

local list_modules = {}

list_modules.PrintHelpString = function()
    print_info("<b>!list_lookparts</b> ( <i>productPartsOnly</i> )\nLists all modules with their ids and slot types.")
end

list_modules.ExecuteCommand = function(productPartsOnly)
    if root.CurrentSession == nil then
      print_error("There's no session running currently!")
      return
    end
    
    local gameDB = root.CurrentSession.GameDB
    console.ListOut:ListModules(
        gameDB,
        productPartsOnly == true or
        productPartsOnly > 0)
end

return list_modules;