------------------------------------------------------------------------
-- !connect console command: connects the frontend to a backend process
------------------------------------------------------------------------

local connect = {}

local function __onSessionStarted()
    print_success("connection established", ConsoleMsgType.Success);
    -- TODO: find a way to remove event listeners without crashing
    -- root.SessionState.GameStarted:Remove(__onSessionStarted);
    -- root.SessionState.Disconnected:Remove(__onSessionEnded);
end

local function __onSessionEnded()
    print_warning("disconnected: session ended", ConsoleMsgType.Warning);
    -- TODO: find a way to remove event listeners without crashing
    -- root.SessionState.GameStarted:Remove(__onSessionStarted);
    -- root.SessionState.Disconnected:Remove(__onSessionEnded);
end

connect.PrintHelpString = function()
    print_info("<b>!connect</b> ( <i>address, port, username</i> )\nConnects the client to a game server at a given <i>address</i> through a given <i>port</i> and a <i>username</i>.")
end

connect.ExecuteCommand = function()
    if address == nil or port == nil or username == nil then
        root.MainMenu:JoinGame()
        return
    end

    print_info("connecting to host: " .. tostring(address), ConsoleMsgType.Info);
    print_info("port: " .. tostring(port), ConsoleMsgType.Info);
    print_info("user name: " .. tostring(username), ConsoleMsgType.Info);

    root:InitializeSession(MainMenu.StartMode.Join);
    root.SessionState.GameStarted:Add(__onSessionStarted);
    root.SessionState.Disconnected:Add(__onSessionEnded);
    root.SessionState:JoinRemoteSessionWithCredentials(tostring(username), tostring(address), tostring(port))
end

return connect;