----------------------------------------------------------------------------
-- !bp_create console command: creates a blueprint for the player's company
----------------------------------------------------------------------------

local bp_create = {}
local run = require("run")

bp_create.PrintHelpString = function()
    print_info("<b>!bp_create</b> ( <i>name, productTypeID, modulesIDs[...]</i> )\nCreates a blueprint for the player's company.")
end

bp_create.ExecuteCommand = function(name, productTypeID, moduleIDs)
    local lua_code = [[
        local productEnt = blueprintdefinitionservice:CreateNewBlueprint(
          world.PlayerCompanyID, productTypeID)
        moduleIDs = #MODULE_ARRAY#
        
        blueprintdefinitionservice:SetBlueprintSettings(
            productEnt, "name", productTypeID)
        
        local productTypeDef = gamedata:GetProductType(productTypeID)
        for k,v in pairs(moduleIDs) do
            local moduleDef = gamedata:GetModule(v)
            local moduleSlotTypeID= moduleDef.FitsIntoSlot
            local foundSlotInProduct= false
            for productSlotIndex = 1,#productTypeDef.SlotTypes do
              if moduleSlotTypeID == productTypeDef.SlotTypes[productSlotIndex].SlotID then
                blueprintdefinitionservice:SetBlueprintSlot(
                  productEnt, productSlotIndex-1, v)
                foundSlotInProduct = true
              end
            end
            if not foundSlotInProduct then
              LogError("In product 'name': Module "..moduleDef.Name.." doesn't fit into producttype "..productTypeDef.Name)
            end
        end
        
        local result = blueprintdefinitionservice:AdvanceBlueprintPhase(productEnt)
        if result > 0 then
            return "blueprint creation failed."
        else
            return "blueprint creation succeeded."
        end
    ]]
    local set_slots_code = "{"
    local first = true
    for k,v in pairs(moduleIDs) do
        if first then
            first = false
        else
            set_slots_code = set_slots_code .. ","
        end
        set_slots_code = set_slots_code .. tostring(v)
    end
    set_slots_code = set_slots_code .. "}"
    
    lua_code = lua_code:gsub("name", name)
    lua_code = lua_code:gsub("productTypeID", productTypeID)
    lua_code = lua_code:gsub("#MODULE_ARRAY#", set_slots_code)
    run.ExecuteCommand(lua_code)
    
end

return bp_create