local script = {}
script.activate = {}
script.initfunc = {}
script.deactivate = {}

local utils = {}
utils.milestones = require("base.utils.milestones")
utils.equipment = require("base.utils.equipment")
utils.gamedata = require("base.utils.gamedata")

-----------------------------------------------------------------------------
--                          start / load / init                            --
-----------------------------------------------------------------------------
script.on_init = function(file_path, folder_path, isload)
  script.json = utils.milestones.on_init(scriptPath()..file_path, isload)
  script.level_id = utils.milestones.set_level(folder_path, isload)
  milestones:SetMilestoneJsonFile("Mods/"..file_path)
  script.set_milestones()

  if not isload then
    script.on_start()
  end
end

script.on_start = function(startms)
  entities:ForEachBuildingForSalePointComponent(function(entity)
    local look = entities:GetObjectLookComponent(entity)
    look.Visible = false
    entities:UpdateObjectLookComponent(entity)
  end)
  milestones:ActivateNextMilestone(world.PlayerCompanyID)
end

-----------------------------------------------------------------------------
--                    set all milestone functions                          --
-----------------------------------------------------------------------------
script.set_milestones = function()
  for i = 1, #script.json.Data do
    if script.activate[i] ~= nil then
      milestones:MilestoneActivatedFunction(i-1, script.activate[i])
    else
      milestones:MilestoneActivatedFunction(i-1, script.activate[0])
    end

    if script.initfunc[i] ~= nil then
      milestones:MilestoneInitFunction(i-1, script.initfunc[i])
    else
      milestones:MilestoneInitFunction(i-1, script.initfunc[0])
    end

    if script.deactivate[i] ~= nil then
      milestones:MilestoneDeactivatedFunction(i-1, script.deactivate[i])
    else
      milestones:MilestoneDeactivatedFunction(i-1, script.deactivate[0])
    end
  end
end


-----------------------------------------------------------------------------
--                           default functions                             --
-----------------------------------------------------------------------------
script.activate[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  utils.milestones.add_handbook_pages(script.json.Data[ms.CurrentMilestoneIndex+1])
  utils.milestones.set_all_messages(company, script.json.Data[ms.CurrentMilestoneIndex+1])
  milestones:SetProgress(company, 0)
end


script.initfunc[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  utils.milestones.set_counter(company, goal, index)
end


script.deactivate[0] = function(company)
  local milestone_comp = entities:GetMilestoneComponent(company)
  local index = milestone_comp.CurrentMilestoneIndex + 1
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)
end

-----------------------------------------------------------------------------
--                              milestone 02                               --
-----------------------------------------------------------------------------

script.initfunc[2] = function(company)
  local index = 2
  local goal = script.json.Data[index].Goal
  entities:AddBlueprintDefinitionComponentUpdatedCallback(function (blueprintID)
    local blueprintDefinition = entities:GetBlueprintDefinitionComponent(blueprintID)
    if blueprintDefinition.Phase == 1 then
        local features = entities:GetFeaturesComponent(blueprintID)
        local processingPowerFeatureID = 69
        local blueprintProcessingFeatureValue = features:GetFeatureValue(processingPowerFeatureID)
        if blueprintProcessingFeatureValue.Value >= goal.ProcessingPower * 10 then
            local ms = entities:GetMilestoneComponent(company)
            if ms.CurrentMilestoneIndex+1 == index then
                milestones:ActivateNextMilestone(company)
            end
        end
    end
  end)
end

-----------------------------------------------------------------------------
--                              milestone 03                               --
-----------------------------------------------------------------------------

script.initfunc[3] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  local customCounter = utils.milestones.set_counter(company, goal, index)
  entities:AddProductComponentUpdatedCallback(function (productEntity) 
    local productComp = entities:GetProductComponent(productEntity)
    local features = entities:GetFeaturesComponent(productComp.BlueprintID)
    local processingPowerFeatureID = 69
    local blueprintProcessingFeatureValue = features:GetFeatureValue(processingPowerFeatureID)
    if blueprintProcessingFeatureValue.Value >= goal.ProcessingPower * 10 then
        customCounter:IncrementCount(1)
    end
  end)
end


-----------------------------------------------------------------------------
--                              milestone 04                               --
-----------------------------------------------------------------------------
script.deactivate[4] = function(company)
  local milestone_comp = entities:GetMilestoneComponent(company)
  local index = milestone_comp.CurrentMilestoneIndex + 1
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)

  entities:ForEachBuildingForSalePointComponent(function(entity)
    local look = entities:GetObjectLookComponent(entity)
    look.Visible = true
    entities:UpdateObjectLookComponent(entity)
  end)
end


-----------------------------------------------------------------------------
--                              milestone 05                               --
-----------------------------------------------------------------------------
script.initfunc[5] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  local customCounter = utils.milestones.set_counter(company, goal, index)
  entities:AddBuildingComponentUpdatedCallback(function (buildingEntity) 
    local buildingComp = entities:GetBuildingComponent(buildingEntity)
    if buildingComp.Unlocked then
        customCounter:IncrementCount(1)
    end
  end)
end


-----------------------------------------------------------------------------
--                              milestone 06                               --
-----------------------------------------------------------------------------

script.initfunc[6] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  local customCounter = utils.milestones.set_counter(company, goal, index)
  marketsegmentservice:AddProductsSoldCallback(function (companyID, blueprintID, amount, moneyReceived)
    local blueprintDefinition = entities:GetBlueprintDefinitionComponent(blueprintID)
    if blueprintDefinition.ProductType == 8 then
      customCounter:IncrementCount(moneyReceived)
    end
  end)
end

script.deactivate[6] = function(company)
  local tier4researchIDs = {
    66,
    74,
    80}
  researchservice:ShowProjects(company, tier4researchIDs)
  utils.milestones.display_notification(6, script.json.Data[6])
  utils.milestones.give_rewards(company, script.json.Data[6].Rewards)
end

return script