local script = {}
script.activate = {}
script.initfunc = {}
script.deactivate = {}

local utils = {}
utils.milestones = require("base.utils.milestones")
utils.equipment = require("base.utils.equipment")
utils.gamedata = require("base.utils.gamedata")
utils.research = require("base.utils.research")
utils.products = require("base.utils.products")
utils.session = require("base.utils.session")

-----------------------------------------------------------------------------
--                          start / load / init                            --
-----------------------------------------------------------------------------
script.on_init = function(file_path, folder_path, isload)
  script.json = utils.milestones.on_init(scriptPath()..file_path, isload)
  script.level_id = utils.milestones.set_level(folder_path, isload)
  milestones:SetMilestoneJsonFile("Mods/"..file_path)
  script.set_milestones()

  script.cnumbers = entities:GetOrAssignCustomValuesComponent(1).CustomNumbers
  if isload then
    script.on_load()
  else
    script.on_start()
  end
end

script.on_start = function(startms)
  buildingservice:UnlockBuildingByIndex(2, world.PlayerCompanyID)
  script.setup()

  utils.research.set_research_progress(world.PlayerCompanyID, utils.gamedata.researches.itm_battery_stack, 0.79)
  utils.research.set_research_progress(world.PlayerCompanyID, utils.gamedata.researches.itm_wood_case, 0.79)
  utils.research.set_research_progress(world.PlayerCompanyID, utils.gamedata.researches.itm_plastic_case, 0.79)
  milestones:ActivateNextMilestone(world.PlayerCompanyID)
end


script.on_load = function()
end


-----------------------------------------------------------------------------
--               setting up a almost functional company                    --
-----------------------------------------------------------------------------
script.setup = function()
  script.cnumbers = entities:GetOrAssignCustomValuesComponent(1).CustomNumbers
  script.cnumbers:add(0) --first blueprint [1]
  script.cnumbers[1] = blueprintdefinitionservice:CreateNewBlueprint(world.PlayerCompanyID, utils.gamedata.product_types.type_calculator)
  blueprintdefinitionservice:SetBlueprintSettings(script.cnumbers[1], "Calculator", utils.gamedata.modules.itm_simple_case)
  blueprintdefinitionservice:PlaceModule(script.cnumbers[1], utils.gamedata.modules.itm_led_array, 2, 1, 0)
  blueprintdefinitionservice:PlaceModule(script.cnumbers[1], utils.gamedata.modules.itm_single_cell_battery, 2, 2, 0)
  blueprintdefinitionservice:AdvanceBlueprintPhase(script.cnumbers[1])

  
  assemblerservice:SetAssemblerToBlueprint(utils.session.data.logisticsIDs["assembly"], script.cnumbers[1])  
  logisticsservice:CreateBatchedConnection(
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_assembly_in"], -2), 
    ConnectionEntity.new(utils.session.data.logisticsIDs["assembly"], -2), 
  1)
  logisticsservice:CreateBatchedConnection(
    ConnectionEntity.new(utils.session.data.logisticsIDs["assembly"], -2), 
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_assembly_out"], -2), 
  1)
  
  buyservice:TryIncreaseMaterialOrder(utils.session.data.logisticsIDs["buy_box"], utils.gamedata.materials.itm_plastic)
  buyservice:TryIncreaseMaterialOrder(utils.session.data.logisticsIDs["buy_box"], utils.gamedata.materials.itm_electronic_component)
  buyservice:TryIncreaseMaterialOrder(utils.session.data.logisticsIDs["buy_box"], utils.gamedata.materials.itm_chemicals)  
  logisticsservice:CreateBatchedConnection(
    ConnectionEntity.new(utils.session.data.logisticsIDs["buy_box"], -2), 
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_led"], -2), 
  1)
  logisticsservice:CreateBatchedConnection(
    ConnectionEntity.new(utils.session.data.logisticsIDs["buy_box"], -2), 
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_battery"], -2), 
  1)
  logisticsservice:CreateBatchedConnection(
    ConnectionEntity.new(utils.session.data.logisticsIDs["buy_box"], -2), 
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_case"], -2), 
  1)

  logisticsservice:CreateBatchedConnection(
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_led"], -2), 
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_assembly_in"], -2), 
  1)
  logisticsservice:CreateBatchedConnection(
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_battery"], -2), 
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_assembly_in"], -2), 
  1)
  logisticsservice:CreateBatchedConnection(
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_case"], -2), 
    ConnectionEntity.new(utils.session.data.logisticsIDs["shelf_assembly_in"], -2), 
  1)

  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["buy_box"], utils.gamedata.materials.itm_plastic, 12)
  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["buy_box"], utils.gamedata.materials.itm_electronic_component, 17)
  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["buy_box"], utils.gamedata.materials.itm_chemicals, 14)

  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["shelf_led"], utils.gamedata.materials.itm_electronic_component, 22)
  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["shelf_battery"], utils.gamedata.materials.itm_chemicals, 27)
  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["shelf_case"], utils.gamedata.materials.itm_plastic, 26)

  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["shelf_led"], utils.gamedata.materials.itm_led_array, 5)
  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["shelf_battery"], utils.gamedata.materials.itm_single_cell_battery, 2)
  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["shelf_case"], utils.gamedata.materials.itm_simple_case, 3)

  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["shelf_assembly_in"], utils.gamedata.materials.itm_led_array, 6)
  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["shelf_assembly_in"], utils.gamedata.materials.itm_single_cell_battery, 8)
  inventorytransferservice:CreateMaterialInInventory(utils.session.data.logisticsIDs["shelf_assembly_in"], utils.gamedata.materials.itm_simple_case, 3)

  assemblerservice:CreateProduct(script.cnumbers[1], utils.session.data.logisticsIDs["shelf_assembly_out"])
  assemblerservice:CreateProduct(script.cnumbers[1], utils.session.data.logisticsIDs["shelf_assembly_out"])
  assemblerservice:CreateProduct(script.cnumbers[1], utils.session.data.logisticsIDs["sell_box"])
  assemblerservice:CreateProduct(script.cnumbers[1], utils.session.data.logisticsIDs["sell_box"])

  local employeeID = employeeservice:GenerateNewApplicant(math.random(999999), 0, 5, 1.0)
  employeeservice:HireApplicant(employeeID, world.PlayerCompanyID, utils.session.data.logisticsIDs["logistics_b"])
  local position = positionservice:GetCurrentPosition(utils.session.data.logisticsIDs["logistics_b"])
  position.Y = position.Y - 1
  positionservice:TeleportEntityToPosition(employeeID, position)
  aiservice:SetWorkplaceForAI(employeeID, utils.session.data.logisticsIDs["logistics_b"])
end


-----------------------------------------------------------------------------
--                    set all milestone functions                          --
-----------------------------------------------------------------------------
script.set_milestones = function()
  for i = 1, #script.json.Data do
    if script.activate[i] ~= nil then
      milestones:MilestoneActivatedFunction(i-1, script.activate[i])
    else
      milestones:MilestoneActivatedFunction(i-1, script.activate[0])
    end

    if script.initfunc[i] ~= nil then
      milestones:MilestoneInitFunction(i-1, script.initfunc[i])
    else
      milestones:MilestoneInitFunction(i-1, script.initfunc[0])
    end

    if script.deactivate[i] ~= nil then
      milestones:MilestoneDeactivatedFunction(i-1, script.deactivate[i])
    else
      milestones:MilestoneDeactivatedFunction(i-1, script.deactivate[0])
    end
  end
end


-----------------------------------------------------------------------------
--                           default functions                             --
-----------------------------------------------------------------------------
script.activate[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  milestones:SetProgress(company, 0)
  utils.milestones.add_handbook_pages(script.json.Data[ms.CurrentMilestoneIndex+1])
  utils.milestones.set_all_messages(company, script.json.Data[ms.CurrentMilestoneIndex+1])
end


script.initfunc[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  utils.milestones.set_counter(company, goal, index)
end

script.deactivate[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)
end


-----------------------------------------------------------------------------
--                              milestone 01                               --
-----------------------------------------------------------------------------
script.initfunc[1] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  
  local counter = utils.milestones.set_counter(company, goal, index)
  inventorytransferservice:AddInventoryTransferCallback(function (from_entity, to_entity, mat_amount_list, ent_list)
    if entities:HasSellPlaceComponent(to_entity) and entities:HasAILogisticsComponent(from_entity) then
      counter:IncrementCount(#ent_list)
    end
  end)
end


-----------------------------------------------------------------------------
--                              milestone 02                               --
-----------------------------------------------------------------------------
script.deactivate[2] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  milestones:SetProgress(company, 0)
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)

  utils.research.set_research_progress(world.PlayerCompanyID, utils.gamedata.researches.itm_led_matrix, 0.499)
end


-----------------------------------------------------------------------------
--                              milestone 03                               --
-----------------------------------------------------------------------------
script.initfunc[3] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  
  local counter = utils.milestones.set_counter(company, goal, index)
  for i=1, #goal.ModuleList do
    local c = triggercount:GetOrCreateTriggerCount("ms"..tostring(index).."_subcounter_"..tostring(i), company)
    c:CountModules(TriggerCountType.Accumulative, goal.ModuleList[i], 0)
    c:SetProgressFunction(function(_, _, tct)
      counter:IncrementCount(tct.CurrentCount - tct.PreviousCount)
    end)
  end
    
  counter:SetTriggerFunction(function(ent, tc, tct)
      local ms = entities:GetMilestoneComponent(company)
      if ms.CurrentMilestoneIndex+1 == index then
          milestones:ActivateNextMilestone(company)
      end
      triggercount:RemoveTrigger("mstrigger_"..tostring(index))
      for i=1, #goal.ModuleList do
        triggercount:RemoveTrigger("ms"..tostring(index).."_subcounter_"..tostring(i))
      end
  end)
end


-----------------------------------------------------------------------------
--                              milestone 04                               --
-----------------------------------------------------------------------------
script.initfunc[4] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  
  local counter = utils.milestones.set_counter(company, goal, index)    
        
  marketsegmentservice:AddProductsSoldCallback(function(cid, blueprintID, amount, moneyReceived)
    local msd = entities:GetMilestoneComponent(company)
    if cid == company and msd.CurrentMilestoneIndex == index-1 and blueprintID ~= script.cnumbers[1] then
      counter:IncrementCount(moneyReceived)
    end
  end)
end


-----------------------------------------------------------------------------
--                              milestone 05                               --
-----------------------------------------------------------------------------
script.deactivate[5] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  milestones:SetProgress(company, 0)
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)

  entities:ForEachBuildingForSalePointComponent(function(entity)
    local look = entities:GetObjectLookComponent(entity)
    look.Visible = true
    entities:UpdateObjectLookComponent(entity)
  end) 
end

return script