local script = {}
script.activate = {}
script.initfunc = {}
script.deactivate = {}

local utils = {}
utils.milestones = require("base.utils.milestones")
utils.equipment = require("base.utils.equipment")
utils.gamedata = require("base.utils.gamedata")

-----------------------------------------------------------------------------
--                          start / load / init                            --
-----------------------------------------------------------------------------
script.on_init = function(file_path, folder_path, isload)
  script.json = utils.milestones.on_init(scriptPath()..file_path, isload)
  script.level_id = utils.milestones.set_level(folder_path, isload)
  milestones:SetMilestoneJsonFile("Mods/"..file_path)

  script.cnumbers = entities:GetOrAssignCustomValuesComponent(1).CustomNumbers
  script.set_milestones()

  if isload then
    script.on_load()
  else
    script.on_start()
  end
end

script.on_start = function()
  utils.equipment.SetPlayerEquipment(23, 3, -2, 3)

  local buybox = utils.equipment.SetPlayerEquipment(11, -1, -3, 3)
  buyservice:TryIncreaseMaterialOrder(buybox, 238)
  inventorytransferservice:CreateMaterialInInventory(buybox, 238, 40)

  script.cnumbers = entities:GetOrAssignCustomValuesComponent(1).CustomNumbers
  script.cnumbers:add(0) --first blueprint [1]
  script.cnumbers:add(0) --second blueprint [2]

  milestones:ActivateNextMilestone(world.PlayerCompanyID)
end

script.on_load = function()
end

-----------------------------------------------------------------------------
--                    set all milestone functions                          --
-----------------------------------------------------------------------------
script.set_milestones = function()
  for i = 1, #script.json.Data do
    if script.activate[i] ~= nil then
      milestones:MilestoneActivatedFunction(i-1, script.activate[i])
    else
      milestones:MilestoneActivatedFunction(i-1, script.activate[0])
    end

    if script.initfunc[i] ~= nil then
      milestones:MilestoneInitFunction(i-1, script.initfunc[i])
    else
      milestones:MilestoneInitFunction(i-1, script.initfunc[0])
    end

    if script.deactivate[i] ~= nil then
      milestones:MilestoneDeactivatedFunction(i-1, script.deactivate[i])
    else
      milestones:MilestoneDeactivatedFunction(i-1, script.deactivate[0])
    end
  end
end


-----------------------------------------------------------------------------
--                           default functions                             --
-----------------------------------------------------------------------------
script.activate[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  milestones:SetProgress(company, 0)
  utils.milestones.add_handbook_pages(script.json.Data[ms.CurrentMilestoneIndex+1])
  utils.milestones.set_all_messages(company, script.json.Data[ms.CurrentMilestoneIndex+1])
end


script.initfunc[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  utils.milestones.set_counter(company, goal, index)
end


script.deactivate[0] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)
end

-----------------------------------------------------------------------------
--                              Milestone 01                               --
-----------------------------------------------------------------------------
script.deactivate[1] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  milestones:SetProgress(company, 0)
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)

  utils.equipment.SetPlayerEquipment(12, -1, -6, 3) -- sell area
end


-----------------------------------------------------------------------------
--                              Milestone 02                               --
-----------------------------------------------------------------------------
script.initfunc[2] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  local counter = utils.milestones.set_counter(company, goal, index)
  inventorytransferservice:AddInventoryTransferCallback(function(fromEnt, toEnt, mats, ents)
    if toEnt ~= 0 and ms.CurrentMilestoneIndex + 1 == index then
      local toSell = entities:HasSellPlaceComponent(toEnt)
      local fromSell = entities:HasSellPlaceComponent(fromEnt)
      if toSell or fromSell then
        local moduleID = utils.gamedata.modules[goal.ModuleID]
        local moduleMatID = utils.gamedata.materials[goal.ModuleID]
        local moduleWorth = gamedata:GetModule(moduleID).BaseMarketPrice
        
        for i = 1,#mats do
          if mats[i].MaterialID == moduleMatID then
            local worth = mats[i].Amount * moduleWorth
            if fromSell then worth = -1 * worth end
            counter:IncrementCount(worth)
          end
        end
      end
    end
  end)
end

script.deactivate[2] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  milestones:SetProgress(company, 0)
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)
end


-----------------------------------------------------------------------------
--                              Milestone 04                               --
-----------------------------------------------------------------------------
script.initfunc[4] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  local counter = utils.milestones.set_counter(company, goal, index)

  inventorytransferservice:AddInventoryTransferCallback(function (from, to, mats, _)
    if ms.CurrentMilestoneIndex + 1 == index and from == 0 and entities:HasEmployeeComponent(to) then
      for i=1, #mats do
        if mats[i].MaterialID == 241 or mats[i].MaterialID == 240 then
          counter:IncrementCount(mats[i].Amount)
        end
      end
    end
  end)
end


-----------------------------------------------------------------------------
--                              Milestone 06                               --
-----------------------------------------------------------------------------
script.deactivate[6] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  milestones:SetProgress(company, 0)
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)

  world:ExecuteFunctionInTime(0, function ()
    -- setup simple calculator blueprint
    script.cnumbers = entities:GetOrAssignCustomValuesComponent(1).CustomNumbers
    script.cnumbers[1] = blueprintdefinitionservice:CreateNewBlueprint(company, 7) --calculator
    blueprintdefinitionservice:SetBlueprintSettings(script.cnumbers[1], "Calculator", 182) --simple case
    blueprintdefinitionservice:PlaceModule(script.cnumbers[1], 180, 2, 1, 0) --led array
    blueprintdefinitionservice:PlaceModule(script.cnumbers[1], 181, 2, 2, 0) --single cell battery
    blueprintdefinitionservice:AdvanceBlueprintPhase(script.cnumbers[1])
  end)
end


-----------------------------------------------------------------------------
--                              Milestone 07                               --
-----------------------------------------------------------------------------
script.deactivate[7] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  milestones:SetProgress(company, 0)
  utils.milestones.display_notification(index, script.json.Data[index])
  utils.milestones.give_rewards(company, script.json.Data[index].Rewards)

  script.cnumbers = entities:GetOrAssignCustomValuesComponent(1).CustomNumbers
  script.cnumbers[2] = blueprintdefinitionservice:CreateNewBlueprint(company, 7) --calculator
  blueprintdefinitionservice:SetBlueprintSettings(script.cnumbers[2], "Calculator Mk2", 182) --simple case
  blueprintdefinitionservice:PlaceModule(script.cnumbers[2], 180, 2, 1, 0) --led array
  blueprintdefinitionservice:PlaceModule(script.cnumbers[2], 187, 2, 2, 0) --single cell battery
  blueprintdefinitionservice:AdvanceBlueprintPhase(script.cnumbers[2])
end


-----------------------------------------------------------------------------
--                              Milestone 08                               --
-----------------------------------------------------------------------------
script.initfunc[8] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  
  script.cnumbers = entities:GetOrAssignCustomValuesComponent(1).CustomNumbers
  local counter = utils.milestones.set_counter(company, goal, index, script.cnumbers[2])
end
-----------------------------------------------------------------------------
--                              Milestone 09                               --
-----------------------------------------------------------------------------
script.initfunc[9] = function(company)
  local ms = entities:GetMilestoneComponent(company)
  local index = ms.CurrentMilestoneIndex+1
  local goal = script.json.Data[index].Goal
  
  script.cnumbers = entities:GetOrAssignCustomValuesComponent(1).CustomNumbers
  local counter = utils.milestones.set_counter(company, goal, index, script.cnumbers[2])
end

return script