function myGameRender(dataFromVC) {
    // gameId=0 ->无游戏
    var tmplId = dataFromVC.gameId == 0 ? 0 : dataFromVC.templateId,
        gameBg = dataFromVC.gameBg;
    template = $('#myGame' + tmplId).html();
    if(dataFromVC.data){
      dataFromVC.hasNews = dataFromVC.data.news && dataFromVC.data.news.length > 0 
      dataFromVC.hasNotice = dataFromVC.data.notice && dataFromVC.data.notice.length > 0
      dataFromVC.hasActivity = dataFromVC.data.activity && dataFromVC.data.activity.length > 0
    }

    // 处理
    // 存在模板,目前只有一种模板，其他待完善
    if (template) {
        Mustache.parse(template);
        gameBg = gameBg ? gameBg.replace(/^https*/,'sbg') : 'sbg://';
        switch (tmplId) {
            case 1:
                var rendered = Mustache.render(template, dataFromVC)
                $('.my_game_offline').html(rendered)
                $('body').css('background-image','url(' + gameBg + ') ')
                break;
            default:
                var rendered = Mustache.render(template, dataFromVC)
                $('.my_game_offline').html(rendered)
                $('body').css('background-image','url(' + gameBg + ') ')
                break;
        }

    } else {
        $('.my_game_offline').html('数据出错，不存在模板文件')
    }

    //无游戏时，游戏库链接调用vc方法
    if(tmplId == 0){
        //创建webSocket
        var baseUrl = "ws://localhost:18979";
        var socket = new WebSocket(baseUrl);
    
        socket.onclose = function () {
            console.error("web channel closed");
        };
        socket.onerror = function (error) {
            console.error("web channel error: " + error);
        };
        socket.onopen = function () {
            new QWebChannel(socket, function (channel) {
                window.bridge = channel.objects.bridge;    
            });
        }
        $('.my_game_offline').on('click','.link_gamelib',function (e) {
            e.preventDefault();
            // console.log($(this).data('tab'))
            bridge.showTab($(this).data('tab'))
        })
    }
}
