const avatarLength = 23;
const prefixPhoto = './images/avatar/';
const photoName = 'user_default_photo';
var avatarHtml = '';
var selectedImg = null;

for (var i = 0; i < avatarLength; i++) {
	let name = photoName + i + '.png';
	avatarHtml += '<li data-src="' + name + '" ><img src="' + prefixPhoto + name + '" /></li>';
}

$('.avatar_list').html(avatarHtml).on('click', 'li', function() {
	$(this).addClass('selected').siblings().removeClass('selected');
	$('.avatar_preview .preview_img').css('background-image', 'url(' + $(this).find('img').attr('src') + ')');
	selectedImg = {
		isLocal: true,
		imgSrc: $(this).data('src')
	};
});

$('.avatar_list li').eq(0).click();

//创建webSocket
var baseUrl = 'ws://localhost:18979';
var socket = new WebSocket(baseUrl);

socket.onclose = function() {
	console.error('web channel closed');
};
socket.onerror = function(error) {
	console.error('web channel error: ' + error);
};
socket.onopen = function() {
	new QWebChannel(socket, function(channel) {
		window.bridge = channel.objects.bridge;
	});
};

$('.avatar_footer')
	.on('click', '.btn_save', function(e) {
    e.preventDefault();
		bridge.saveAvator(selectedImg.isLocal, selectedImg.imgSrc);
	})
	.on('click', '.btn_cancel', function(e) {
		e.preventDefault();
		bridge.cancelAvator();
	});
