local _, L = ...;
local VERSION = 11324;
function WorldBuffTracker_GetVersion()
  return VERSION;
end
local wbt_faction = "Alliance";
local wbtString = "[WorldBuffTracker] ";
local WorldBuffTrackerFrame = CreateFrame("Frame");
local addonInitialized = 99999999999999;
local WorldBuffTrackerEvents = {}
WorldBuffTracker = {
  ["GuildAnnounce"] = true,
  ["VersionControl"] = true,
  ["LastSync"] = 0,
  ["1"] = {
    ["Timestamp"] = 0,
    ["Yell"] = 0,
    ["Version"] = VERSION,
    ["Sender"] = UnitName("player"),
    ["Origin"] = UnitName("player"),
  },
  ["2"] = {
    ["Timestamp"] = 0,
    ["Yell"] = 0,
    ["Version"] = VERSION,
    ["Sender"] = UnitName("player"),
    ["Origin"] = UnitName("player"),
  },
  ["3"] = {
    ["Timestamp"] = 0,
    ["Yell"] = 0,
    ["Version"] = VERSION,
    ["Sender"] = UnitName("player"),
    ["Origin"] = UnitName("player"),
  },
}

WorldBuffTrackerZones = {
  ["Horde"] = {
    [1411] = true, [1454] = true, [1413] = true;
  },
  ["Alliance"] = {
      [1453] = true, [1429] = true;
    }
}

WorldBuffTrackerTTB = {
  ["1"] = 13, ["2"] = 17, ["3"] = 17,
}

WorldBuffTrackerBuffCDs = {
  ["1"] = 10800, ["2"] = 21600, ["3"] = 21600;
}

function WorldBuffTracker_Initialize()
  if(GetSpellBookItemName(1, "spell") ~= nil) then
    if(WorldBuffTrackerSpells[GetLocale()] ~= nil) then
      WorldBuffTrackerSpells = WorldBuffTrackerSpells[GetLocale()];
      WorldBuffTrackerNPCs = WorldBuffTrackerNPCs[GetLocale()];
    else
      WorldBuffTrackerSpells = WorldBuffTrackerSpells["enUS"];
      WorldBuffTrackerNPCs = WorldBuffTrackerNPCs["enUS"];
    end
    wbt_faction, _ = UnitFactionGroup("player");
    if(WorldBuffTracker["LastSync"] - GetServerTime() < -300) then
      C_ChatInfo.SendAddonMessage("WBT-0", VERSION, "GUILD");
      WorldBuffTracker["LastSync"] = GetServerTime();
    end
    addonInitialized = GetTime() + 0.5;
    WorldBuffTrackerFrame:SetScript("OnUpdate", WorldBuffTracker_DelayTracking);
    WorldBuffTracker_VerifyTable();
    WorldBuffTracker_TimeTableTest();
  end
end

function WorldBuffTracker_DelayTracking()
  if(addonInitialized - GetTime() < 0) then
    addonInitialized = 99999999999999;
    WorldBuffTrackerFrame:SetScript("OnUpdate", nil);
    for k, v in pairs(WorldBuffTrackerEvents) do
      WorldBuffTrackerFrame:RegisterEvent(k);
    end
    WorldBuffTrackerFrame:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
    WorldBuffTrackerFrame:UnregisterEvent("CHAT_MSG_MONSTER_YELL");
    WorldBuffTrackerEvents:ZONE_CHANGED_NEW_AREA();
  end
end

function WorldBuffTrackerEvents:COMBAT_LOG_EVENT_UNFILTERED(...)
  local _, eventType, _,
      _, sourceName, _, _,
      destGUID, destName, _, _,
      spellId, spellName, _, auraType, _ = CombatLogGetCurrentEventInfo();
    if((eventType == "SPELL_AURA_APPLIED" or eventType == "SPELL_AURA_REFRESHED")
      and destName == UnitName("player") and auraType == "BUFF" and WorldBuffTrackerSpells[spellName] ~= nil) then
        --TODO: if rallying cry send only send data if last yell [2 or 3] is greater than t-60
        if(WorldBuffTracker_BuffIsValid(spellName, WorldBuffTrackerSpells[spellName])) then
          if(IsInGuild()) then
            C_ChatInfo.SendAddonMessage("WBT-" .. WorldBuffTrackerSpells[spellName], VERSION, "GUILD");
          else
            WorldBuffTracker_HandleBuffById(WorldBuffTrackerSpells[spellName]);
          end
        end
    end
end

function WorldBuffTrackerEvents:ZONE_CHANGED_NEW_AREA(...)
  if(WorldBuffTrackerZones[wbt_faction][C_Map.GetBestMapForUnit("player")] ~= nil) then
    WorldBuffTrackerFrame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
    WorldBuffTrackerFrame:RegisterEvent("CHAT_MSG_MONSTER_YELL");
  else
    WorldBuffTrackerFrame:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
    WorldBuffTrackerFrame:UnregisterEvent("CHAT_MSG_MONSTER_YELL");
  end
end

function WorldBuffTrackerEvents:CHAT_MSG_MONSTER_YELL(msg, npc, ...)
  if(WorldBuffTrackerNPCs[wbt_faction][npc] ~= nil and WorldBuffTracker["GuildAnnounce"]) then
    npc = WorldBuffTrackerNPCs[wbt_faction][npc]
    WorldBuffTracker_TimeTableTest();
  else
    return;
  end
  for k,v in pairs(WorldBuffTrackerSpells) do
    if(v == npc) then
      npc = tostring(npc);
      if(WorldBuffTracker[npc]["Timestamp"] == 0) then
        local t = GetServerTime();
        if(WorldBuffTracker[npc]["Yell"] < t) then
          SendChatMessage(wbtString .. string.format("Possible %s buff incoming.", k), "GUILD");
          WorldBuffTracker[npc]["Yell"] = t + 40;
        end
      end
    end
  end
end

function WorldBuffTrackerEvents:CHAT_MSG_ADDON(prefix, message, channel, sender, ...)
  local sender, _ = strsplit("-", sender);
  local t = GetServerTime();
  if(prefix == "WBT-1") then
    WorldBuffTracker_HandleWarchief(sender, WorldBuffTracker_GetVersionFromString(message), t);
  elseif(prefix == "WBT-2") then
    WorldBuffTracker_HandleOnyxia(sender, WorldBuffTracker_GetVersionFromString(message), t);
  elseif(prefix == "WBT-3") then
    if(channel == "GUILD" and sender ~= UnitName("player")) then
      if(message == "-") then
        WorldBuffTracker_SendSyncData(sender, true);
      else
        WorldBuffTracker_HandleNefarian(sender, WorldBuffTracker_GetVersionFromString(message), t)
      end
    end
  elseif(prefix == "WBT-0") then
    if(channel == "GUILD" and sender ~= UnitName("player")) then
      WorldBuffTracker_GetVersionFromString(message);
      WorldBuffTracker_SendSyncData(sender, false);
    elseif(channel == "WHISPER") then
      WorldBuffTracker_HandleSync(message, sender);
    end
  end
end

local function WorldBuffTrackerFrame_Command(msg, editbox)
  if(strlower(msg) == "announce") then
    if(WorldBuffTracker["GuildAnnounce"]) then
      print(wbtString .. L["Guild announce: disabled."])
    else
      print(wbtString .. L["Guild announce: enabled."])
    end
    WorldBuffTracker["GuildAnnounce"] = not WorldBuffTracker["GuildAnnounce"];
    return;
  elseif(strlower(msg) == "version") then
    if(WorldBuffTracker["VersionControl"]) then
      print(wbtString .. L["Version announce: disabled."])
    else
      print(wbtString .. L["Version announce: enabled."])
    end
    WorldBuffTracker["VersionControl"] = not WorldBuffTracker["VersionControl"];
    return;
  end
  WorldBuffTracker_TimeTableTest();
  local t = GetServerTime();
  print("--- WorldBuffTracker ---")
  for k, v in pairs(WorldBuffTrackerSpells) do
    local buffSource = "";
    if(v == 2) then
      buffSource = " (" .. L["Onyxia"] .. ")";
    elseif(v == 3) then
      buffSource = " (" .. L["Nefarian"] .. ")";
    end
    print(k .. ":" .. buffSource);
    v = tostring(v);
    local bT = WorldBuffTracker[v]["Timestamp"];
      if(bT > 0) then
        local cd = WorldBuffTrackerBuffCDs[v];
        local sources = " ";
        if(WorldBuffTracker[v]["Origin"] ~= WorldBuffTracker[v]["Sender"]) then
          sources = sources .. "(" .. WorldBuffTracker[v]["Origin"] .. "→" .. WorldBuffTracker[v]["Sender"] .. ")";
        else
          sources = sources .. "(" .. WorldBuffTracker[v]["Sender"] .. ")";
        end
        print("    " .. string.format(L["Popped: %s Next: %s in: %s"], date('%H:%M:%S', bT), date('%H:%M:%S', bT + cd), WorldBuffTracker_TimeUntilDate(bT - t + cd))
          .. sources);
      else
        print("    " .. L["No data."]);
      end
    end
  print("------------------------")
end

function WorldBuffTracker_TimeUntilDate(seconds)
  local str = "";
  if(seconds > 3600) then
    local hours = math.floor(seconds / 3600);
    str = hours .. "h ";
    seconds = seconds - 3600 * hours;
  end
  if(seconds > 60) then
    local minutes = math.floor(seconds / 60);
    str = str .. minutes .. "m ";
    seconds = seconds - 60 * minutes;
  end
  if(seconds > 0) then
    str = str .. seconds .. "s";
  end
  return str;
end

SLASH_WORLDBUFFS1, SLASH_WORLDBUFFS2, SLASH_WORLDBUFFS3 = '/worldbuffs', '/worldbufftracker', '/wbt'

SlashCmdList["WORLDBUFFS"] = WorldBuffTrackerFrame_Command;

WorldBuffTrackerFrame:SetScript("OnUpdate", WorldBuffTracker_Initialize);
WorldBuffTrackerFrame:SetScript("OnEvent", function(self, event, ...)
  WorldBuffTrackerEvents[event](self, ...);
end);
C_ChatInfo.RegisterAddonMessagePrefix("WBT-0");
C_ChatInfo.RegisterAddonMessagePrefix("WBT-1");
C_ChatInfo.RegisterAddonMessagePrefix("WBT-2");
C_ChatInfo.RegisterAddonMessagePrefix("WBT-3");
