local HasVersionControlled = false;
local _, L = ...;

function WorldBuffTracker_VerifyTable()
  if(type(WorldBuffTracker["GuildAnnounce"]) ~= "boolean") then
    WorldBuffTracker["GuildAnnounce"] = true;
  end
  if(type(WorldBuffTracker["VersionControl"]) ~= "boolean") then
    WorldBuffTracker["VersionControl"] = true;
  end
  local buffEntryType = type(WorldBuffTracker["1"])
  local buffEntryTimestamp = 0;
  if(buffEntryType ~= "table") then
    if(buffEntryType == "number") then
      buffEntryTimestamp = WorldBuffTracker["1"];
    end
    if(buffEntryTimestamp == nil) then
      buffEntryTimestamp = 0;
    end
    WorldBuffTracker["1"] = {
      ["Timestamp"] = buffEntryTimestamp,
      ["Yell"] = 0,
      ["Version"] = WorldBuffTracker_GetVersion(),
      ["Sender"] = UnitName("player"),
      ["Origin"] = UnitName("player"),
    }
    buffEntryTimestamp = 0;
  end
  buffEntryType = type(WorldBuffTracker["2"])
  if(buffEntryType ~= "table") then
    if(buffEntryType == "number") then
      buffEntryTimestamp = WorldBuffTracker["2"];
    end
    if(buffEntryTimestamp == nil) then
      buffEntryTimestamp = 0;
    end
    WorldBuffTracker["2"] = {
      ["Timestamp"] = buffEntryTimestamp,
      ["Yell"] = 0,
      ["Version"] = WorldBuffTracker_GetVersion(),
      ["Sender"] = UnitName("player"),
      ["Origin"] = UnitName("player"),
    }
    buffEntryTimestamp = 0;
  end
  buffEntryType = type(WorldBuffTracker["3"])
  if(buffEntryType ~= "table") then
    if(buffEntryType == "number") then
      buffEntryTimestamp = WorldBuffTracker["3"];
    end
    if(buffEntryTimestamp == nil) then
      buffEntryTimestamp = 0;
    end
    WorldBuffTracker["3"] = {
      ["Timestamp"] = buffEntryTimestamp,
      ["Yell"] = 0,
      ["Version"] = WorldBuffTracker_GetVersion(),
      ["Sender"] = UnitName("player"),
      ["Origin"] = UnitName("player"),
    }
    buffEntryTimestamp = 0;
  end
end

function WorldBuffTracker_DistinctTimestamp(list, timestamp)
  if(type(WorldBuffTracker[list]) == "table" and tonumber(list) ~= nil) then
    if(abs(timestamp-WorldBuffTracker[list]["Timestamp"]) < 30) then
      return false;
    end
    return true;
  end
  return false;
end

function WorldBuffTracker_TimeTableTest()
  local t = GetServerTime();
  WorldBuffTracker_TimeTableResetByBuff("1", t, 10800);
  WorldBuffTracker_TimeTableResetByBuff("2", t, 21600);
  WorldBuffTracker_TimeTableResetByBuff("3", t, 21600);
end

function WorldBuffTracker_TimeTableResetByBuff(buff, t, cd)
  local dt = WorldBuffTracker[buff]["Timestamp"];
  if(dt ~= 0) then
    WorldBuffTracker[buff]["Yell"] = 0;
  end
  if(t-dt > cd) then
    WorldBuffTracker[buff]["Timestamp"] = 0;
  end
end

function WorldBuffTracker_HandleSync(message, sender)
  local buffType, time, origin, version, _ = strsplit("_", message);
  version = WorldBuffTracker_GetVersionFromString(version);
  if(version < 11324) then
    return
  end
  time = tonumber(time);
  if(WorldBuffTracker[buffType] == nil) then
    return
  elseif(time == nil or time > GetServerTime()
    or (WorldBuffTracker[buffType]["Timestamp"] > 0 and WorldBuffTracker[buffType]["Sender"] == UnitName("player"))
    or (WorldBuffTracker[buffType]["Timestamp"] > 0 and
    version < WorldBuffTracker[buffType]["Version"])) then
    return
  end
  if(WorldBuffTracker_DistinctTimestamp(buffType, time)) then
    if(WorldBuffTracker[buffType]["Version"] < version or WorldBuffTracker[buffType]["Timestamp"] == 0) then
      WorldBuffTracker[buffType]["Timestamp"] = time;
      WorldBuffTracker[buffType]["Sender"] = sender;
      WorldBuffTracker[buffType]["Origin"] = origin;
      WorldBuffTracker[buffType]["Version"] = version;
    end
  end
end

function WorldBuffTracker_SendSyncData(target, outdated)
  WorldBuffTracker_TimeTableTest();
  local t1 = WorldBuffTracker["1"]["Timestamp"];
  local t2 = WorldBuffTracker["2"]["Timestamp"];
  local t3 = WorldBuffTracker["3"]["Timestamp"];
  if(outdated) then
    if(t1 > 0) then
      C_ChatInfo.SendAddonMessage("WBT-3", WorldBuffTracker_BuildAddonMessage("1", outdated), "WHISPER", target);
    end
    if(t2 > 0) then
      C_ChatInfo.SendAddonMessage("WBT-3", WorldBuffTracker_BuildAddonMessage("1", outdated), "WHISPER", target);
    end
  else
    if(t1 > 0) then
      C_ChatInfo.SendAddonMessage("WBT-0", WorldBuffTracker_BuildAddonMessage("1", outdated), "WHISPER", target);
    end
    if(t2 > 0) then
      C_ChatInfo.SendAddonMessage("WBT-0", WorldBuffTracker_BuildAddonMessage("2", outdated), "WHISPER", target);
    end
    if(t3 > 0) then
      C_ChatInfo.SendAddonMessage("WBT-0", WorldBuffTracker_BuildAddonMessage("3", outdated), "WHISPER", target);
    end
  end
end

function WorldBuffTracker_BuildAddonMessage(buffType, outdated)
  if(outdated) then
    return buffType .. "_" .. WorldBuffTracker[buffType]["Timestamp"];
  else
    return buffType .. "_" .. WorldBuffTracker[buffType]["Timestamp"]
      .. "_" .. WorldBuffTracker[buffType]["Origin"] .. "_" .. WorldBuffTracker_GetVersion();
  end
end

function WorldBuffTracker_HandleWarchief(sender, version, time)
  WorldBuffTracker_HandleBuffByType("1", 10800, sender, version, time);
end

function WorldBuffTracker_HandleOnyxia(sender, version, time)
  WorldBuffTracker_HandleBuffByType("2", 21600, sender, version, time);
end

function WorldBuffTracker_HandleNefarian(sender, version, time)
  WorldBuffTracker_HandleBuffByType("3", 21600, sender, version, time);
end

function WorldBuffTracker_HandleBuffById(id)
  if(id == "1") then
    WorldBuffTracker_HandleWarchief(UnitName("player"), WorldBuffTracker_GetVersion(), GetServerTime());
  elseif(id == "2") then
    WorldBuffTracker_HandleOnyxia(UnitName("player"), WorldBuffTracker_GetVersion(), GetServerTime());
  elseif(id == "3") then
    WorldBuffTracker_HandleNefarian(UnitName("player"), WorldBuffTracker_GetVersion(), GetServerTime());
  end
end

function WorldBuffTracker_HandleBuffByType(type, cooldown, sender, version, time)
  if(version < 11324) then
    return
  end
  if(WorldBuffTracker[type]["Timestamp"] + cooldown < time) then
    WorldBuffTracker[type]["Timestamp"] = time;
    WorldBuffTracker[type]["Version"] = version;
    WorldBuffTracker[type]["Sender"] = sender;
    WorldBuffTracker[type]["Origin"] = sender;
  elseif(WorldBuffTracker[type]["Version"] < version) then
    WorldBuffTracker[type]["Timestamp"] = time;
    WorldBuffTracker[type]["Version"] = version;
    WorldBuffTracker[type]["Sender"] = sender;
    WorldBuffTracker[type]["Origin"] = sender;
  end
end

function WorldBuffTracker_GetVersionFromString(str)
  local v = tonumber(str) ~= nil and tonumber(str) or 11321;
  if(not HasVersionControlled and v > WorldBuffTracker_GetVersion()) then
    HasVersionControlled = true;
    if(WorldBuffTracker["VersionControl"]) then
      print("[WorldBuffTracker] " .. L["New update may be available."]);
    end
  end
  return v;
end

function WorldBuffTracker_BuffIsValid(spell, type)
  for i=1,32 do
    local b,_,_,_,e,f,_ = UnitBuff("player", i);
    if(b == nil) then
      return false;
    end
    if(spell == b and type == 1 and f-GetTime() > 3598) then
      return true;
    elseif(spell == b and f-GetTime() > 7198) then
      return true;
    end
  end
  return false;
end
