----------------------------------------------------------------------
-- 	Leatrix Maps Locale
----------------------------------------------------------------------

-- Create locale structure
local GameLocale = GetLocale()
local void, Leatrix_Maps = ...
local function localeFunc(L, key) return key end
local L = setmetatable({}, {__index = localeFunc})
Leatrix_Maps.L = L

-- Locale override (enUS, zhCN, zhTW, ruRU, koKR, deDE, esMX, frFR, itIT, ptBR)
-- GameLocale = "enUS"

-- zhCN: Simplified Chinese (People's Republic of China)
if GameLocale == "zhCN" then
L["/ltm help - Show this information."] = "/ltm help - 显示帮助信息"
L["/ltm reset - Reset the panel position."] = "/ltm reset - 重置面板位置"
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 清空所有设置并重载插件"
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "出现了一个无关痛痒的报错，它并不会影响到你的体验，你可以点击重载按钮来解决这个问题。"
L["Aerie Peak"] = "鹰巢山"
L["Alpha"] = "透明"
L["Alterac Mountains"] = "奥特兰克山脉"
L["Arathi Highlands"] = "阿拉希高地"
L["Ashenvale"] = "灰谷"
L["Astranaar"] = "阿斯特兰纳"
L["Astravar Harbor"] = "阿斯塔瓦港"
L["Auberdine"] = "奥伯丁"
L["Auchenai Crypts"] = "奥金尼地穴"
L["Auchindoun"] = "奥金顿"
L["Azjol-Nerub"] = "艾卓-尼鲁布"
L["Azshara"] = "艾萨拉"
L["Back to Main Menu"] = "返回主菜单"
L["Badlands"] = "荒芜之地"
L["Baradin Hold"] = "巴拉丁监狱"
L["Black Morass"] = "幽暗沼泽"
L["Black Temple"] = "黑暗神殿"
L["Blackfathom Deeps"] = "黑暗深渊"
L["Blackrock Caverns"] = "黑石岩窟"
L["Blackrock Depths"] = "黑石深渊"
L["Blackrock Foundry"] = "黑石铸造厂"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Descent"] = "黑翼血环"
L["Blackwing Lair"] = "黑翼之巢"
L["Blasted Lands"] = "诅咒之地"
L["Bloodmaul Slag Mines"] = "血槌炉渣矿井"
L["Bloodvenom Post"] = "血毒岗哨"
L["Blue"] = "蓝色"
L["Boat to"] = "乘船前往"
L["Booty Bay"] = "藏宝海湾"
L["Brackenwall Village"] = "蕨墙村"
L["Burning Steppes"] = "燃烧平原"
L["Camp Mojache"] = "莫沙彻营地"
L["Camp Taurajo"] = "陶拉祖营地"
L["Caverns of Time"] = "时光之穴"
L["Cenarion Hold"] = "塞纳里奥要塞"
L["Central Mesa"] = "中部高台"
L["Chillwind Camp"] = "冰风岗"
L["Class colored icons"] = "职业颜色图标"
L["Class Colored Icons"] = "职业染色图标"
L["Classic"] = "经典旧世"
L["Click to configure the settings for this option."] = "点击可调整此选项的更多设置。"
L["Click to reset the position and scale of the map frame."] = "点击重置地图的尺寸和位置。"
L["Click to reset the settings on this page."] = "点击重置本页的设置。"
L["Click to return to the main menu."] = "点击返回主菜单。"
L["Coilfang Reservoir"] = "盘牙水库"
L["Configuration Panel"] = "设置面板"
L["Culling of Stratholme"] = "净化斯坦索姆"
L["Cursor"] = "光标"
L["Darkshire"] = "夜色镇"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "达纳苏斯"
L["Deadwind Pass"] = "逆风小径"
L["Desolace"] = "凄凉之地"
L["Dire Maul"] = "厄运之槌"
L["Dire Maul (East)"] = "厄运之槌（东）"
L["Dire Maul (North)"] = "厄运之槌（北）"
L["Dire Maul (West)"] = "厄运之槌（西）"
L["Dire Maul: Capital Gardens"] = "厄运之槌：中心花园"
L["Dire Maul: Gordok Commons"] = "厄运之槌：戈多克议会"
L["Dire Maul: Warpwood Quarter"] = "厄运之槌：扭木广场"
L["Disable reading emote when opening the map"] = "禁用阅读地图时的表情动作"
L["Drag"] = "拖拽"
L["Drag to set the amount of blue."] = "拖拽调整蓝色数值。"
L["Drag to set the amount of green."] = "拖拽调整绿色数值。"
L["Drag to set the amount of red."] = "拖拽调整红色数值。"
L["Drag to set the group icon size."] = "拖动以调整队友图标大小。"
L["Drag to set the map opacity for when your character is moving."] = "拖拽调整当你移动时，地图淡化的透明度。"
L["Drag to set the map opacity for when your character is stationary."] = "拖拽调整当你站定时，地图的透明度。"
L["Drag to set the opacity."] = "拖拽调整透明度。"
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "拖动以调整玩家箭头大小。|n|n怀旧服版本游戏默认尺寸是16。|n正式服版本游戏默认为27。"
L["Dragon Soul"] = "巨龙之魂"
L["Drak'Tharon Keep"] = "达克萨隆要塞"
L["Druid only flight point to Darnassus"] = "至达纳苏斯（德鲁伊专属）"
L["Druid only flight point to Thunder Bluff"] = "至雷霆崖（德鲁伊专属）"
L["Dun Morogh"] = "丹莫罗"
L["Dungeon"] = "地下城"
L["Durotar"] = "杜隆塔尔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "尘泥沼泽"
L["Dwarven District"] = "矮人区"
L["Eastern Plaguelands"] = "东瘟疫之地"
L["Elements"] = "其他功能"
L["Elwynn Forest"] = "艾尔文森林"
L["End Time"] = "时光之末"
L["Enlarge player arrow"] = "放大玩家指针"
L["Enlarge Player Arrow"] = "放大玩家箭头"
L["Enter"] = "输入"
L["Eternal Guardian"] = "永恒守护者"
L["Everlook"] = "永望镇"
L["Evermoon Terrace"] = "永月平台"
L["Eye of Azshara"] = "艾萨拉之眼"
L["Falanaar"] = "法兰纳尔"
L["Feathermoon Stronghold"] = "羽月要塞"
L["Felsoul Hold"] = "邪魂堡垒"
L["Felwood"] = "费伍德森林"
L["Feralas"] = "菲拉斯"
L["Firelands"] = "火焰之地"
L["Fishing"] = "钓鱼"
L["Flame Crest"] = "烈焰峰"
L["Freewind Post"] = "乱风岗"
L["Gadgetzan"] = "加基森"
L["Gate of the Setting Sun"] = "残阳关"
L["Gnomeregan"] = "诺莫瑞根"
L["Green"] = "绿色"
L["Grim Batol"] = "格瑞姆巴托"
L["Grimrail Depot"] = "恐轨车站"
L["Grom'gol Base Camp"] = "格罗姆高营地"
L["Group Icons"] = "队友图标调整"
L["Gruul's Lair"] = "格鲁尔的巢穴"
L["Gundrak"] = "古达克"
L["Gundrak (rear entrance)"] = "古达克（后门）"
L["Halls of Lightning"] = "闪电大厅"
L["Halls of Origination"] = "起源大厅"
L["Halls of Stone"] = "岩石大厅"
L["Halls of Valor"] = "勇气大厅"
L["Hammerfall"] = "落锤镇"
L["Heart of Fear"] = "恐惧之心"
L["Hellfire Citadel"] = "地狱火堡垒"
L["Hellfire Ramparts"] = "地狱火城墙"
L["Hide town and city icons"] = "隐藏城镇图标"
L["Highmaul"] = "悬槌堡"
L["Hillsbrad Foothills"] = "希尔斯布莱德丘陵"
L["Hour of Twilight"] = "暮光之刻"
L["Hyjal Summit"] = "海加尔山"
L["Icecrown"] = "冰冠冰川"
L["Icecrown Citadel"] = "冰冠堡垒"
L["Icons"] = "图标"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "勾选后，会在地图上标记显示船舶港口，飞艇塔楼和地铁站。"
L["If checked, coordinates will be shown."] = "勾选后，会在地图上显示坐标。"
L["If checked, dungeons and raids will be shown."] = "勾选后，会在地图上标记显示地下城和团队副本入口。"
L["If checked, flight points will be shown."] = "勾选后，会在地图上标记显示飞行点。"
L["If checked, group icons will use a modern, class-colored design."] = "勾选后，地图上的队友图标会修改成职业颜色。"
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "勾选后，当你所处区域未发生变化时，打开地图会自动跳转最后一次的区域。"
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "勾选后，当你在移动中指向地图时，会停止地图的渐隐，并使用设置的站定透明度。"
L["If checked, points of interest will be shown."] = "勾选后，显示地图的标记点。"
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will prevent you from unlocking the map or removing the map border."] = "勾选后，会启用默认的全屏地图。|n|n注意，启用这个选项会阻止你解锁地图或移除地图边框。"
L["If checked, the map border will be removed."] = "勾选后，移除地图的黑色边框。"
L["If checked, the minimap button will be shown."] = "勾选后，会启用小地图图标。"
L["If checked, the minimum fishing skill levels will be shown."] = "勾选后，会显示所需要的最低钓鱼等级。"
L["If checked, town and city icons will not be shown on the continent maps."] = "勾选后，将隐藏大陆地图上的城镇图标。"
L["If checked, unexplored areas of the map will be shown."] = "勾选后，显示未探索区域。"
L["If checked, unexplored areas will be tinted."] = "勾选后，对未探索区域进行染色。"
L["If checked, you will be able to enlarge the player arrow."] = "勾选后，你可以增大玩家的箭头大小。"
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges.  If you have removed the map border, a drag button will be shown in the top-left corner."] = "勾选后，你可以移动并缩放地图。|n|n缩放地图是通过右下角的角标操作。|n|n移动地图可以通过拖拽边框。如果你移除了边框，在地图左上角会有一个拖拽按钮可供操作。"
L["If checked, you will be able to set the opacity of the map."] = "勾选后，你可以设置地图的透明度。"
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "勾选后，会在地图上显示区域、副本和钓鱼的相关等级。"
L["Invalid command.  Enter /ltm help for help."] = "无效的命令。输入/ltm help来获取帮助信息。"
L["Iron Docks"] = "钢铁码头"
L["Ironforge"] = "铁炉堡"
L["Karazhan"] = "卡拉赞"
L["Kargath"] = "卡加斯"
L["Lake Elune'ara"] = "月神湖"
L["Lake Everstill"] = "湖畔镇"
L["Large Scarab Coffer"] = "大型圣甲虫箱"
L["Light's Hope Chapel"] = "圣光之愿礼拜堂"
L["Lion's Watch"] = "雄狮岗哨"
L["Loch Modan"] = "洛克莫丹"
L["Lost City of the Tol'vir"] = "托维尔失落之城"
L["Lower Blackrock Spire"] = "黑石塔下层"
L["Lower Wilds"] = "低地荒野"
L["Lunastre Estate"] = "月郡庄园"
L["Magisters' Terrace"] = "魔导师平台"
L["Magtheridon's Lair"] = "玛瑟里顿的巢穴"
L["Mana-Tombs"] = "法力陵墓"
L["Map frame scale"] = "地图面板缩放"
L["Maraudon"] = "玛拉顿"
L["Maraudon: Earth Song Falls"] = "玛拉顿：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "玛拉顿：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "玛拉顿：邪恶洞穴"
L["Marshal's Refuge"] = "马绍尔营地"
L["Mechanics"] = "地图结构"
L["Memory Usage"] = "内存占用"
L["Menethil Harbor"] = "米奈希尔港"
L["Miscellaneous"] = "杂项"
L["Mogu'shan Palace"] = "魔古山宫殿"
L["Mogu'shan Vaults"] = "魔古山宝库"
L["Molten Core"] = "熔火之心"
L["Moon Guard Stronghold"] = "护月堡垒"
L["Moonglade"] = "月光林地"
L["Morgan's Vigil"] = "摩根的岗哨"
L["Mount Hyjal"] = "海加尔山"
L["Moving"] = "移动"
L["Mulgore"] = "莫高雷"
L["Naxxramas"] = "纳克萨玛斯"
L["Nethergarde Keep"] = "守望堡"
L["Nighthaven"] = "永夜港"
L["Nijel's Point"] = "尼耶尔前哨站"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "注意！|n你必须重新启动你的游戏客户端才能正确加载新版本的Leatrix Maps。"
L["Old Hillsbrad Foothills"] = "旧希尔斯布莱德丘陵"
L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
L["Opacity"] = "透明度"
L["or click the minimap button to open Leatrix Maps."] = "或者点击小地图按钮打开LeatrixMaps。"
L["Orgrimmar"] = "奥格瑞玛"
L["Player"] = "玩家"
L["Player Arrow"] = "玩家箭头"
L["Portal"] = "传送门"
L["Portal from Zephyr"] = "塞菲尔的传送门"
L["Preview"] = "预览"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "团队副本"
L["Ratchet"] = "棘齿城"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼泽"
L["Red"] = "红色"
L["Redridge Mountains"] = "赤脊山"
L["Refuge Pointe"] = "避难谷地"
L["Reload"] = "重载插件"
L["Remember zoom level"] = "保存缩放等级"
L["Remove map border"] = "移除地图边框"
L["Requires UI reload."] = "需要重载插件。"
L["Reset"] = "重置"
L["Reset Map Layout"] = "重置地图设置"
L["Return to Karazhan"] = "重返卡拉赞"
L["Revantusk Village"] = "恶齿村"
L["Ruins of Ahn'Qiraj"] = "安其拉废墟"
L["Ruins of Elune'eth"] = "艾露尼斯废墟"
L["Rut'theran Village"] = "鲁瑟兰村"
L["Sanctum of Order"] = "秩序大殿"
L["Scale"] = "缩放"
L["Scarlet Halls"] = "血色大厅"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通灵学院"
L["Searing Gorge"] = "灼热峡谷"
L["Sentinel Hill"] = "哨兵岭"
L["Serpentshrine Cavern"] = "毒蛇神殿"
L["Set map opacity"] = "设置地图透明度"
L["Set Map Opacity"] = "地图透明度"
L["Set map opacity while stationary and while moving."] = "设置当站定和移动时的地图透明度。"
L["Set the group icon size."] = "设置队友图标尺寸。"
L["Set the player arrow size."] = "设置玩家箭头大小。"
L["Sethekk Halls"] = "塞泰克大厅"
L["Settings"] = "设置"
L["Shado-Pan Monastery"] = "影踪修道院"
L["Shadow Labyrinth"] = "暗影迷宫"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shadowprey Village"] = "葬影村"
L["Shal'Aran"] = "沙尔艾兰"
L["Show boats, zeppelins and trams"] = "显示港口/飞艇/地铁站"
L["Show coordinates"] = "显示坐标"
L["Show dungeons and raids"] = "标记副本入口"
L["Show flight points"] = "显示飞行点"
L["Show minimap button"] = "显示小地图按钮"
L["Show minimap travel"] = "标记小地图旅行点"
L["Show minimum fishing skill levels"] = "显示最低钓鱼等级"
L["Show points of interest"] = "启用地图的标记点"
L["Show Points Of Interest"] = "显示标记点"
L["Show scale handle"] = "允许缩放地图框体"
L["Show travel points"] = "显示旅行点"
L["Show unexplored areas"] = "显示未探索区域"
L["Show Unexplored Areas"] = "显示未探索区域"
L["Show zone levels"] = "显示区域等级"
L["Show Zone Levels"] = "显示区域等级"
L["Siege of Niuzao Temple"] = "围攻砮皂寺"
L["Siege of Orgrimmar"] = "决战奥格瑞玛"
L["Silithus"] = "希利苏斯"
L["Silverpine Forest"] = "银松森林"
L["Skyreach"] = "通天峰"
L["Slave Pens"] = "奴隶围栏"
L["Southshore"] = "南海镇"
L["Splintertree Post"] = "碎木岗哨"
L["Stationary"] = "站定"
L["Steamvault"] = "蒸汽地窟"
L["Stonard"] = "斯通纳德"
L["Stonetalon Mountains"] = "石爪山脉"
L["Stonetalon Peak"] = "石爪峰"
L["Stormstout Brewery"] = "风暴酿酒厂"
L["Stormwind"] = "暴风城"
L["Stranglethorn Vale"] = "荆棘谷"
L["Stratholme (Main Gate)"] = "斯塔索姆（前门）"
L["Stratholme (Service Gate)"] = "斯塔索姆（侧门）"
L["Sun Rock Retreat"] = "烈日石居"
L["Sunwell Plateau"] = "太阳之井高地"
L["Swamp of Sorrows"] = "悲伤沼泽"
L["Talonbranch Glade"] = "魔爪村"
L["Talrendis Point"] = "塔伦迪斯营地"
L["Tanaris"] = "塔纳利斯"
L["Tarren Mill"] = "塔伦米尔"
L["Tel'anor"] = "泰安诺"
L["Teldrassil"] = "泰达希尔"
L["Tempest Keep"] = "风暴要塞"
L["Temple of Ahn'Qiraj"] = "安其拉神殿"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神庙"
L["Temple of the Jade Serpent"] = "青龙寺"
L["Terrace of Endless Spring"] = "永春台"
L["The Arcatraz"] = "禁魔监狱"
L["The Barrens"] = "贫瘠之地"
L["The Bastion of Twilight"] = "暮光堡垒"
L["The Black Morass"] = "黑色沼泽"
L["The Blood Furnace"] = "鲜血熔炉"
L["The Botanica"] = "生态船"
L["The Crossroads"] = "十字路口"
L["The Culling of Stratholme"] = "净化斯坦索姆"
L["The Deadmines"] = "死亡矿井"
L["The Dragon Soul"] = "巨龙之魂"
L["The Everbloom"] = "永茂林地"
L["The Eye"] = "风暴要塞"
L["The Eye of Eternity"] = "永恒之眼"
L["The Forge of Souls"] = "灵魂洪炉"
L["The Forgotten Coast"] = "被遗忘的海岸"
L["The Frozen Halls"] = "冰封大殿"
L["The Great Forge"] = "大锻炉"
L["The Halls of Reflection"] = "倒映大厅"
L["The Hinterlands"] = "辛特兰"
L["The Mechanar"] = "能源舰"
L["The Nexus"] = "魔枢"
L["The Obsidian Sanctum"] = "黑曜石圣殿"
L["The Oculus"] = "魔环"
L["The Old Kingdom"] = "古代王国"
L["The Pit of Saron"] = "萨隆矿坑"
L["The Ruby Sanctum"] = "红玉圣殿"
L["The Sepulcher"] = "瑟伯切尔"
L["The Shattered Halls"] = "破碎大厅"
L["The Stockade"] = "监狱"
L["The Stonecore"] = "巨石之核"
L["The Violet Hold"] = "紫罗兰监狱"
L["The Vortex Pinnacle"] = "旋云之巅"
L["The Waning Crescent"] = "残月酒馆"
L["Thelsamar"] = "塞尔萨玛"
L["Theramore Isle"] = "塞拉摩岛"
L["Thorium Point"] = "瑟银哨塔"
L["Thousand Needles"] = "千针石林"
L["Throne of the Four Winds"] = "风神王座"
L["Throne of the Tides"] = "海潮王座"
L["Throne of Thunder"] = "雷电王座"
L["Thunder Bluff"] = "雷霆崖"
L["Tinker Town"] = "丁克镇"
L["Tint unexplored areas"] = "未探索区域染色"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["Tomb of Sargeras"] = "萨格拉斯之墓"
L["Trade District"] = "贸易区"
L["Trade Quarter"] = "贸易区"
L["Tram to"] = "乘地铁前往"
L["Transparency"] = "透明度"
L["Trial of the Champion"] = "冠军的试炼"
L["Trial of the Crusader"] = "十字军的试炼"
L["Twilight Vineyards"] = "暮光酒庄"
L["Uldaman"] = "奥达曼"
L["Ulduar"] = "奥杜尔"
L["Underbog"] = "幽暗沼泽"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈洛环形山"
L["Unlock map frame"] = "解锁地图框体"
L["Upper Blackrock Spire"] = "黑石塔上层"
L["Use default map"] = "使用默认地图"
L["Use stationary opacity while pointing at map"] = "指向地图时取消渐隐"
L["Utgarde Keep"] = "乌特加德城堡"
L["Utgarde Pinnacle"] = "乌特加德之巅"
L["Valley of Strength"] = "力量谷"
L["Valormok"] = "瓦罗莫克"
L["Vault of Archavon"] = "阿尔卡冯的宝库"
L["Version"] = "版本"
L["Vol'mar"] = "沃玛尔"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Well of Eternity"] = "永恒之井"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "湿地"
L["Winterspring"] = "冬泉谷"
L["Wyrmrest Temple"] = "龙眠神殿"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "为了让部分功能生效，你的插件需要重新载入。|n|n你无需立即点击重载插件按钮。可以根据自己的情况或者设置完毕后，再进行重载插件的操作。"
L["Your UI needs to be reloaded."] = "插件需要重新载入。"
L["Zeppelin to"] = "乘飞艇前往"
L["Zoram'gar Outpost"] = "佐拉姆加前哨站"
L["Zul'Aman"] = "祖阿曼"
L["Zul'Farrak"] = "祖尔法拉克"
L["Zul'Gurub"] = "祖尔格拉布"

end

-- zhTW: Traditional Chinese (Taiwan)
if GameLocale == "zhTW" then
L["/ltm help - Show this information."] = "/ltm help - 顯示插件資訊。"
L["/ltm reset - Reset the panel position."] = "/ltm reset - 重設面板位置。"
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 清除所有設定並重載。"
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "一個停止錯誤發生了，但無需擔心，三不五時會發生，請點擊重載按鈕來解決它。"
L["Aerie Peak"] = "應巢山"
L["Alpha"] = "透明"
L["Alterac Mountains"] = "奧特蘭山脈"
L["Arathi Highlands"] = "阿拉希高地"
L["Ashenvale"] = "梣谷"
L["Astranaar"] = "阿斯特蘭納"
L["Astravar Harbor"] = "艾斯特瓦港"
L["Auberdine"] = "奧伯丁"
L["Auchenai Crypts"] = "奧奇奈地穴"
L["Auchindoun"] = "奧齊頓"
L["Azjol-Nerub"] = "阿茲歐-奈幽"
L["Azshara"] = "艾薩拉"
L["Back to Main Menu"] = "回到主選單"
L["Badlands"] = "荒蕪之地"
L["Baradin Hold"] = "巴拉丁堡"
L["Black Morass"] = "黑色沼澤"
L["Black Temple"] = "黑暗神廟"
L["Blackfathom Deeps"] = "黑澗深淵"
L["Blackrock Caverns"] = "黑石洞穴"
L["Blackrock Depths"] = "黑石深淵"
L["Blackrock Foundry"] = "黑石鑄造廠"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Descent"] = "黑翼陷窟"
L["Blackwing Lair"] = "黑翼之巢"
L["Blasted Lands"] = "詛咒之地"
L["Bloodmaul Slag Mines"] = "血槌熔渣礦場"
L["Bloodvenom Post"] = "血毒崗哨"
L["Blue"] = "藍色"
L["Boat to"] = "船到"
L["Booty Bay"] = "藏寶海灣"
L["Burning Steppes"] = "燃燒平原"
L["Camp Taurajo"] = "陶拉祖營地"
L["Caverns of Time"] = "時光之穴"
L["Cenarion Hold"] = "賽納里奧要塞"
L["Chillwind Camp"] = "冰風崗哨"
L["Class colored icons"] = "職業著色圖示"
L["Class Colored Icons"] = "職業著色圖示"
L["Classic"] = "經典"
L["Click to configure the settings for this option."] = "點擊來設置此選項的設定。"
L["Click to reset the position and scale of the map frame."] = "點擊來重設地圖框架的位置與大小。"
L["Click to reset the settings on this page."] = "點擊來重設此頁的設定。"
L["Click to return to the main menu."] = "點擊來重返主選單。"
L["Coilfang Reservoir"] = "盤牙蓄湖"
L["Configuration Panel"] = "設置面板"
L["Culling of Stratholme"] = "斯坦索姆的抉擇"
L["Cursor"] = "鼠標"
L["Darkshire"] = "夜色鎮"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "達納蘇斯"
L["Deadwind Pass"] = "逆風小徑"
L["Desolace"] = "淒涼之地"
L["Dire Maul"] = "厄運之槌"
L["Dire Maul (East)"] = "厄運之槌 (東)"
L["Dire Maul (North)"] = "厄運之槌 (北)"
L["Dire Maul (West)"] = "厄運之槌 (西)"
L["Dire Maul: Capital Gardens"] = "厄運之槌：中心花園"
L["Dire Maul: Gordok Commons"] = "厄運之槌：戈多克平民區"
L["Dire Maul: Warpwood Quarter"] = "厄運之槌：杻木廣場"
L["Disable reading emote when opening the map"] = "當開啟地圖時取消閱讀表情"
L["Drag"] = "拖動"
L["Drag to set the amount of blue."] = "拖拉來設定藍色的數值。"
L["Drag to set the amount of green."] = "拖拉來設定綠色的數值。"
L["Drag to set the amount of red."] = "拖拉來設定紅色的數值。"
L["Drag to set the group icon size."] = "拖拉來設定隊伍圖示大小。"
L["Drag to set the map opacity for when your character is moving."] = "拖拉來設定當您角色移動時地圖的透明度。"
L["Drag to set the map opacity for when your character is stationary."] = "拖拉來設定當您角色靜止時地圖的透明度。"
L["Drag to set the opacity."] = "拖拉來設定透明度。"
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "拖拉以設置玩家箭頭大小。|n|n魔獸世界經典版預設為16。|n魔獸世界正式版預設為27。"
L["Dragon Soul"] = "巨龍之魂"
L["Drak'Tharon Keep"] = "德拉克薩隆要塞"
L["Druid only flight point to Darnassus"] = "到達納蘇斯的德魯伊專用鳥點"
L["Druid only flight point to Thunder Bluff"] = "到雷霆崖的德魯伊專用鳥點"
L["Dun Morogh"] = "丹莫洛"
L["Dungeon"] = "地城"
L["Durotar"] = "杜洛塔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "塵泥沼澤"
L["Dwarven District"] = "矮人區"
L["Eastern Plaguelands"] = "東瘟疫之地"
L["Elements"] = "元素"
L["Elwynn Forest"] = "艾爾文森林"
L["End Time"] = "終焉之刻"
L["Enlarge player arrow"] = "放大玩家箭頭"
L["Enlarge Player Arrow"] = "放大玩家箭頭"
L["Enter"] = "輸入"
L["Eternal Guardian"] = "永恆守護者"
L["Everlook"] = "永望鎮"
L["Evermoon Terrace"] = "永月露臺"
L["Eye of Azshara"] = "艾薩拉之眼"
L["Falanaar"] = "法拉納爾"
L["Feathermoon Stronghold"] = "羽月要塞"
L["Felsoul Hold"] = "魔魂堡"
L["Felwood"] = "費伍德森林"
L["Feralas"] = "菲拉斯"
L["Firelands"] = "火源之界"
L["Gadgetzan"] = "加基森"
L["Gate of the Setting Sun"] = "落陽關"
L["Gnomeregan"] = "諾姆瑞根"
L["Green"] = "綠色"
L["Grim Batol"] = "格瑞姆巴托"
L["Grimrail Depot"] = "恐軌車站"
L["Grom'gol Base Camp"] = "格羅姆高營地"
L["Group Icons"] = "隊伍圖示"
L["Gruul's Lair"] = "戈魯爾之巢"
L["Gundrak"] = "剛德拉克"
L["Gundrak (rear entrance)"] = "剛德拉克（後方入口）"
L["Halls of Lightning"] = "雷光大廳"
L["Halls of Origination"] = "起源大廳"
L["Halls of Stone"] = "石之大廳"
L["Halls of Valor"] = "英靈殿"
L["Hammerfall"] = "落錘鎮"
L["Heart of Fear"] = "恐懼之心"
L["Hellfire Citadel"] = "地獄火堡壘"
L["Hellfire Ramparts"] = "地獄火壁壘"
L["Hide town and city icons"] = "隱藏城鎮與都市圖示"
L["Highmaul"] = "天槌"
L["Hillsbrad Foothills"] = "希爾斯布萊德丘陵"
L["Hour of Twilight"] = "暮光之時"
L["Hyjal Summit"] = "海加爾山之戰"
L["Icecrown"] = "寒冰皇冠"
L["Icecrown Citadel"] = "冰冠城寨"
L["Icons"] = "圖示"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "勾選後，船舶碼頭、飛艇塔樓以及地鐵站都將顯示。"
L["If checked, coordinates will be shown."] = "勾選後，將顯示座標。"
L["If checked, dungeons and raids will be shown."] = "勾選後，將顯示地下城與團隊副本。"
L["If checked, flight points will be shown."] = "勾選後，將顯示飛行鳥點。"
L["If checked, group icons will use a modern, class-colored design."] = "勾選後，隊伍圖示將使用更為摩登且職業著色的設計。"
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "勾選後，開啟地圖時會使用最後關閉地圖時的縮放等級，如果地圖區域並未改變。"
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "勾選後，當角色移動時指向地圖將會套用靜止的透明度設置。"
L["If checked, points of interest will be shown."] = "勾選後，將顯示關注點。"
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will prevent you from unlocking the map or removing the map border."] = "勾選後，將使用預設的全螢幕地圖。|n|n注意，啟用此選項會防止您解鎖地圖或移除地圖外框。"
L["If checked, the map border will be removed."] = "勾選後，將會移除地圖外框。"
L["If checked, the minimap button will be shown."] = "勾選後，會顯示小地圖按鈕。"
L["If checked, the minimum fishing skill levels will be shown."] = "勾選後，將顯示最低釣魚需求技能等級。"
L["If checked, town and city icons will not be shown on the continent maps."] = "勾選後，大陸地圖將不會顯示城鎮與都市圖示。"
L["If checked, unexplored areas of the map will be shown."] = "勾選後，將會顯露未探索區域。"
L["If checked, unexplored areas will be tinted."] = "勾選後，未探索區域將會著色。"
L["If checked, you will be able to enlarge the player arrow."] = "勾選後，您將可以放大玩家箭頭。"
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges.  If you have removed the map border, a drag button will be shown in the top-left corner."] = "勾選後，您將可以縮放與移動地圖。|n|n拖拉右下角的縮放把柄來縮放地圖。|n|n透由拖動外框與框架邊緣來移動地圖。如果您已移除地圖外框，左上角會顯示一個拖拉按鈕。"
L["If checked, you will be able to set the opacity of the map."] = "勾選後，您將可以設定地圖的透明度。"
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "勾選後，將顯示區域、地下城以及釣魚技能等級。"
L["Invalid command.  Enter /ltm help for help."] = "無效的指令。輸入 /ltm help 取得幫助。"
L["Iron Docks"] = "鋼鐵碼頭"
L["Ironforge"] = "鐵爐堡"
L["Karazhan"] = "卡拉贊"
L["Kargath"] = "卡加斯"
L["Lake Elune'ara"] = "月神湖"
L["Lake Everstill"] = "湖畔鎮"
L["Large Scarab Coffer"] = "大型聖甲蟲箱"
L["Light's Hope Chapel"] = "聖光之願大教堂"
L["Lion's Watch"] = "雄獅堡"
L["Loch Modan"] = "洛克莫丹"
L["Lost City of the Tol'vir"] = "托維爾的失落之城"
L["Lower Blackrock Spire"] = "黑石塔下層"
L["Lunastre Estate"] = "路納斯特莊園"
L["Magisters' Terrace"] = "博學者殿堂"
L["Magtheridon's Lair"] = "瑪瑟里頓的巢穴"
L["Mana-Tombs"] = "法力墓地"
L["Map frame scale"] = "地圖框架縮放"
L["Maraudon"] = "瑪拉頓"
L["Maraudon: Earth Song Falls"] = "瑪拉頓：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "瑪拉頓：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "瑪拉頓：邪惡洞穴"
L["Marshal's Refuge"] = "馬紹爾營地"
L["Mechanics"] = "地圖結構"
L["Memory Usage"] = "記憶體使用量"
L["Menethil Harbor"] = "米奈希爾港"
L["Miscellaneous"] = "雜項"
L["Mogu'shan Palace"] = "魔古山宮"
L["Mogu'shan Vaults"] = "魔古山寶庫"
L["Molten Core"] = "熔火之心"
L["Moon Guard Stronghold"] = "月之守衛要塞"
L["Moonglade"] = "月光林地"
L["Morgan's Vigil"] = "摩根的崗哨"
L["Mount Hyjal"] = "海加爾山"
L["Moving"] = "移動"
L["Mulgore"] = "莫高雷"
L["Naxxramas"] = "納克薩瑪斯"
L["Nethergarde Keep"] = "守望堡"
L["Nighthaven"] = "永夜港"
L["Nijel's Point"] = "尼耶爾前哨站"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "注意！|n您必須完全重新啟動遊戲客戶端才能使用此版本的Leatrix Maps。"
L["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址"
L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
L["Opacity"] = "透明度"
L["or click the minimap button to open Leatrix Maps."] = "或是點擊小地圖按鈕來開啟Leatrix Maps。"
L["Orgrimmar"] = "奧格瑪"
L["Player"] = "玩家"
L["Player Arrow"] = "玩家箭頭"
L["Portal"] = "傳送門"
L["Portal from Zephyr"] = "賽非爾的傳送門"
L["Preview"] = "預覽"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "團隊副本"
L["Ratchet"] = "棘齒城"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼澤"
L["Red"] = "紅色"
L["Redridge Mountains"] = "赤脊山"
L["Refuge Pointe"] = "避難谷地"
L["Reload"] = "重載"
L["Remember zoom level"] = "記憶縮放等級"
L["Remove map border"] = "移除地圖外框"
L["Requires UI reload."] = "需要介面重載。"
L["Reset"] = "重置"
L["Reset Map Layout"] = "重設地圖佈局"
L["Return to Karazhan"] = "重返卡拉贊"
L["Ruins of Ahn'Qiraj"] = "安琪拉廢墟"
L["Ruins of Elune'eth"] = "伊露恩斯遺址"
L["Rut'theran Village"] = "魯瑟蘭村"
L["Sanctum of Order"] = "秩序聖所"
L["Scale"] = "縮放比例"
L["Scarlet Halls"] = "血色大廳"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通靈學院"
L["Searing Gorge"] = "灼熱峽谷"
L["Sentinel Hill"] = "哨兵嶺"
L["Serpentshrine Cavern"] = "毒蛇神殿洞穴"
L["Set map opacity"] = "設定地圖透明度"
L["Set Map Opacity"] = "設定地圖透明度"
L["Set map opacity while stationary and while moving."] = "設定當移動或靜止時地圖的透明度。"
L["Set the group icon size."] = "設定隊伍圖示大小。"
L["Set the player arrow size."] = "設置玩家箭頭大小。"
L["Sethekk Halls"] = "塞司克大廳"
L["Settings"] = "設置"
L["Shado-Pan Monastery"] = "影潘僧院"
L["Shadow Labyrinth"] = "暗影迷宮"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shal'Aran"] = "沙亞蘭"
L["Show boats, zeppelins and trams"] = "顯示船舶、飛艇以及地鐵"
L["Show coordinates"] = "顯示座標"
L["Show dungeons and raids"] = "顯示地下城與團隊副本"
L["Show flight points"] = "顯示飛行鳥點"
L["Show minimap button"] = "顯示小地圖按鈕"
L["Show minimap travel"] = "顯示小地圖旅行站點"
L["Show minimum fishing skill levels"] = "顯示最低釣魚技能等級"
L["Show points of interest"] = "顯示關注站點"
L["Show Points Of Interest"] = "顯示關注站點"
L["Show scale handle"] = "顯示縮放控制"
L["Show travel points"] = "顯示旅行站點"
L["Show unexplored areas"] = "顯露未探索區域"
L["Show Unexplored Areas"] = "顯露未探索區域"
L["Show zone levels"] = "顯示區域等級"
L["Show Zone Levels"] = "顯示區域等級"
L["Siege of Niuzao Temple"] = "圍攻怒兆寺"
L["Siege of Orgrimmar"] = "圍攻奧格瑪"
L["Silithus"] = "希利蘇斯"
L["Silverpine Forest"] = "銀松森林"
L["Skyreach"] = "擎天峰"
L["Slave Pens"] = "奴隸監牢"
L["Southshore"] = "南海鎮"
L["Splintertree Post"] = "碎木崗哨"
L["Stationary"] = "靜止"
L["Steamvault"] = "蒸氣洞窟"
L["Stonard"] = "斯通納德"
L["Stonetalon Mountains"] = "石爪山脈"
L["Stonetalon Peak"] = "石爪峰"
L["Stormstout Brewery"] = "風暴烈酒酒坊"
L["Stormwind"] = "暴風城"
L["Stranglethorn Vale"] = "荊棘谷"
L["Stratholme (Main Gate)"] = "斯坦索姆 (正門)"
L["Stratholme (Service Gate)"] = "斯坦索姆 (側門)"
L["Sun Rock Retreat"] = "烈日石居"
L["Sunwell Plateau"] = "太陽之井高地"
L["Swamp of Sorrows"] = "悲傷沼澤"
L["Tanaris"] = "塔納利斯"
L["Tarren Mill"] = "塔倫米爾"
L["Tel'anor"] = "泰爾亞諾"
L["Teldrassil"] = "泰達希爾"
L["Tempest Keep"] = "風暴要塞"
L["Temple of Ahn'Qiraj"] = "安琪拉神廟"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神廟"
L["Temple of the Jade Serpent"] = "玉蛟寺"
L["Terrace of Endless Spring"] = "豐泉台"
L["The Arcatraz"] = "亞克崔茲"
L["The Barrens"] = "貧瘠之地"
L["The Bastion of Twilight"] = "暮光堡壘"
L["The Black Morass"] = "黑色沼澤"
L["The Blood Furnace"] = "血熔爐"
L["The Botanica"] = "波塔尼卡"
L["The Crossroads"] = "十字路口"
L["The Culling of Stratholme"] = "斯坦索姆的抉擇"
L["The Deadmines"] = "死亡礦坑"
L["The Dragon Soul"] = "巨龍之魂"
L["The Everbloom"] = "永茂林"
L["The Eye"] = "暴風之眼"
L["The Eye of Eternity"] = "永恆之眼"
L["The Forge of Souls"] = "眾魂熔爐"
L["The Frozen Halls"] = "冰封大廳"
L["The Great Forge"] = "大鍛爐"
L["The Halls of Reflection"] = "鏡像大廳"
L["The Hinterlands"] = "辛特蘭"
L["The Mechanar"] = "麥克納爾"
L["The Nexus"] = "奧核之心"
L["The Obsidian Sanctum"] = "黑曜聖所"
L["The Oculus"] = "奧核之眼"
L["The Old Kingdom"] = "古王國"
L["The Pit of Saron"] = "薩隆陷坑"
L["The Ruby Sanctum"] = "晶紅聖所"
L["The Shattered Halls"] = "破碎大廳"
L["The Stockade"] = "監獄"
L["The Stonecore"] = "石岩之心"
L["The Violet Hold"] = "紫羅蘭堡"
L["The Vortex Pinnacle"] = "漩渦尖塔"
L["The Waning Crescent"] = "弦月旅店"
L["Theramore Isle"] = "賽拉摩島"
L["Thorium Point"] = "瑟銀哨站"
L["Thousand Needles"] = "千針石林"
L["Throne of the Four Winds"] = "四風王座"
L["Throne of the Tides"] = "海潮王座"
L["Throne of Thunder"] = "雷霆王座"
L["Thunder Bluff"] = "雷霆崖"
L["Tint unexplored areas"] = "未探索區域色調"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["Tomb of Sargeras"] = "薩格拉斯之墓"
L["Trade District"] = "貿易區"
L["Trade Quarter"] = "貿易區"
L["Tram to"] = "電車到"
L["Transparency"] = "透明度"
L["Trial of the Champion"] = "勇士試煉"
L["Trial of the Crusader"] = "十字軍試煉"
L["Twilight Vineyards"] = "暮光葡萄園"
L["Uldaman"] = "奧達曼"
L["Ulduar"] = "奧杜亞"
L["Underbog"] = "幽暗沼澤"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈落環形山"
L["Unlock map frame"] = "解鎖地圖框架"
L["Upper Blackrock Spire"] = "黑石塔上層"
L["Use default map"] = "使用預設地圖"
L["Use stationary opacity while pointing at map"] = "指向地圖時使用固定的透明度"
L["Utgarde Keep"] = "俄特加德要塞"
L["Utgarde Pinnacle"] = "俄特加德之巔"
L["Valley of Strength"] = "力量之谷"
L["Vault of Archavon"] = "亞夏梵穹殿"
L["Version"] = "版本"
L["Vol'mar"] = "沃爾瑪"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Well of Eternity"] = "永恆之井"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "濕地"
L["Winterspring"] = "冬泉谷"
L["Wyrmrest Temple"] = "龍眠神殿"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "您的UI需要重載以讓某些更動生效。|n|n您不用立刻點擊重載按鈕，但當您做了些更動並想要更動生效的話，需要馬上重載。"
L["Your UI needs to be reloaded."] = "您的UI需要重載。"
L["Zeppelin to"] = "飛船到"
L["Zoram'gar Outpost"] = "佐拉姆加前哨站"
L["Zul'Aman"] = "祖阿曼"
L["Zul'Farrak"] = "祖爾法拉克"
L["Zul'Gurub"] = "祖爾格拉布"

end

-- ruRU: Russian
if GameLocale == "ruRU" then
L["/ltm help - Show this information."] = "/ltm help - Показать эту информацию."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Сбросить положение панели."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Удалить все настройки и перезагрузить."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Возникла ошибка, но не беспокойтесь. Такое бывает время от времени. Перезагрузите интерфейс, чтобы исправить её."
L["Aerie Peak"] = "Заоблачный пик"
L["Alpha"] = "Альфа"
L["Alterac Mountains"] = "Альтеракские горы"
L["Arathi Highlands"] = "Нагорье Арати"
L["Ashenvale"] = "Ясеневый лес"
L["Astranaar"] = "Астранаар"
L["Astravar Harbor"] = "Гавань Астравар"
L["Auberdine"] = "Аубердин"
L["Auchenai Crypts"] = "Аукенайские гробницы"
L["Auchindoun"] = "Аукиндон"
L["Azjol-Nerub"] = "Азжол-Неруб"
L["Azshara"] = "Азшара"
L["Back to Main Menu"] = "Вернуться в главное меню"
L["Badlands"] = "Бесплодные земли"
L["Baradin Hold"] = "Крепость Барадин"
L["Black Morass"] = "Черные топи"
L["Black Temple"] = "Черный храм"
L["Blackfathom Deeps"] = "Непроглядная Пучина"
L["Blackrock Caverns"] = "Пещеры Черной горы"
L["Blackrock Depths"] = "Глубины Черной горы"
L["Blackrock Foundry"] = "Литейная клана Черной горы"
L["Blackrock Mountain"] = "Черная гора"
L["Blackrock Spire"] = "Пик Черной горы"
L["Blackwing Descent"] = "Твердыня Крыла Тьмы"
L["Blackwing Lair"] = "Логово Крыла Тьмы"
L["Blasted Lands"] = "Выжженные земли"
L["Bloodmaul Slag Mines"] = "Шлаковые шахты Кровавого Молота"
L["Bloodvenom Post"] = "Застава Отравленной Крови"
L["Blue"] = "Синий"
L["Boat to"] = "Корабль в"
L["Booty Bay"] = "Пиратская Бухта"
L["Brackenwall Village"] = "Деревня Гиблотопь"
L["Burning Steppes"] = "Пылающие степи"
L["Camp Mojache"] = "Лагерь Мохаче"
L["Camp Taurajo"] = "Лагерь Таурахо"
L["Caverns of Time"] = "Пещеры Времени"
L["Cenarion Hold"] = "Крепость Кенария"
L["Central Mesa"] = "Центральная меза"
L["Chillwind Camp"] = "Лагерь Промозглого Ветра"
L["Class colored icons"] = "Классовые цветные значки"
L["Class Colored Icons"] = "Значки под цвет класса"
L["Classic"] = "Классик"
L["Click to configure the settings for this option."] = "Нажмите, чтобы настроить параметры для этой опции."
L["Click to reset the position and scale of the map frame."] = "Нажмите, чтобы сбросить положение и масштаб окна карты."
L["Click to reset the settings on this page."] = "Нажмите, чтобы сбросить настройки на этой странице."
L["Click to return to the main menu."] = "Нажмите, чтобы вернуться в главное меню."
L["Coilfang Reservoir"] = "Резервуар Кривого Клыка"
L["Configuration Panel"] = "Панель настроек"
L["Culling of Stratholme"] = "Очищение Стратхольма"
L["Cursor"] = "Курсор"
L["Darkshire"] = "Темнолесье"
L["Darkshore"] = "Темные берега"
L["Darnassus"] = "Дарнас"
L["Deadwind Pass"] = "Перевал Мертвого Ветра"
L["Desolace"] = "Пустоши"
L["Dire Maul"] = "Забытый Город"
L["Dire Maul (East)"] = "Забытый Город (Восток)"
L["Dire Maul (North)"] = "Забытый Город (Север)"
L["Dire Maul (West)"] = "Забытый Город (Запад)"
L["Dire Maul: Capital Gardens"] = "Забытый Город (Центральный сад)"
L["Dire Maul: Gordok Commons"] = "Забытый Город (Палаты Гордока)"
L["Dire Maul: Warpwood Quarter"] = "Забытый Город (Квартал Криводревов)"
L["Disable reading emote when opening the map"] = "Отключить эмоцию открытия карты"
L["Drag"] = "Передвинуть"
L["Drag to set the amount of blue."] = "Перетащите, чтобы установить количество синего."
L["Drag to set the amount of green."] = "Перетащите, чтобы установить количество зеленого."
L["Drag to set the amount of red."] = "Перетащите, чтобы установить количество красного."
L["Drag to set the group icon size."] = "Перетащите, чтобы установить размер значка группы."
L["Drag to set the map opacity for when your character is moving."] = "Перетащите, чтобы установить непрозрачность карты, когда ваш персонаж движется."
L["Drag to set the map opacity for when your character is stationary."] = "Перетащите, чтобы установить непрозрачность карты, когда ваш персонаж неподвижен."
L["Drag to set the opacity."] = "Перетащите, чтобы установить непрозрачность."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Перетащите для установки размера стрелки игрока.|n|nClassic по умолчанию 16 .|nАктуальная версия по умолчанию - 27."
L["Dragon Soul"] = "Душа Дракона"
L["Drak'Tharon Keep"] = "Крепость Драк'Тарон"
L["Druid only flight point to Darnassus"] = "Пункт перелета в Дарнас (только для Друида)"
L["Druid only flight point to Thunder Bluff"] = "Пункт перелета в Громовой Утес (только для Друида)"
L["Dun Morogh"] = "Дун Морог"
L["Dungeon"] = "Подземелье"
L["Durotar"] = "Дуротар"
L["Duskwood"] = "Сумеречный лес"
L["Dustwallow Marsh"] = "Пылевые топи"
L["Dwarven District"] = "Подземный поезд"
L["Eastern Plaguelands"] = "Восточные Чумные земли"
L["Elements"] = "Элементы"
L["Elwynn Forest"] = "Элвиннский лес"
L["End Time"] = "Конец Времен"
L["Enlarge player arrow"] = "Увеличить стрелку игрока"
L["Enlarge Player Arrow"] = "Увеличить стрелку игрока"
L["Enter"] = "Введите"
L["Eternal Guardian"] = "Вечный страж"
L["Everlook"] = "Круговзор"
L["Evermoon Terrace"] = "Терраса Вечной Луны"
L["Eye of Azshara"] = "Око Азшары"
L["Falanaar"] = "Фаланаар"
L["Feathermoon Stronghold"] = "Крепость Оперенной Луны"
L["Felsoul Hold"] = "Оплот Оскверненной Души"
L["Felwood"] = "Оскверненный лес"
L["Feralas"] = "Фералас"
L["Firelands"] = "Огненные Просторы"
L["Flame Crest"] = "Пламенеющий Стяг"
L["Freewind Post"] = "Застава Вольного Ветра"
L["Gadgetzan"] = "Прибамбасск"
L["Gate of the Setting Sun"] = "Врата Заходящего Солнца"
L["Gnomeregan"] = "Гномреган"
L["Green"] = "Зеленый"
L["Grim Batol"] = "Грим Батол"
L["Grimrail Depot"] = "Депо Мрачных Путей"
L["Grom'gol Base Camp"] = "Гром'гол"
L["Group Icons"] = "Значки Группы"
L["Gruul's Lair"] = "Логово Груула"
L["Gundrak"] = "Гундрак"
L["Gundrak (rear entrance)"] = "Гундрак: черный ход"
L["Halls of Lightning"] = "Чертоги Молний"
L["Halls of Origination"] = "Чертоги Созидания"
L["Halls of Stone"] = "Чертоги Камня"
L["Halls of Valor"] = "Чертоги Доблести"
L["Hammerfall"] = "Павший Молот"
L["Heart of Fear"] = "Сердце Страха"
L["Hellfire Citadel"] = "Цитадель Адского Пламени"
L["Hellfire Ramparts"] = "Бастионы Адского Пламени"
L["Hide town and city icons"] = "Скрыть значки города"
L["Highmaul"] = "Земли клана Верховного Молота"
L["Hillsbrad Foothills"] = "Предгорья Хилсбрада"
L["Hour of Twilight"] = "Время Сумерек"
L["Hyjal Summit"] = "Вершина Хиджала"
L["Icecrown"] = "Ледяная Корона"
L["Icecrown Citadel"] = "Цитадель Ледяной Короны"
L["Icons"] = "Иконки"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Если установлен этот флажок, на карте будут отмечаться порты и их направления, башни дирижаблей и их направления, а также входы в подземный поезд."
L["If checked, coordinates will be shown."] = "Если установлен этот флажок, на карте будут отображаться координаты."
L["If checked, dungeons and raids will be shown."] = "Если установлен этот флажок, на карте будут отображаться входы в подземелья и рейдовые подземелья."
L["If checked, flight points will be shown."] = "Если установлен этот флажок, на карте будут отображаться точки полета."
L["If checked, group icons will use a modern, class-colored design."] = "Если установлен этот флажок, значки групп будут использовать современный цветной дизайн."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Если установлен этот флажок, то при открытии карты будет использоваться тот же уровень масштабирования, что и при последнем закрытии карты, если зона карты не изменилась."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Если установлен этот флажок, то указание на карту во время движения вашего персонажа приведет к применению настройки непрозрачности."
L["If checked, points of interest will be shown."] = "Если установлен этот флажок, на карте будут отображаться различные полезные достопримечательности."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will prevent you from unlocking the map or removing the map border."] = "Если установлен этот флажок, будет отображаться обычная полноэкранная карта игры.|n|nПримечание: если вы включите эту опцию, вам станут недоступны настройки по отключению границы карты и разблокированию её окна."
L["If checked, the map border will be removed."] = "Если установлен этот флажок, граница карты будет удалена."
L["If checked, the minimap button will be shown."] = "Если установлен этот флажок, у мини-карты будет отображаться кнопка аддона."
L["If checked, the minimum fishing skill levels will be shown."] = "Если установлен этот флажок, будут показаны минимальные уровни навыка рыбной ловли."
L["If checked, town and city icons will not be shown on the continent maps."] = "Если установлен этот флажок, на картах континентов не будут отображаться значки городов."
L["If checked, unexplored areas of the map will be shown."] = "Если установлен этот флажок, будут отображаться неисследованные области карты, но с отдельным затемнением."
L["If checked, unexplored areas will be tinted."] = "Если установлен этот флажок, неисследованные области будут отображаться на карте, но будут отдельно затемнены."
L["If checked, you will be able to enlarge the player arrow."] = "Если установлен этот флажок, вы сможете увеличить указатель (стрелку) игрока."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges.  If you have removed the map border, a drag button will be shown in the top-left corner."] = "Если установлен этот флажок, у вас появится возможность изменять размер карты и её место расположения|n|n|Масштабируйте карту, перетаскивая маркер масштаба в правом нижнем углу.|n|nПеремещайте карту, перетаскивая границу и края окна. Если вы скрыли отображение границы окна карты, то в верхнем левом углу появится кнопка для перемещения карты."
L["If checked, you will be able to set the opacity of the map."] = "Если установлен этот флажок, у вас появится возможность изменять прозрачность карты."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Если установлен этот флажок, на карте будут отображаться зоны, подземелья и минимальный необходимый уровень рыбной ловли."
L["Invalid command.  Enter /ltm help for help."] = "Неверная команда. Введите /ltm help для помощи."
L["Iron Docks"] = "Железные доки"
L["Ironforge"] = "Стальгорн"
L["Karazhan"] = "Каражан"
L["Kargath"] = "Каргат"
L["Lake Elune'ara"] = "Озеро Элуне'ара"
L["Lake Everstill"] = "Озеро Безмолвия"
L["Large Scarab Coffer"] = "Большой сундук Скарабея"
L["Light's Hope Chapel"] = "Часовня Последней Надежды"
L["Lion's Watch"] = "Львиный дозор"
L["Loch Modan"] = "Лок Модан"
L["Lost City of the Tol'vir"] = "Затерянный город Тол'вир"
L["Lower Blackrock Spire"] = "Нижняя часть пика Черной горы"
L["Lower Wilds"] = "Низинные чащобы"
L["Lunastre Estate"] = "Поместья Лунархов"
L["Magisters' Terrace"] = "Терраса Магистров"
L["Magtheridon's Lair"] = "Логово Магтеридона"
L["Mana-Tombs"] = "Гробницы Маны"
L["Map frame scale"] = "Масштабирование карты"
L["Maraudon"] = "Мародон"
L["Maraudon: Earth Song Falls"] = "Мародон (Поющие водопады)"
L["Maraudon: Foulspore Cavern"] = "Мародон (Зловонная пещера)"
L["Maraudon: The Wicked Grotto"] = "Мародон (Оскверненный грот)"
L["Marshal's Refuge"] = "Укрытие Маршалла"
L["Mechanics"] = "Механика"
L["Memory Usage"] = "Использование памяти"
L["Menethil Harbor"] = "Гавань Менетилов"
L["Miscellaneous"] = "Прочее"
L["Mogu'shan Palace"] = "Дворец Могу'шан"
L["Mogu'shan Vaults"] = "Подземелья Могу'шан"
L["Molten Core"] = "Огненные Недра"
L["Moon Guard Stronghold"] = "Цитадель Лунных стражей"
L["Moonglade"] = "Лунная поляна"
L["Morgan's Vigil"] = "Дозор Морганы"
L["Mount Hyjal"] = "Гора Хиджал"
L["Moving"] = "Перемещение"
L["Mulgore"] = "Мулгор"
L["Naxxramas"] = "Наксрамас"
L["Nethergarde Keep"] = "Крепость Стражей Пустоты"
L["Nighthaven"] = "Ночная Гавань"
L["Nijel's Point"] = "Высота Найджела"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "ВНИМАНИЕ! Вы должны полностью перезапустить свой игровой клиент, прежде чем использовать эту версию Leatrix Maps."
L["Old Hillsbrad Foothills"] = "Старые предгорья Хилсбрада"
L["Onyxia's Lair"] = "Логово Ониксии"
L["Opacity"] = "Затемнение"
L["or click the minimap button to open Leatrix Maps."] = "или нажмите на кнопку у миникарты для открытия окна Leatrix Maps."
L["Orgrimmar"] = "Оргриммар"
L["Player"] = "Игрок"
L["Player Arrow"] = "Указатель игрока"
L["Portal"] = "Портал"
L["Portal from Zephyr"] = "Портал от Зефира"
L["Preview"] = "Превью"
L["Ragefire Chasm"] = "Огненная Пропасть"
L["Raid"] = "Рейд"
L["Ratchet"] = "Кабестан"
L["Razorfen Downs"] = "Курганы Иглошкурых"
L["Razorfen Kraul"] = "Лабиринты Иглошкурых"
L["Red"] = "Красный"
L["Redridge Mountains"] = "Красногорье"
L["Refuge Pointe"] = "Опорный пункт"
L["Reload"] = "Перезагрузить"
L["Remember zoom level"] = "Запомнить уровень приближения"
L["Remove map border"] = "Убрать границы карты"
L["Requires UI reload."] = "Требуется перезагрузка UI"
L["Reset"] = "Сброс"
L["Reset Map Layout"] = "Сбросить карты"
L["Return to Karazhan"] = "Возвращение в Каражан"
L["Revantusk Village"] = "Деревня Сломанного Клыка"
L["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража"
L["Ruins of Elune'eth"] = "Руины Элун'ета"
L["Rut'theran Village"] = "Деревня Рут'теран"
L["Sanctum of Order"] = "Святилища Порядка"
L["Scale"] = "Масштаб"
L["Scarlet Halls"] = "Залы Алого ордена"
L["Scarlet Monastery"] = "Монастырь Алого ордена"
L["Scholomance"] = "Некроситет"
L["Searing Gorge"] = "Тлеющее ущелье"
L["Sentinel Hill"] = "Сторожевой холм"
L["Serpentshrine Cavern"] = "Змеиное святилище"
L["Set map opacity"] = "Настройка прозрачности карты"
L["Set Map Opacity"] = "Настройка прозрачности карты"
L["Set map opacity while stationary and while moving."] = "Настройка прозрачности карты для двух различных состояний: когда вы стоите и когда вы движетесь."
L["Set the group icon size."] = "Установите размер значка группы."
L["Set the player arrow size."] = "Установите желаемый размер для указателя (стрелки) игрока."
L["Sethekk Halls"] = "Сетеккские залы"
L["Settings"] = "Настройки"
L["Shado-Pan Monastery"] = "Монастырь Шадо-Пан"
L["Shadow Labyrinth"] = "Темный лабиринт"
L["Shadowfang Keep"] = "Крепость Темного Клыка"
L["Shadowmoon Burial Grounds"] = "Некрополь Призрачной Луны"
L["Shadowprey Village"] = "Деревня Ночных Охотников"
L["Shal'Aran"] = "Шал'Аран"
L["Show boats, zeppelins and trams"] = "Отмечать на карте порты, башни дирижаблей и подземный поезд"
L["Show coordinates"] = "Показывать координаты"
L["Show dungeons and raids"] = "Отмечать на карте входы в подземелья и рейдовые подземелья"
L["Show flight points"] = "Отмечать на карте точки полёта"
L["Show minimap button"] = "Показать кнопку на мини-карты"
L["Show minimap travel"] = "Показать путешествие на миникарте"
L["Show minimum fishing skill levels"] = "Показывать мин.уровень рыбной ловли"
L["Show points of interest"] = "Показывать достопримечательности"
L["Show Points Of Interest"] = "Показывать достопримечательности"
L["Show scale handle"] = "Показывать шкалу масштабирования"
L["Show travel points"] = "Показать пункты путешествия"
L["Show unexplored areas"] = "Показать неисследованные области"
L["Show Unexplored Areas"] = "Показать неисследованные области"
L["Show zone levels"] = "Показывать уровни локаций"
L["Show Zone Levels"] = "Показывать уровни локаций"
L["Siege of Niuzao Temple"] = "Осада храма Нюцзао"
L["Siege of Orgrimmar"] = "Осада Оргриммара"
L["Silithus"] = "Силитус"
L["Silverpine Forest"] = "Серебряный бор"
L["Skyreach"] = "Небесный Путь"
L["Slave Pens"] = "Узилище"
L["Southshore"] = "Южнобережье"
L["Splintertree Post"] = "Застава Расщепленного Дерева"
L["Stationary"] = "Стационарно"
L["Steamvault"] = "Паровое подземелье"
L["Stonard"] = "Каменор"
L["Stonetalon Mountains"] = "Когтистые горы"
L["Stonetalon Peak"] = "Пик Каменного Когтя"
L["Stormstout Brewery"] = "Хмелеварня Буйных Портеров"
L["Stormwind"] = "Штормград"
L["Stranglethorn Vale"] = "Тернистая долина"
L["Stratholme (Main Gate)"] = "Стратхольм (Главные ворота)"
L["Stratholme (Service Gate)"] = "Стратхольм (Сервисные ворота)"
L["Sun Rock Retreat"] = "Приют у Солнечного Камня"
L["Sunwell Plateau"] = "Плато Солнечного Колодца"
L["Swamp of Sorrows"] = "Болото Печали"
L["Talonbranch Glade"] = "Поляна Когтистых Ветвей"
L["Talrendis Point"] = "Застава Талрендис"
L["Tanaris"] = "Танарис"
L["Tarren Mill"] = "Мельница Таррен"
L["Tel'anor"] = "Тел'анор"
L["Teldrassil"] = "Тельдрассил"
L["Tempest Keep"] = "Крепость Бурь"
L["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж"
L["Temple of Atal'Hakkar"] = "Затонувший храм"
L["Temple of the Jade Serpent"] = "Храм Зин-Малор"
L["Terrace of Endless Spring"] = "Терраса Вечной Весны"
L["The Arcatraz"] = "Аркатрац"
L["The Barrens"] = "Степи"
L["The Bastion of Twilight"] = "Сумеречный бастион"
L["The Black Morass"] = "Черные топи"
L["The Blood Furnace"] = "Кузня Крови"
L["The Botanica"] = "Ботаника"
L["The Crossroads"] = "Перекресток"
L["The Culling of Stratholme"] = "Очищение Стратхольма"
L["The Deadmines"] = "Мертвые копи"
L["The Dragon Soul"] = "Душа Дракона"
L["The Everbloom"] = "Вечное Цветение"
L["The Eye"] = "Око"
L["The Eye of Eternity"] = "Око Вечности"
L["The Forge of Souls"] = "Кузня Душ"
L["The Forgotten Coast"] = "Забытый берег"
L["The Frozen Halls"] = "Ледяные залы"
L["The Great Forge"] = "Великая Кузня"
L["The Halls of Reflection"] = "Залы Отражений"
L["The Hinterlands"] = "Внутренние земли"
L["The Mechanar"] = "Механар"
L["The Nexus"] = "Нексус"
L["The Obsidian Sanctum"] = "Обсидиановое святилище"
L["The Oculus"] = "Окулус"
L["The Old Kingdom"] = "Ан'кахет: Старое Королевство"
L["The Pit of Saron"] = "Яма Сарона"
L["The Ruby Sanctum"] = "Рубиновое святилище"
L["The Sepulcher"] = "Гробница"
L["The Shattered Halls"] = "Разрушенные залы"
L["The Stockade"] = "Тюрьма"
L["The Stonecore"] = "Каменные Недра"
L["The Violet Hold"] = "Аметистовая крепость"
L["The Vortex Pinnacle"] = "Вершина Смерча"
L["The Waning Crescent"] = "Лунный полумрак"
L["Thelsamar"] = "Телcамар"
L["Theramore Isle"] = "Остров Терамор"
L["Thorium Point"] = "Лагерь Братства Тория"
L["Thousand Needles"] = "Тысяча Игл"
L["Throne of the Four Winds"] = "Трон Четырех Ветров"
L["Throne of the Tides"] = "Трон Приливов"
L["Throne of Thunder"] = "Престол Гроз"
L["Thunder Bluff"] = "Громовой Утес"
L["Tinker Town"] = "Город механиков"
L["Tint unexplored areas"] = "Цвет неразведанных участков"
L["Tirisfal Glades"] = "Тирисфальские леса"
L["Tomb of Sargeras"] = "Гробница Саргераса"
L["Trade District"] = "Торговый квартал"
L["Trade Quarter"] = "Торговый квартал"
L["Tram to"] = "Поезд в"
L["Transparency"] = "Прозрачность"
L["Trial of the Champion"] = "Испытание чемпиона"
L["Trial of the Crusader"] = "Испытание крестоносца"
L["Twilight Vineyards"] = "Сумеречные виноградники"
L["Uldaman"] = "Ульдаман"
L["Ulduar"] = "Ульдуар"
L["Underbog"] = "Нижетопь"
L["Undercity"] = "Подгород"
L["Un'Goro Crater"] = "Кратер Ун'Горо"
L["Unlock map frame"] = "Разблокировать окно карты"
L["Upper Blackrock Spire"] = "Верхняя часть пика Черной горы"
L["Use default map"] = "Использовать обычную карту"
L["Use stationary opacity while pointing at map"] = "Используйте постоянную непрозрачность при наведении на карту"
L["Utgarde Keep"] = "Крепость Утгард"
L["Utgarde Pinnacle"] = "Вершина Утгард"
L["Valley of Strength"] = "Аллея Силы"
L["Valormok"] = "Храбростан"
L["Vault of Archavon"] = "Склеп Аркавона"
L["Version"] = "Версия"
L["Vol'mar"] = "Вол'мар"
L["Wailing Caverns"] = "Пещеры Стенаний"
L["Well of Eternity"] = "Источник Вечности"
L["Western Plaguelands"] = "Западные Чумные земли"
L["Westfall"] = "Западный Край"
L["Wetlands"] = "Болотина"
L["Winterspring"] = "Зимние Ключи"
L["Wyrmrest Temple"] = "Храм Драконьего Покоя"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Чтобы некоторые изменения вступили в силу, необходимо перезагрузить Ваш пользовательский интерфейс|n|nНе требуется нажимать кнопку перезагрузки интерфейса сразу после каждого изменения, но её потребуется нажать тогда, когда вы закончите вносить все изменения и захотите, чтобы они вступили в силу."
L["Your UI needs to be reloaded."] = "Вам необходимо перезагрузить UI."
L["Zeppelin to"] = "Дирижабль в"
L["Zoram'gar Outpost"] = "Застава Зорам'гар"
L["Zul'Aman"] = "Зул'Аман"
L["Zul'Farrak"] = "Зул'Фаррак"
L["Zul'Gurub"] = "Зул'Гуруб"

end

-- koKR: Korean
if GameLocale == "koKR" then
L["/ltm help - Show this information."] = "/ltm help - 정보 표시."
L["/ltm reset - Reset the panel position."] = "/ltm reset - 패널 위치 재설정."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - 모든 설정 지우고 리로드."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "정지 오류가 발생했지만 걱정할 필요가 없습니다. 때때로 발생할 수 있습니다. 문제를 해결하려면 리로드 버튼을 클릭하십시오."
L["Aerie Peak"] = "맹금의 봉우리"
L["Alpha"] = "투명도"
L["Alterac Mountains"] = "알터렉 산맥"
L["Arathi Highlands"] = "아라시 고원"
L["Ashenvale"] = "잿빛 골짜기"
L["Astranaar"] = "아스트라나르"
L["Astravar Harbor"] = "아스트라바르 항구"
L["Auberdine"] = "아우버다인"
L["Auchenai Crypts"] = "아키나이 납골당"
L["Auchindoun"] = "아킨둔"
L["Azjol-Nerub"] = "아졸네룹"
L["Azshara"] = "아즈샤라"
L["Back to Main Menu"] = "주 메뉴로 돌아가기"
L["Badlands"] = "황야의 땅"
L["Baradin Hold"] = "바라딘 요새"
L["Black Morass"] = "검은늪"
L["Black Temple"] = "검은 사원"
L["Blackfathom Deeps"] = "검은 심연 나락"
L["Blackrock Caverns"] = "검은바위 동굴"
L["Blackrock Depths"] = "검은바위 나락"
L["Blackrock Foundry"] = "검은바위 용광로"
L["Blackrock Mountain"] = "검은바위 산"
L["Blackrock Spire"] = "검은바위 첨탑"
L["Blackwing Descent"] = "검은날개 강림지"
L["Blackwing Lair"] = "검은날개 둥지"
L["Blasted Lands"] = "저주받은 땅"
L["Bloodmaul Slag Mines"] = "피망치 잿가루 광산"
L["Bloodvenom Post"] = "피멍울초소"
L["Blue"] = "블루"
L["Boat to"] = "연결된 항구:"
L["Booty Bay"] = "무법항"
L["Brackenwall Village"] = "담쟁이 마을"
L["Burning Steppes"] = "불타는 평원"
L["Camp Mojache"] = "모자케 야영지"
L["Camp Taurajo"] = "타우라조 야영지"
L["Caverns of Time"] = "시간의 동굴"
L["Cenarion Hold"] = "세나리온 요새"
L["Central Mesa"] = "중앙 봉우리"
L["Chillwind Camp"] = "서리바람 야영지"
L["Class colored icons"] = "직업색상 아이콘"
L["Class Colored Icons"] = "직업색상 아이콘"
L["Classic"] = "클래식"
L["Click to configure the settings for this option."] = "이 옵션의 설정을 구성하려면 클릭하십시오."
L["Click to reset the position and scale of the map frame."] = "지도 프레임의 위치와 크기를 재설정하려면 클릭하십시오."
L["Click to reset the settings on this page."] = "이 페이지의 설정을 재설정하려면 클릭하십시오."
L["Click to return to the main menu."] = "클릭하면 주 메뉴로 돌아갑니다."
L["Coilfang Reservoir"] = "갈퀴 송곳니 저수지"
L["Configuration Panel"] = "설정창"
L["Culling of Stratholme"] = "옛 스트라솔름"
L["Cursor"] = "커서"
L["Darkshire"] = "어둠골"
L["Darkshore"] = "어둠해안"
L["Darnassus"] = "다르나서스"
L["Deadwind Pass"] = "죽음의 고개"
L["Desolace"] = "잊혀진 땅"
L["Dire Maul"] = "혈투의 전장"
L["Dire Maul (East)"] = "혈투의 전장(1동쪽)"
L["Dire Maul (North)"] = "혈투의 전장(2북쪽)"
L["Dire Maul (West)"] = "혈투의 전장(3서쪽)"
L["Dire Maul: Capital Gardens"] = "혈투의 전장:수도정원"
L["Dire Maul: Gordok Commons"] = "혈투의 전장:고르독 광장"
L["Dire Maul: Warpwood Quarter"] = "혈투의 전장:굽이나무 지구"
L["Disable reading emote when opening the map"] = "지도 볼때 감정표현(모션) 사용안함"
L["Drag"] = "이동"
L["Drag to set the amount of blue."] = "블루 색상을 드레그 설정 하세요."
L["Drag to set the amount of green."] = "그린 색상을 드레그 설정 하세요."
L["Drag to set the amount of red."] = "레드 색상을 드레그 설정 하세요."
L["Drag to set the group icon size."] = "그룹 아이콘 크기를 설정하려면 드래그하십시오."
L["Drag to set the map opacity for when your character is moving."] = "캐릭터가 움직일 때의 맵 불투명도를 드레그 설정하세요."
L["Drag to set the map opacity for when your character is stationary."] = "캐릭터가 정지되어있을 때의 맵 불투명도를 설정하십시오."
L["Drag to set the opacity."] = "불투명도를 드레그 설정하세요."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "드래그하여 플레이어 화살표 크기를 설정합니다. Wow Classic 기본값:16. Wow Retail 기본값: 27."
L["Dragon Soul"] = "용의 영혼"
L["Drak'Tharon Keep"] = "드락타론 성채"
L["Druid only flight point to Darnassus"] = "드루이드 전용 비행지점"
L["Druid only flight point to Thunder Bluff"] = "드루이드 전용 비행지점"
L["Dun Morogh"] = "던 모르"
L["Dungeon"] = "던전"
L["Durotar"] = "듀로타"
L["Duskwood"] = "그늘숲"
L["Dustwallow Marsh"] = "먼지진흙 습지대"
L["Dwarven District"] = "드워프 지구"
L["Eastern Plaguelands"] = "동부 역병지대"
L["Elements"] = "저거"
L["Elwynn Forest"] = "엘원 숲"
L["End Time"] = "시간의 끝"
L["Enlarge player arrow"] = "플레이어 화살표 크게"
L["Enlarge Player Arrow"] = "플레이어 화살표 확대"
L["Enter"] = "Enter"
L["Eternal Guardian"] = "영원의 수호자"
L["Everlook"] = "눈망루 마을"
L["Evermoon Terrace"] = "영원달 정원"
L["Eye of Azshara"] = "아즈샤라의 눈"
L["Falanaar"] = "팔라나아르"
L["Feathermoon Stronghold"] = "페더문 요새"
L["Felsoul Hold"] = "지옥영혼 요새"
L["Felwood"] = "악령의 숲"
L["Feralas"] = "페랄라스"
L["Firelands"] = "불의 땅"
L["Fishing"] = "낚시"
L["Flame Crest"] = "화염 마루"
L["Freewind Post"] = "늪새바람 봉우리"
L["Gadgetzan"] = "가젯잔"
L["Gate of the Setting Sun"] = "석양문"
L["Gnomeregan"] = "놈리건"
L["Green"] = "그린"
L["Grim Batol"] = "그림 바톨"
L["Grimrail Depot"] = "파멸철로 정비소"
L["Grom'gol Base Camp"] = "그룸골 주둔지"
L["Group Icons"] = "그룹 아이콘"
L["Gruul's Lair"] = "그룰의 둥지"
L["Gundrak"] = "군드락"
L["Gundrak (rear entrance)"] = "군드락(후문)"
L["Halls of Lightning"] = "번개의 전당"
L["Halls of Origination"] = "시초의 전당"
L["Halls of Stone"] = "돌의 전당"
L["Halls of Valor"] = "용맹의 전당"
L["Hammerfall"] = "해머폴"
L["Heart of Fear"] = "공포의 심장"
L["Hellfire Citadel"] = "지옥불 성채"
L["Hellfire Ramparts"] = "지옥불 성루"
L["Hide town and city icons"] = "도시와 타운 아이콘 숨김"
L["Highmaul"] = "높은 망치"
L["Hillsbrad Foothills"] = "힐스브래드 구릉지"
L["Hour of Twilight"] = "황혼의 시간"
L["Hyjal Summit"] = "하이잘 정상"
L["Icecrown"] = "얼음왕관"
L["Icecrown Citadel"] = "얼음왕관 성채"
L["Icons"] = "아이콘"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "여객 항구, 비행선 타워 및 지하철역이 표시됩니다."
L["If checked, coordinates will be shown."] = "좌표가 표시됩니다."
L["If checked, dungeons and raids will be shown."] = "던전과 공격대가 표시됩니다."
L["If checked, flight points will be shown."] = "비행 지점이 표시 됩니다."
L["If checked, group icons will use a modern, class-colored design."] = "그룹 아이콘은 현대적인 직업색상 디자인을 사용합니다."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "지도를 열면 지도영역이 변경되지 않은 한 마지막으로 닫을 때와 동일한 확대 / 축소 수준이 사용됩니다."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "캐릭터가 움직이는 동안 지도를 가리키면 불투명 적용되지 않습니다."
L["If checked, points of interest will be shown."] = "주요지점이 표시됩니다."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will prevent you from unlocking the map or removing the map border."] = "기본 전체 세계지도가 사용됩니다.이 옵션을 사용시 지도를 잠금 해제하거나 지도 테두리를 제거 할 수 없습니다."
L["If checked, the map border will be removed."] = "지도 테두리가 제거됩니다."
L["If checked, the minimap button will be shown."] = "미니 맵 버튼이 표시됩니다."
L["If checked, the minimum fishing skill levels will be shown."] = "최소 낚시 숙련도가 표시됩니다."
L["If checked, town and city icons will not be shown on the continent maps."] = "도시와 타운 아이콘은 대륙지도에 표시되지 않습니다."
L["If checked, unexplored areas of the map will be shown."] = "미 탐색 영역이 표시됩니다."
L["If checked, unexplored areas will be tinted."] = "미탐험 지역의 색상을 설정합니다."
L["If checked, you will be able to enlarge the player arrow."] = "플레이어 화살표를 확대 할 수 있습니다."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges.  If you have removed the map border, a drag button will be shown in the top-left corner."] = "지도의 크기를 조정하고 이동할 수 있습니다. 오른쪽 하단 모서리에있는 배율 조정 핸들을 드래그하여 지도의 크기을 조정합니다. 테두리와 프레임 가장자리를 드래그하여 지도를 이동합니다. 지도 테두리를 제거한 경우 왼쪽 상단에 이동 버튼이 표시됩니다."
L["If checked, you will be able to set the opacity of the map."] = "지도의 불투명도를 설정할 수 있습니다."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "지역, 던전 및 낚시 레벨이 표시됩니다."
L["Invalid command.  Enter /ltm help for help."] = "잘못된 명령입니다.도움말을 확인하세요. /ltm help"
L["Iron Docks"] = "강철 선착장"
L["Ironforge"] = "아이언포지"
L["Karazhan"] = "카라잔"
L["Kargath"] = "카르가스"
L["Lake Elune'ara"] = "엘룬아라 호수"
L["Lake Everstill"] = "영원의 호수"
L["Large Scarab Coffer"] = "큰 스카라베 상자"
L["Light's Hope Chapel"] = "희망의 빛 예배당"
L["Lion's Watch"] = "사자의 감시터"
L["Loch Modan"] = "모단 호수"
L["Lost City of the Tol'vir"] = "토비르의 잃어버린 도시"
L["Lower Blackrock Spire"] = "검은바위 첨탑 하층"
L["Lower Wilds"] = "낮은벌"
L["Lunastre Estate"] = "루나스트르 장원"
L["Magisters' Terrace"] = "마법학자의 정원"
L["Magtheridon's Lair"] = "마그테리돈의 둥지"
L["Mana-Tombs"] = "마나 무덤"
L["Map frame scale"] = "지도 크기 변경"
L["Maraudon"] = "마라우돈"
L["Maraudon: Earth Song Falls"] = "마라우돈:대지노래 폭포"
L["Maraudon: Foulspore Cavern"] = "마라우돈:썩은포자 동굴"
L["Maraudon: The Wicked Grotto"] = "마라우돈:악의 동굴"
L["Marshal's Refuge"] = "마샬 야영지"
L["Mechanics"] = "이거"
L["Memory Usage"] = "메모리 사용량"
L["Menethil Harbor"] = "메네실 항구"
L["Miscellaneous"] = "기타"
L["Mogu'shan Palace"] = "모구샨 궁전"
L["Mogu'shan Vaults"] = "모구샨 금고"
L["Molten Core"] = "화산 심장부"
L["Moon Guard Stronghold"] = "달빛 수호자 성채"
L["Moonglade"] = "달의 숲"
L["Morgan's Vigil"] = "모건의 망루"
L["Mount Hyjal"] = "하이잘 산"
L["Moving"] = "이동할 때"
L["Mulgore"] = "멀고어"
L["Naxxramas"] = "낙스라마스"
L["Nethergarde Keep"] = "네더가드 요새"
L["Nighthaven"] = "나이트헤이븐"
L["Nijel's Point"] = "나이젤의 야영지"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "주의!|nLeatrix Maps 이 버전을 적용하려면 게임 클라이언트를 다시 시작해야합니다."
L["Old Hillsbrad Foothills"] = "옛 언덕마루 구릉지"
L["Onyxia's Lair"] = "오닉시아의 둥지"
L["Opacity"] = "불투명"
L["or click the minimap button to open Leatrix Maps."] = "미니맵 버튼을 클릭하여 Leatrix Maps를 엽니다."
L["Orgrimmar"] = "오그리마"
L["Player"] = "플레이어"
L["Player Arrow"] = "플레이어 화살표"
L["Portal"] = "차원문"
L["Portal from Zephyr"] = "제피르의 포탈"
L["Preview"] = "미리보기"
L["Ragefire Chasm"] = "성난불길 협곡"
L["Raid"] = "공격대"
L["Ratchet"] = "톱니항"
L["Razorfen Downs"] = "가시덩굴 구릉"
L["Razorfen Kraul"] = "가시덩굴 우리"
L["Red"] = "레드"
L["Redridge Mountains"] = "붉은마루 산맥"
L["Refuge Pointe"] = "임시주둔지"
L["Reload"] = "리로드"
L["Remember zoom level"] = "확대/축소 기억"
L["Remove map border"] = "지도 테두리 제거"
L["Requires UI reload."] = "UI를 리로드 해야합니다."
L["Reset"] = "리셋"
L["Reset Map Layout"] = "지도 레이아웃 초기화"
L["Return to Karazhan"] = "다시 찾은 카라잔"
L["Revantusk Village"] = "레반터스크 마을"
L["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허"
L["Ruins of Elune'eth"] = "엘룬에스의 페허"
L["Rut'theran Village"] = "루테란 마을"
L["Sanctum of Order"] = "질서의 성소"
L["Scale"] = "크기"
L["Scarlet Halls"] = "붉은십자군 전당"
L["Scarlet Monastery"] = "붉은십자군 수도원"
L["Scholomance"] = "스칼로맨스"
L["Searing Gorge"] = "이글거리는 협곡"
L["Sentinel Hill"] = "감시의 언덕"
L["Serpentshrine Cavern"] = "불뱀 제단"
L["Set map opacity"] = "지도 불투명도 설정"
L["Set Map Opacity"] = "지도 불투명도 설정"
L["Set map opacity while stationary and while moving."] = "플레이어가 맵을 열고 이동할때와 고정일때의 맵 불투명도를 설정합니다."
L["Set the group icon size."] = "그룹아이콘 크기 설정"
L["Set the player arrow size."] = "플레이어 화살표 크기를 설정하십시오."
L["Sethekk Halls"] = "세데크 전당"
L["Settings"] = "설정"
L["Shado-Pan Monastery"] = "음영파 수도원"
L["Shadow Labyrinth"] = "어둠의 미궁"
L["Shadowfang Keep"] = "그림자송곳니 성채"
L["Shadowmoon Burial Grounds"] = "어둠달 지하묘지"
L["Shadowprey Village"] = "그늘수렵 마을"
L["Shal'Aran"] = "샬아란"
L["Show boats, zeppelins and trams"] = "여객선,비행선,지하철 표시"
L["Show coordinates"] = "좌표 표시"
L["Show dungeons and raids"] = "던전 및 공격대 표시"
L["Show flight points"] = "비행 지점 표시"
L["Show minimap button"] = "미니맵 버튼 표시"
L["Show minimap travel"] = "여행 지점 미니맵 표시"
L["Show minimum fishing skill levels"] = "최소 낚시 숙련도 표시"
L["Show points of interest"] = "주요 지점 표시"
L["Show Points Of Interest"] = "주요 지점 표시"
L["Show scale handle"] = "크기 설정 표시"
L["Show travel points"] = "여행 지점 표시"
L["Show unexplored areas"] = "미탐험 지역 표시"
L["Show Unexplored Areas"] = "미탐험 지역 표시"
L["Show zone levels"] = "지역 레벨 표시"
L["Show Zone Levels"] = "지역레벨 표시"
L["Siege of Niuzao Temple"] = "니우짜오 사원 공성전투"
L["Siege of Orgrimmar"] = "오그리마 공성전"
L["Silithus"] = "실리더스"
L["Silverpine Forest"] = "은빛소나무 숲"
L["Skyreach"] = "하늘탑"
L["Slave Pens"] = "강제 노역소"
L["Southshore"] = "사우스쇼어"
L["Splintertree Post"] = "토막나무 주둔지"
L["Stationary"] = "움직이지 않을 때"
L["Steamvault"] = "증기 저장고"
L["Stonard"] = "스토나드"
L["Stonetalon Mountains"] = "돌발톱 산맥"
L["Stonetalon Peak"] = "돌발톱 봉우리"
L["Stormstout Brewery"] = "스톰스타우트 양조장"
L["Stormwind"] = "스톰윈드"
L["Stranglethorn Vale"] = "가시덤불 골짜기"
L["Stratholme (Main Gate)"] = "스트라솔름(정문)"
L["Stratholme (Service Gate)"] = "스트라솔름(후문)"
L["Sun Rock Retreat"] = "해바위 야영지"
L["Sunwell Plateau"] = "태양샘 고원"
L["Swamp of Sorrows"] = "슬픔의 늪"
L["Talonbranch Glade"] = "바람속삭임 숲"
L["Talrendis Point"] = "탈렌디스 초소"
L["Tanaris"] = "타나리스"
L["Tarren Mill"] = "타렌 밀농장"
L["Tel'anor"] = "텔아노르"
L["Teldrassil"] = "텔드랏실"
L["Tempest Keep"] = "폭풍우 요새"
L["Temple of Ahn'Qiraj"] = "안퀴라즈"
L["Temple of Atal'Hakkar"] = "아탈학카르 신전"
L["Temple of the Jade Serpent"] = "옥룡사"
L["Terrace of Endless Spring"] = "영원한 봄의 정원"
L["The Arcatraz"] = "알카트라즈"
L["The Barrens"] = "불모의 땅"
L["The Bastion of Twilight"] = "황혼의 요새"
L["The Black Morass"] = "검은늪"
L["The Blood Furnace"] = "피의 용광로"
L["The Botanica"] = "신록의 정원"
L["The Crossroads"] = "크로스로드"
L["The Culling of Stratholme"] = "옛 스트라솔름"
L["The Deadmines"] = "죽음의 폐광"
L["The Dragon Soul"] = "용의 영혼"
L["The Everbloom"] = "상록숲"
L["The Eye"] = "폭풍우 요새"
L["The Eye of Eternity"] = "영원의 눈"
L["The Forge of Souls"] = "영혼의 제련소"
L["The Forgotten Coast"] = "잊혀진 해안"
L["The Frozen Halls"] = "얼어붙은 전당"
L["The Great Forge"] = "대용광로"
L["The Halls of Reflection"] = "투영의 전당"
L["The Hinterlands"] = "동부내륙지"
L["The Mechanar"] = "메카나르"
L["The Nexus"] = "마력의 탑"
L["The Obsidian Sanctum"] = "흑요석 성소"
L["The Oculus"] = "마력의 눈"
L["The Old Kingdom"] = "고대 왕국"
L["The Pit of Saron"] = "사론의 구덩이"
L["The Ruby Sanctum"] = "루비 성소"
L["The Sepulcher"] = "공동묘지"
L["The Shattered Halls"] = "으스러진 손의 전당"
L["The Stockade"] = "지하감옥"
L["The Stonecore"] = "바위심장부"
L["The Violet Hold"] = "보랏빛 요새"
L["The Vortex Pinnacle"] = "소용돌이 누각"
L["The Waning Crescent"] = "기우는 초승달"
L["Thelsamar"] = "텔사마"
L["Theramore Isle"] = "테라모어"
L["Thorium Point"] = "토륨거점"
L["Thousand Needles"] = "버섯구름 봉우리"
L["Throne of the Four Winds"] = "네 바람의 왕좌"
L["Throne of the Tides"] = "파도의 왕좌"
L["Throne of Thunder"] = "천둥의 왕좌"
L["Thunder Bluff"] = "썬더 블러프"
L["Tinker Town"] = "땜장이 마을"
L["Tint unexplored areas"] = "미탐험지역 색상"
L["Tirisfal Glades"] = "티리스팔 숲"
L["Tomb of Sargeras"] = "살게라스의 무덤"
L["Trade District"] = "상업지구"
L["Trade Quarter"] = "상업지구"
L["Tram to"] = "지하철(다음역) "
L["Transparency"] = "투명도"
L["Trial of the Champion"] = "용사의 시험장"
L["Trial of the Crusader"] = "십자군의 시험장"
L["Twilight Vineyards"] = "황혼의 포도원"
L["Uldaman"] = "울다만"
L["Ulduar"] = "울두아르"
L["Underbog"] = "지하수렁"
L["Undercity"] = "언더시티"
L["Un'Goro Crater"] = "운고로 분화구"
L["Unlock map frame"] = "세계지도 잠금해제"
L["Upper Blackrock Spire"] = "검은바위 첨탑 상층"
L["Use default map"] = "기본 지도 사용"
L["Use stationary opacity while pointing at map"] = "지도를 가리키는 동안 불투명도 사용 안함"
L["Utgarde Keep"] = "우트가드 성채"
L["Utgarde Pinnacle"] = "우트가드 첨탑"
L["Valley of Strength"] = "힘의 골짜기"
L["Valormok"] = "발로르모크"
L["Vault of Archavon"] = "아카본 석실"
L["Version"] = "버전"
L["Vol'mar"] = "볼마르"
L["Wailing Caverns"] = "통곡의 동굴"
L["Well of Eternity"] = "영원의 샘"
L["Western Plaguelands"] = "서부 역병지대"
L["Westfall"] = "서부 몰락지대"
L["Wetlands"] = "저습지"
L["Winterspring"] = "여명의 설원"
L["Wyrmrest Temple"] = "고룡쉼터 사원"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "일부 변경 사항을(*) 적용하려면 UI를 리로드 해야합니다."
L["Your UI needs to be reloaded."] = "UI를 리로드 해야 합니다."
L["Zeppelin to"] = "연결된 비행선 지점:"
L["Zoram'gar Outpost"] = "조람가르 전초기지"
L["Zul'Aman"] = "줄아만"
L["Zul'Farrak"] = "줄파락"
L["Zul'Gurub"] = "줄구룹"

end

-- deDE: German
if GameLocale == "deDE" then
L["/ltm help - Show this information."] = "/ltm help - Informationen anzeigen."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Panelposition Zurücksetzen."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - ALLE Einstellungen zurücksetzen und Interface neu laden."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Ein Stopp-Fehler ist aufgetreten aber keine Sorge.  Das kann von Zeit zu Zeit passieren.  Klicke auf den Reload Button und das Problem sollte behoben sein."
L["Aerie Peak"] = "Nistgipfel"
L["Alpha"] = "Alpha"
L["Alterac Mountains"] = "Alteracgebirge"
L["Arathi Highlands"] = "Arathihochland"
L["Ashenvale"] = "Eschental"
L["Astranaar"] = "Astranaar"
L["Astravar Harbor"] = "Hafen der Astravar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Auchenaikrypta"
L["Auchindoun"] = "Auchindoun"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Zurück zum Hauptmenü"
L["Badlands"] = "Ödland"
L["Baradin Hold"] = "Baradinfestung"
L["Black Morass"] = "Der schwarze Morast"
L["Black Temple"] = "Der schwarze Tempel"
L["Blackfathom Deeps"] = "Die Tiefschwarze Grotte"
L["Blackrock Caverns"] = "Schwarzfelshöhlen"
L["Blackrock Depths"] = "Blackrocktiefen"
L["Blackrock Foundry"] = "Schwarzfelsgießerei"
L["Blackrock Mountain"] = "Der Blackrock"
L["Blackrock Spire"] = "Schwarzfelsspitze"
L["Blackwing Descent"] = "Pechschwingenabstieg"
L["Blackwing Lair"] = "Pechschwingenhort"
L["Blasted Lands"] = "Verwüstete Lande"
L["Bloodmaul Slag Mines"] = "Blutschlägermine"
L["Bloodvenom Post"] = "Blutgiftposten"
L["Blue"] = "Blau"
L["Boat to"] = "Boot nach"
L["Booty Bay"] = "Booty Bay"
L["Brackenwall Village"] = "Brackenwall"
L["Burning Steppes"] = "Die Brennende Steppe"
L["Camp Mojache"] = "Camp Mojache"
L["Camp Taurajo"] = "Camp Taurajo"
L["Caverns of Time"] = "Höhlen der Zeit"
L["Cenarion Hold"] = "Burg Cenarius"
L["Central Mesa"] = "Die große Anhöhe"
L["Chillwind Camp"] = "Chillwind Lager"
L["Class colored icons"] = "Symbole in Klassenfarbe"
L["Class Colored Icons"] = "Icons in Klassenfarbe"
L["Classic"] = "Classic"
L["Click to configure the settings for this option."] = "Klicken um die Einstellung dieser Option zu verändern."
L["Click to reset the position and scale of the map frame."] = "Klicken zum zurücksetzen der Position und Größe des Weltkartenfensters."
L["Click to reset the settings on this page."] = "Klicken zum zurücksetzen der Einstellungen dieses Fensters."
L["Click to return to the main menu."] = "Klicken um zurück ins Hauptmenü zu gelangen."
L["Coilfang Reservoir"] = "Der Echsenkessel"
L["Configuration Panel"] = "Einstellungsfenster"
L["Culling of Stratholme"] = "Das Ausmerzen von Stratholme"
L["Cursor"] = "Cursor"
L["Darkshire"] = "Dämmerwald"
L["Darkshore"] = "Dunkelküste"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Gebirgspass der Totenwinde"
L["Desolace"] = "Desolace"
L["Dire Maul"] = "Düsterbruch"
L["Dire Maul (East)"] = "Düsterbruch (Ost)"
L["Dire Maul (North)"] = "Düsterbruch (Nord)"
L["Dire Maul (West)"] = "Düsterbruch (West)"
L["Dire Maul: Capital Gardens"] = "Düsterbruch: Hauptstadtgärten"
L["Dire Maul: Gordok Commons"] = "Düsterbruch: Gordokhallen"
L["Dire Maul: Warpwood Quarter"] = "Düsterbruch: Wucherborkenviertel"
L["Disable reading emote when opening the map"] = "Deaktiviert die Leseanimation wenn die Weltkarte geöffnet wird"
L["Drag"] = "Verschieben"
L["Drag to set the amount of blue."] = "Verschiebe den Regler für die Menge an blau."
L["Drag to set the amount of green."] = "Verschiebe den Regler für die Menge an grün."
L["Drag to set the amount of red."] = "Verschiebe den Regler für die Menge an rot."
L["Drag to set the group icon size."] = "Ziehen zum ändern der Gruppenicongröße"
L["Drag to set the map opacity for when your character is moving."] = "Verschiebe den Regler für die Transparenz der Weltkarte wenn sich dein Charakter bewegt."
L["Drag to set the map opacity for when your character is stationary."] = "Verschiebe den Regler für die Transparenz der Weltkarte wenn dein Charakter steht."
L["Drag to set the opacity."] = "Verschiebe den Regler für die Transparenz."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Verschieben um die Größe des Spielerpfeils einzustellen.|n|nWoW Classic größe ist 16.|nWoW Live größe ist 27."
L["Dragon Soul"] = "Drachenseele"
L["Drak'Tharon Keep"] = "Drak'Tharon Keep"
L["Druid only flight point to Darnassus"] = "Flugpunkt nach Darnassus, nur für Druiden"
L["Druid only flight point to Thunder Bluff"] = "Flugpunkt nach Thunder Bluff, nur für Druiden"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeon"] = "Instanz"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Dämmerwald"
L["Dustwallow Marsh"] = "Marschen von Dustwallow"
L["Dwarven District"] = "Der Zwergendistrikt"
L["Eastern Plaguelands"] = "Östliche Pestländer"
L["Elements"] = "Elemente"
L["Elwynn Forest"] = "Wald von Elwynn"
L["End Time"] = "Die Endzeit"
L["Enlarge player arrow"] = "Vergrößerter spielerpfeil"
L["Enlarge Player Arrow"] = "Vergrößerter Spielerpfeil"
L["Enter"] = "Enter"
L["Eternal Guardian"] = "Ewiger Wächter"
L["Everlook"] = "Everlook"
L["Evermoon Terrace"] = "Die Immermondterrasse"
L["Eye of Azshara"] = "Das Auge Azsharas"
L["Falanaar"] = "Falanaar"
L["Feathermoon Stronghold"] = "Mondfederfeste"
L["Felsoul Hold"] = "Die Teufelsseelen Bastion"
L["Felwood"] = "Teufelswald"
L["Feralas"] = "Feralas"
L["Firelands"] = "Feuerlande"
L["Fishing"] = "Fischen"
L["Flame Crest"] = "Flammenkamm"
L["Freewind Post"] = "Freiwindposten"
L["Gadgetzan"] = "Gadgetzan"
L["Gate of the Setting Sun"] = "Das Tor der Untergehenden Sonne"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Grün"
L["Grim Batol"] = "Grim Batol"
L["Grimrail Depot"] = "Grimmgleisdepot"
L["Grom'gol Base Camp"] = "Basislager von Grom'gol"
L["Group Icons"] = "Gruppenicons"
L["Gruul's Lair"] = "Gruuls Unterschlupf"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (Hintereingang)"
L["Halls of Lightning"] = "Die Halle des Lichts"
L["Halls of Origination"] = "Die Hallen des Ursprungs"
L["Halls of Stone"] = "Die Hallen des Steins"
L["Halls of Valor"] = "Die Hallen der Tapferkeit"
L["Hammerfall"] = "Hammerfall"
L["Heart of Fear"] = "Das Herz der Angst"
L["Hellfire Citadel"] = "Höllenfeuerzitadelle"
L["Hellfire Ramparts"] = "Höllenfeuerbollwerk"
L["Hide town and city icons"] = "Verstecke Stadticons"
L["Highmaul"] = "Hochfels"
L["Hillsbrad Foothills"] = "Vorgebirge von Hillsbrad"
L["Hour of Twilight"] = "Stunde des Zwielichts"
L["Hyjal Summit"] = "Hyjalgipfel"
L["Icecrown"] = "Eiskrone"
L["Icecrown Citadel"] = "Die Eiskronenzitadelle"
L["Icons"] = "Symbole"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Zeigt Schiffsanlegestellen, Zeppelintürme und Bahnstationen an wenn aktiviert."
L["If checked, coordinates will be shown."] = "Zeigt die Koordinaten an wenn aktiviert."
L["If checked, dungeons and raids will be shown."] = "Zeigt Instanz- und Schlachtzugseingänge an wenn aktiviert."
L["If checked, flight points will be shown."] = "Zeigt Flugpunkte an wenn aktiviert."
L["If checked, group icons will use a modern, class-colored design."] = "Gruppensymbole nutzen das moderne und, nach Klassenfarben, eingefärbte Aussehen wenn aktiviert."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Wenn aktiviert, öffnet sich die Weltkarte mit der selben Zoomstufe mit der Du sie zuletzt verlassen hast. Funktioniert nur solange Du nicht die Zone wechselst."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Nutzt die Transparenzeinstellung aus der 'Stehend' voreinstellung sobald sich euer Mauszeiger auf der Weltkarte befindet wenn aktiviert."
L["If checked, points of interest will be shown."] = "POI - interessante Punkte werden auf der Weltkarte mit Symbolen dargestellt wenn aktiviert."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will prevent you from unlocking the map or removing the map border."] = "Die standard Vollbildkarte wird benutzt wenn aktiviert.|n|nHinweis: Das aktivieren dieser Funktion verhindert die Anpassung der Größe und Position sowie das entfernen des Randes der Weltkarte."
L["If checked, the map border will be removed."] = "Der Fensterrand der Weltkarte wird entfernt wenn aktiviert."
L["If checked, the minimap button will be shown."] = "Zeigt den Button an der Minikarte wenn aktiviert."
L["If checked, the minimum fishing skill levels will be shown."] = "Zeigt die benötigte Angelfertigkeit des Gebietes an wenn aktiviert."
L["If checked, town and city icons will not be shown on the continent maps."] = " Stadtsymbole werden nicht gezeigt wenn aktiviert."
L["If checked, unexplored areas of the map will be shown."] = "Zeigt unentdeckte Gebiete auf der Weltkarte wenn aktiviert."
L["If checked, unexplored areas will be tinted."] = "Färbt die unentdeckten Gebiete auf der Weltkarte ein wenn aktiviert"
L["If checked, you will be able to enlarge the player arrow."] = "Ermöglicht die Anpassug der Größe des Spielerpfeils wenn aktiviert."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges.  If you have removed the map border, a drag button will be shown in the top-left corner."] = "Ermöglicht das Verschieben und die Anpassung der Größe der Weltkarte wenn aktiviert.|n|nÄndere die Größe der Weltkarte indem Du den Anker in der rechten unteren Ecke, mit gedrückter Maustaste, ziehst.|n|nBewege die Weltkarte indem Du sie an den Rändern, mit gedrückter Maustaste, ziehst.  Hast Du den Rand ausgeblendet erscheint eine Schaltfläche zum Verschieben oben links."
L["If checked, you will be able to set the opacity of the map."] = "Ermöglicht die Transparenz der Weltkarte einzustellen wenn aktiviert."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Zeigt den Levelbereich für Zonen, Instanzen und Angelfertigkeiten an wenn aktiviert."
L["Invalid command.  Enter /ltm help for help."] = "Unbekannter Befehl.  Schreibe  /ltm help  für weitere Befehle und hilfe."
L["Iron Docks"] = "Eisendocks"
L["Ironforge"] = "Ironforge"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Lake Elune'ara"] = "See von Elune'ara"
L["Lake Everstill"] = "Der Immerruhsee"
L["Large Scarab Coffer"] = "Großer Skarabäuskasten"
L["Light's Hope Chapel"] = "Kapelle des Hoffnungsvollen Lichts"
L["Lion's Watch"] = "Löwenwacht"
L["Loch Modan"] = "Loch Modan"
L["Lost City of the Tol'vir"] = "Die Verlorene Stadt der Tol'vir"
L["Lower Blackrock Spire"] = "Untere Blackrockspitze"
L["Lower Wilds"] = "Die untere Wildnis"
L["Lunastre Estate"] = "Das Anwesen der Lunastres"
L["Magisters' Terrace"] = "Terrasse der Magister"
L["Magtheridon's Lair"] = "Magtheridons Kammer"
L["Mana-Tombs"] = "Managruft"
L["Map frame scale"] = "Kartenrandgröße"
L["Maraudon"] = "Maraudon"
L["Maraudon: Earth Song Falls"] = "Maraudon: Die Fälle des irdenen Gesangs"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Die Faulsporenhöhle"
L["Maraudon: The Wicked Grotto"] = "Maraudon: Die tückische Grotte"
L["Marshal's Refuge"] = "Marschalls Zuflucht"
L["Mechanics"] = "Funktionen"
L["Memory Usage"] = "Speicherauslastung"
L["Menethil Harbor"] = "Hafen von Menethil"
L["Miscellaneous"] = "Sonstiger"
L["Mogu'shan Palace"] = "Mogu'shanpalast"
L["Mogu'shan Vaults"] = "Mogu'shangewölbe"
L["Molten Core"] = "Geschmolzener Kern"
L["Moon Guard Stronghold"] = "Die Mondwachenfestung"
L["Moonglade"] = "Moonglade"
L["Morgan's Vigil"] = "Morgans Wacht"
L["Mount Hyjal"] = "Berg Hyjal"
L["Moving"] = "In Bewegung"
L["Mulgore"] = "Mulgore"
L["Naxxramas"] = "Naxxramas"
L["Nethergarde Keep"] = "Burg Nethergarde"
L["Nighthaven"] = "Nachthafen"
L["Nijel's Point"] = "Die Nijelspitze"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "HINWEIS!|nDu musst dein Spiel komplett neu bevor Du diese Version von Leatrix Maps benutzen kannst."
L["Old Hillsbrad Foothills"] = "Vorgebirge des Alten Hügellands"
L["Onyxia's Lair"] = "Onyxias Hort"
L["Opacity"] = "Transparenz"
L["or click the minimap button to open Leatrix Maps."] = "oder klicke auf den Button an der Minikarte."
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Spieler"
L["Player Arrow"] = "Spielerpfeil"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal von Zephyr"
L["Preview"] = "Vorschau"
L["Ragefire Chasm"] = "Ragefireabgrund"
L["Raid"] = "Schlachtzug"
L["Ratchet"] = "Ratchet"
L["Razorfen Downs"] = "Die Hügel von Razorfen"
L["Razorfen Kraul"] = "Der Kral von Razorfen"
L["Red"] = "Rot"
L["Redridge Mountains"] = "Rotkammgebirge"
L["Refuge Pointe"] = "Die Zuflucht"
L["Reload"] = "Neu laden (UI)"
L["Remember zoom level"] = "Zoomstufe merken"
L["Remove map border"] = "Kartenrand entfernen"
L["Requires UI reload."] = "Benötigt UI-Neuladen"
L["Reset"] = "Zurücksetzen"
L["Reset Map Layout"] = "Karte Zurücksetzen"
L["Return to Karazhan"] = "Rückkehr nach Karazhan"
L["Revantusk Village"] = "Dorf der Bruchhauer"
L["Ruins of Ahn'Qiraj"] = "Ruinen von Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinen von Elune'eth"
L["Rut'theran Village"] = "Rut'theran"
L["Sanctum of Order"] = "Sanktum der Ordnung"
L["Scale"] = "Größe"
L["Scarlet Halls"] = "Scharlachrote Hallen"
L["Scarlet Monastery"] = "Das scharlachrote Kloster"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "Sengende Schlucht"
L["Sentinel Hill"] = "Späherkuppe"
L["Serpentshrine Cavern"] = "Höhle des Schlangenschreins"
L["Set map opacity"] = "Kartentransparenz"
L["Set Map Opacity"] = "Kartentransparenz"
L["Set map opacity while stationary and while moving."] = "Einstellung für die Transparenz der Weltkarte beim stehen und bewegen."
L["Set the group icon size."] = "Setzt die Gruppenicongröße"
L["Set the player arrow size."] = "Stellt die Größe des Spielerpfeils ein."
L["Sethekk Halls"] = "Sethekkhallen"
L["Settings"] = "Einstellungen"
L["Shado-Pan Monastery"] = "Shado-Pan Kloster"
L["Shadow Labyrinth"] = "Schattenlabyrinth"
L["Shadowfang Keep"] = "Burg Schattenfang"
L["Shadowmoon Burial Grounds"] = "Schattenmondgrabstätte"
L["Shadowprey Village"] = "Schattenflucht"
L["Shal'Aran"] = "Shal'Aran"
L["Show boats, zeppelins and trams"] = "Schiffe, Zeppeline und Bahnen"
L["Show coordinates"] = "Zeige Koordinaten"
L["Show dungeons and raids"] = "Instanzen und Schlachtzüge"
L["Show flight points"] = "Flugpunkte"
L["Show minimap button"] = "Zeige minikarten button"
L["Show minimap travel"] = "Zeige minikartenreise"
L["Show minimum fishing skill levels"] = "Zeige Angelfertigkeiten"
L["Show points of interest"] = "Zeige POI"
L["Show Points Of Interest"] = "Zeige interessante Punkte (POI)"
L["Show scale handle"] = "Zeige Größenregler"
L["Show travel points"] = "Zeige Reiserouten"
L["Show unexplored areas"] = "Zeige unentdeckte Gebiete"
L["Show Unexplored Areas"] = "Zeige unentdeckte Gebiete"
L["Show zone levels"] = "Zeige Gebietsstufe"
L["Show Zone Levels"] = "Zeige Zonenlevel"
L["Siege of Niuzao Temple"] = "Die Belagerung des Niuzaotempels"
L["Siege of Orgrimmar"] = "Schlacht um Orgrimmar"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Silberwald"
L["Skyreach"] = "Himmelsnadel"
L["Slave Pens"] = "Die Sklavenunterkünfte"
L["Southshore"] = "Süderstade"
L["Splintertree Post"] = "Splitterholzposten"
L["Stationary"] = "Stehend"
L["Steamvault"] = "Die Dampfkammer"
L["Stonard"] = "Steinard"
L["Stonetalon Mountains"] = "Steinkrallengebirge"
L["Stonetalon Peak"] = "Der Steinkrallengipfel"
L["Stormstout Brewery"] = "Brauerei Sturmbräu"
L["Stormwind"] = "Stormwind"
L["Stranglethorn Vale"] = "Schlingendorntal"
L["Stratholme (Main Gate)"] = "Stratholme: Haupttor"
L["Stratholme (Service Gate)"] = "Stratholme: Dienstboteneingang"
L["Sun Rock Retreat"] = "Sonnenfels"
L["Sunwell Plateau"] = "Sonnenbrunnenplateau"
L["Swamp of Sorrows"] = "Sümpfe des Elends"
L["Talonbranch Glade"] = "Nachtlaublichtung"
L["Talrendis Point"] = "Talrendisspitze"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Tarrens Mühle"
L["Tel'anor"] = "Tel'anor"
L["Teldrassil"] = "Teldrassil"
L["Tempest Keep"] = "Festung der Stürme"
L["Temple of Ahn'Qiraj"] = "Tempel von Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Tempel von Atal'Hakkar"
L["Temple of the Jade Serpent"] = "Tempel der Jadeschlange"
L["Terrace of Endless Spring"] = "Terrasse des Endlosen Frühlings"
L["The Arcatraz"] = "Die Arkatraz"
L["The Barrens"] = "Brachland"
L["The Bastion of Twilight"] = "Die Bastion des Zwielichts"
L["The Black Morass"] = "Der Schwarze Morast"
L["The Blood Furnace"] = "Der Blutkessel"
L["The Botanica"] = "Die Botanika"
L["The Crossroads"] = "Crossroads"
L["The Culling of Stratholme"] = "Das Ausmerzen von Stratholme"
L["The Deadmines"] = "Die Todesminen"
L["The Dragon Soul"] = "Drachenseele"
L["The Everbloom"] = "Der Immergrüne Flor"
L["The Eye"] = "Das Auge"
L["The Eye of Eternity"] = "Das Auge der Ewigkeit"
L["The Forge of Souls"] = "Die Seelenschmiede"
L["The Forgotten Coast"] = "Die vergessene Küste"
L["The Frozen Halls"] = "Die gefrorenen Hallen"
L["The Great Forge"] = "Die große Schmiede"
L["The Halls of Reflection"] = "Hallen der Reflexion"
L["The Hinterlands"] = "Hinterland"
L["The Mechanar"] = "Die Mechanar"
L["The Nexus"] = "Der Nexus"
L["The Obsidian Sanctum"] = "Das Obsidiansanktum"
L["The Oculus"] = "Das Oculus"
L["The Old Kingdom"] = "Das Alte Königreich"
L["The Pit of Saron"] = "Die Grube von Saron"
L["The Ruby Sanctum"] = "Das Rubinsanktum"
L["The Sepulcher"] = "Das Grabmal"
L["The Shattered Halls"] = "Die Zerschmetterten Hallen"
L["The Stockade"] = "Das Verlies"
L["The Stonecore"] = "Der Steinerne Kern"
L["The Violet Hold"] = "Die Violette Festung"
L["The Vortex Pinnacle"] = "Der Vortexgipfel"
L["The Waning Crescent"] = "Das Mondsichelforum"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Die Insel Theramore"
L["Thorium Point"] = "Thoriumspitze"
L["Thousand Needles"] = "Tausend Nadeln"
L["Throne of the Four Winds"] = "Thron der Vier Winde"
L["Throne of the Tides"] = "Thron der Gezeiten"
L["Throne of Thunder"] = "Thron des Donners"
L["Thunder Bluff"] = "Thunder Bluff"
L["Tinker Town"] = "Tüftlerstadt"
L["Tint unexplored areas"] = "Färbung unentdeckter Gebiete"
L["Tirisfal Glades"] = "Tirisfal"
L["Tomb of Sargeras"] = "Das Grabmal des Sargeras"
L["Trade District"] = "Der Handelsdistrikt"
L["Trade Quarter"] = "Das Handelsviertel"
L["Tram to"] = "Bahn nach"
L["Transparency"] = "Transparenz"
L["Trial of the Champion"] = "Prüfung des Champions"
L["Trial of the Crusader"] = "Prüfung des Kreuzfahrers"
L["Twilight Vineyards"] = "Die Zwielichtrebgärten"
L["Uldaman"] = "Uldaman"
L["Ulduar"] = "Ulduar"
L["Underbog"] = "Der Tiefensumpf"
L["Undercity"] = "Undercity"
L["Un'Goro Crater"] = "Un'Goro-Krater"
L["Unlock map frame"] = "Löst den Kartenrand"
L["Upper Blackrock Spire"] = "Obere Blackrockspitze"
L["Use default map"] = "Benutzt die standard karte"
L["Use stationary opacity while pointing at map"] = "Nutzt die 'Stehend'-Transparenz wenn euer Mauszeiger auf der Weltkarte ist."
L["Utgarde Keep"] = "Burg Utgarde"
L["Utgarde Pinnacle"] = "Turm Utgarde"
L["Valley of Strength"] = "Tal der Stärke"
L["Valormok"] = "Valormok"
L["Vault of Archavon"] = "Archavons Kammer"
L["Version"] = "Version"
L["Vol'mar"] = "Vol'mar"
L["Wailing Caverns"] = "Die Höhlen des Wehklagens"
L["Well of Eternity"] = "Brunnen der Ewigkeit"
L["Western Plaguelands"] = "Westliche Pestländer"
L["Westfall"] = "Westfall"
L["Wetlands"] = "Sumpfland"
L["Winterspring"] = "Winterquell"
L["Wyrmrest Temple"] = "Wyrmruhtempel"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Deine Benutzeroberfläche (UI) muss neu gestartet werden damit einige Einstellung in kraft treten.|n|nDu musst nicht sofort auf 'Neu laden (UI)' klicken aber am ende deiner Einstellungen solltest Du auf 'Neu laden (UI)' klicken damit alle Einstellungen auch wirksam werden."
L["Your UI needs to be reloaded."] = "UI neu laden."
L["Zeppelin to"] = "Zeppelin nach"
L["Zoram'gar Outpost"] = "Außenposten von Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- esMX: Spanish (Mexico)
if GameLocale == "esMX" then
L["/ltm help - Show this information."] = "/ltm help - Mostrar información."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Restablecer la posición del panel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Limpiar la configuración y recargar."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Se ha producido un error de detención, pero no hay que preocuparse. Puede suceder de vez en cuando. Haga clic en el botón de recarga para resolverlo."
L["Aerie Peak"] = "Pico Nidal"
L["Alpha"] = "Alfa"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Ashenvale"] = "Vallefresno"
L["Astranaar"] = "Astranaar"
L["Astravar Harbor"] = "Puerto de los Astravar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Criptas Auchenai"
L["Auchindoun"] = "Auchindoun"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Volver a menú principal"
L["Badlands"] = "Tierras Inhóspitas"
L["Baradin Hold"] = "Bastión de Baradin"
L["Black Morass"] = "Ciénaga Negra"
L["Black Temple"] = "Templo Oscuro"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Caverns"] = "Cavernas Roca Negra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackrock Foundry"] = "Fundición Roca Negra"
L["Blackrock Mountain"] = "Montaña Roca Negra"
L["Blackrock Spire"] = "Cumbre de Roca Negra"
L["Blackwing Descent"] = "Descenso de Alanegra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Bloodmaul Slag Mines"] = "Minas Machacasangre"
L["Bloodvenom Post"] = "Puesto del Veneno"
L["Blue"] = "Azul"
L["Boat to"] = "Barco a"
L["Booty Bay"] = "Bahía del Botín"
L["Brackenwall Village"] = "Poblado Murohelecho"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Camp Mojache"] = "Campamento Mojache"
L["Camp Taurajo"] = "Campamento Taurajo"
L["Caverns of Time"] = "Cavernas del Tiempo"
L["Cenarion Hold"] = "Fuerte Cenarion"
L["Central Mesa"] = "Meseta Central"
L["Chillwind Camp"] = "Campamento del Orvallo"
L["Class colored icons"] = "Iconos coloreados"
L["Class Colored Icons"] = "Iconos Coloreados por Clase"
L["Classic"] = "Clásico"
L["Click to configure the settings for this option."] = "Haga clic para configurar los ajustes para esta opción."
L["Click to reset the position and scale of the map frame."] = "Haga clic para restablecer la posición y la escala del marco del mapa."
L["Click to reset the settings on this page."] = "Haga clic para restablecer la configuración en esta página."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal."
L["Coilfang Reservoir"] = "Reserva Colmillo Torcido"
L["Configuration Panel"] = "Panel de Configuración"
L["Culling of Stratholme"] = "La Matanza de Stratholme"
L["Cursor"] = "Cursor"
L["Darkshire"] = "Villa Oscura"
L["Darkshore"] = "Costa Oscura"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Desolace"] = "Desolace"
L["Dire Maul"] = "La Masacre"
L["Dire Maul (East)"] = "La Masacre (Este)"
L["Dire Maul (North)"] = "La Masacre (Norte)"
L["Dire Maul (West)"] = "La Masacre (Oeste)"
L["Dire Maul: Capital Gardens"] = "La Masacre: Jardines de la Capital"
L["Dire Maul: Gordok Commons"] = "La Masacre: Ágora de Gordok"
L["Dire Maul: Warpwood Quarter"] = "La Masacre: Barrio Alabeo"
L["Disable reading emote when opening the map"] = "Deshabilita la lectura de emoticones al abrir el mapa"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arrastra para establecer la cantidad de azul."
L["Drag to set the amount of green."] = "Arrastra para establecer la cantidad de verde."
L["Drag to set the amount of red."] = "Arrastra para establecer la cantidad de rojo."
L["Drag to set the group icon size."] = "Arrastra para establecer el tamaño del icono de grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje se esté moviendo."
L["Drag to set the map opacity for when your character is stationary."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje esté estacionario."
L["Drag to set the opacity."] = "Arrastra para establecer la opacidad."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arrastra para establecer el tamaño de la flecha del jugador.|n|nEl valor predeterminado de WoW Classic es 16.|nEl valor predeterminado de WoW Retail es 27."
L["Dragon Soul"] = "Alma de Dragón"
L["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon"
L["Druid only flight point to Darnassus"] = "Punto de vuelo a Darnassus solo para druidas"
L["Druid only flight point to Thunder Bluff"] = "Punto de vuelo a Cima del Trueno solo para druidas"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeon"] = "Mazmorra"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Dwarven District"] = "Distrito de los Enanos"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["Elements"] = "Visibilidad"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["End Time"] = "Fin de los Días"
L["Enlarge player arrow"] = "Flecha de jugador"
L["Enlarge Player Arrow"] = "Flecha de Jugador"
L["Enter"] = "Entrar"
L["Eternal Guardian"] = "Guardián eterno"
L["Everlook"] = "Vista Eterna"
L["Evermoon Terrace"] = "Terraza Lunaeterna"
L["Eye of Azshara"] = "Ojo de Azshara"
L["Falanaar"] = "Falanaar"
L["Feathermoon Stronghold"] = "Bastión Plumaluna"
L["Felsoul Hold"] = "Bastión Alma Vil"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Firelands"] = "Tierras de Fuego"
L["Fishing"] = "Pesca"
L["Flame Crest"] = "Peñasco Llamarada"
L["Freewind Post"] = "Poblado Viento Libre"
L["Gadgetzan"] = "Gadgetzan"
L["Gate of the Setting Sun"] = "Puerta del Sol Poniente"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Verde"
L["Grim Batol"] = "Grim Batol"
L["Grimrail Depot"] = "Terminal Malavía"
L["Grom'gol Base Camp"] = "Campamento Grom'gol"
L["Group Icons"] = "Iconos de grupo"
L["Gruul's Lair"] = "Guarida de Gruul"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (entrada trasera)"
L["Halls of Lightning"] = "Cámaras de Relámpagos"
L["Halls of Origination"] = "Cámaras de los Orígenes"
L["Halls of Stone"] = "Cámaras de Piedra"
L["Halls of Valor"] = "Cámaras del Valor"
L["Hammerfall"] = "Sentencia"
L["Heart of Fear"] = "Corazón del Miedo"
L["Hellfire Citadel"] = "Ciudadela del Fuego Infernal"
L["Hellfire Ramparts"] = "Murallas del Fuego Infernal"
L["Hide town and city icons"] = "Pueblos y ciudades"
L["Highmaul"] = "Gran Magullador"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Hour of Twilight"] = "Hora del Crepúsculo"
L["Hyjal Summit"] = "La Cima Hyjal"
L["Icecrown"] = "Corona de Hielo"
L["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo"
L["Icons"] = "Iconos"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Si está marcado, se mostrarán los puertos de los barcos, las torres de los zepelines y las estaciones de tranvía."
L["If checked, coordinates will be shown."] = "Si está marcado, se mostrarán las coordenadas."
L["If checked, dungeons and raids will be shown."] = "Si está marcado, se mostrarán mazmorras y bandas."
L["If checked, flight points will be shown."] = "Si está marcado, se mostrarán los puntos de vuelo."
L["If checked, group icons will use a modern, class-colored design."] = "Si está marcado, los iconos de grupo usarán un diseño moderno, de color de clase."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si está marcado, al abrir el mapa se usará el mismo nivel de zoom desde la última vez que lo cerró, siempre que la zona del mapa no haya cambiado."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si está marcado, apuntar al mapa mientras tu personaje se mueve hará que se aplique la configuración de opacidad estacionaria."
L["If checked, points of interest will be shown."] = "Si está marcado, se mostrarán puntos de interés."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will prevent you from unlocking the map or removing the map border."] = "Si está marcado, se usará el mapa predeterminado de pantalla completa.|n|nTenga en cuenta que habilitar esta opción le impedirá desbloquear el mapa o eliminar el borde del mapa."
L["If checked, the map border will be removed."] = "Si está marcado, se eliminará el borde del mapa."
L["If checked, the minimap button will be shown."] = "Si está marcado, se mostrará el botón del minimapa."
L["If checked, the minimum fishing skill levels will be shown."] = "Si está marcado, se mostrarán los niveles mínimos de habilidad de pesca."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si está marcado, los iconos de pueblos y ciudades no se mostrarán en los mapas continentes."
L["If checked, unexplored areas of the map will be shown."] = "Si está marcado, se mostrarán áreas inexploradas del mapa."
L["If checked, unexplored areas will be tinted."] = "Si está marcado, las áreas inexploradas se teñirán."
L["If checked, you will be able to enlarge the player arrow."] = "Si está marcado, podrá ampliar la flecha del jugador."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges.  If you have removed the map border, a drag button will be shown in the top-left corner."] = "Si está marcado, podrá escalar y mover el mapa.|n|nEscale el mapa arrastrando el controlador de escala en la esquina inferior derecha.|n|nMueva el mapa arrastrando el borde y los bordes del marco. Si ha eliminado el borde del mapa, se mostrará un botón de arrastre en la esquina superior izquierda."
L["If checked, you will be able to set the opacity of the map."] = "Si está marcado, podrá establecer la opacidad del mapa."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si está marcado, se mostrarán los niveles de zona, mazmorra y hablidad de pesca."
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Escribe / ltm help para obtener ayuda."
L["Iron Docks"] = "Puerto de Hierro"
L["Ironforge"] = "Forjaz"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Lake Elune'ara"] = "Lago Elune'ara"
L["Lake Everstill"] = "Lago Sempiterno"
L["Large Scarab Coffer"] = "Arca del escarabajo grande"
L["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz"
L["Lion's Watch"] = "Avanzada del León"
L["Loch Modan"] = "Loch Modan"
L["Lost City of the Tol'vir"] = "Ciudad Perdida de los Tol'vir"
L["Lower Blackrock Spire"] = "Cumbre de Roca Negra Inferior"
L["Lower Wilds"] = "Thalanaar"
L["Lunastre Estate"] = "Finca de Lunastre"
L["Magisters' Terrace"] = "Bancal del Magister"
L["Magtheridon's Lair"] = "Guarida de Magtheridon"
L["Mana-Tombs"] = "Tumbas de Maná"
L["Map frame scale"] = "Escala del marco del mapa"
L["Maraudon"] = "Maraudon"
L["Maraudon: Earth Song Falls"] = "Maraudon: Cascadas del Canto de la Tierra"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Gruta de la Espora Fétida"
L["Maraudon: The Wicked Grotto"] = "Maraudon: La Gruta Maldita"
L["Marshal's Refuge"] = "Refugio de Marshal"
L["Mechanics"] = "Mecánicas"
L["Memory Usage"] = "Uso de memoria"
L["Menethil Harbor"] = "Puerto de Menethil"
L["Miscellaneous"] = "Miscelánea"
L["Mogu'shan Palace"] = "Palacio Mogu'shan"
L["Mogu'shan Vaults"] = "Cámaras Mogu'shan"
L["Molten Core"] = "Núcleo de Magma"
L["Moon Guard Stronghold"] = "Bastión de la Guardia Lunar"
L["Moonglade"] = "Claro de la Luna"
L["Morgan's Vigil"] = "Vigilia de Morgan"
L["Mount Hyjal"] = "Monte Hyjal"
L["Moving"] = "Movimiento"
L["Mulgore"] = "Mulgore"
L["Naxxramas"] = "Naxxramas"
L["Nethergarde Keep"] = "Castillo de Nethergarde"
L["Nighthaven"] = "Amparo de la Noche"
L["Nijel's Point"] = "Punta de Nijel"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "¡ATENCIÓN!|nDebes reiniciar completamente tu cliente de juego antes de poder usar esta versión de Leatrix Maps."
L["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabaloma"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["Opacity"] = "Opacidad"
L["or click the minimap button to open Leatrix Maps."] = "o haga clic en el botón de minimapa para abrir Leatrix Maps."
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Jugador"
L["Player Arrow"] = "Flecha de jugador"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal de Zephyr"
L["Preview"] = "Prevista"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Ratchet"] = "Trinquete"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Red"] = "Rojo"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Refuge Pointe"] = "Refugio de la Zaga"
L["Reload"] = "Recargar"
L["Remember zoom level"] = "Recordar nivel de zoom"
L["Remove map border"] = "Borde del mapa"
L["Requires UI reload."] = "Requiere recargar la IU"
L["Reset"] = "Restablecer"
L["Reset Map Layout"] = "Restablecer el diseño del mapa"
L["Return to Karazhan"] = "Regresar a Karazhan"
L["Revantusk Village"] = "Poblado Sañadiente"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinas de Elune'eth"
L["Rut'theran Village"] = "Aldea Rut'theran"
L["Sanctum of Order"] = "Sagrario de Orden"
L["Scale"] = "Escala"
L["Scarlet Halls"] = "Cámaras Escarlata"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Sentinel Hill"] = "Colina del Centinela"
L["Serpentshrine Cavern"] = "Caverna Santuario Serpiente"
L["Set map opacity"] = "Opacidad del mapa"
L["Set Map Opacity"] = "Opacidad del Mapa"
L["Set map opacity while stationary and while moving."] = "Establece la opacidad del mapa mientras está parado y en movimiento."
L["Set the group icon size."] = "Establece el tamaño del icono de grupo."
L["Set the player arrow size."] = "Establece el tamaño de la flecha del jugador."
L["Sethekk Halls"] = "Salas Sethekk"
L["Settings"] = "Configuración"
L["Shado-Pan Monastery"] = "Monasterio del Shadopan"
L["Shadow Labyrinth"] = "Laberinto de las Sombras"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowmoon Burial Grounds"] = "Cementerio de Sombraluna"
L["Shadowprey Village"] = "Aldea Cazasombras"
L["Shal'Aran"] = "Shal'Aran"
L["Show boats, zeppelins and trams"] = "Mostrar barcos, zepelines y tranvías"
L["Show coordinates"] = "Coordenadas"
L["Show dungeons and raids"] = "Mostrar mazmorras y bandas"
L["Show flight points"] = "Mostrar puntos de vuelo"
L["Show minimap button"] = "Botón de minimapa"
L["Show minimap travel"] = "Mostrar viaja de minimapa"
L["Show minimum fishing skill levels"] = "Mostrar niveles mínimos de habilidad de pesca"
L["Show points of interest"] = "Puntos de interés"
L["Show Points Of Interest"] = "Puntos de Interés"
L["Show scale handle"] = "Mostrar asa de escala"
L["Show travel points"] = "Mostrar puntos de viaje"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show Unexplored Areas"] = "Áreas Inexploradas"
L["Show zone levels"] = "Nivel de zona"
L["Show Zone Levels"] = "Nivel de Zona"
L["Siege of Niuzao Temple"] = "Asedio del Templo Niuzao"
L["Siege of Orgrimmar"] = "Asedio de Orgrimmar"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Skyreach"] = "Trecho Celestial"
L["Slave Pens"] = "Recinto de los Esclavos"
L["Southshore"] = "Costasur"
L["Splintertree Post"] = "Puesto del Hachazo"
L["Stationary"] = "Estacionario"
L["Steamvault"] = "La Cámara de Vapor"
L["Stonard"] = "Rocal"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stonetalon Peak"] = "Cima del Espolón"
L["Stormstout Brewery"] = "Cervecería del Trueno"
L["Stormwind"] = "Ventormenta"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme (Main Gate)"] = "Stratholme: Entrada Principal"
L["Stratholme (Service Gate)"] = "Stratholme: Entrada de Servicio"
L["Sun Rock Retreat"] = "Refugio Roca del Sol"
L["Sunwell Plateau"] = "Meseta de La Fuente del Sol"
L["Swamp of Sorrows"] = "Pantanos de las Penas"
L["Talonbranch Glade"] = "Claro Ramaespolón"
L["Talrendis Point"] = "Punta Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Molino Tarren"
L["Tel'anor"] = "Tel'anor"
L["Teldrassil"] = "Teldrassil"
L["Tempest Keep"] = "El Castillo de la Tempestad"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Temple of the Jade Serpent"] = "Templo del Dragón de Jade"
L["Terrace of Endless Spring"] = "Veranda de la Primavera Eterna"
L["The Arcatraz"] = "El Arcatraz"
L["The Barrens"] = "Los Baldíos"
L["The Bastion of Twilight"] = "El Bastión del Crepúsculo"
L["The Black Morass"] = "La Ciénaga Negra"
L["The Blood Furnace"] = "El Horno de Sangre"
L["The Botanica"] = "El Invernáculo"
L["The Crossroads"] = "El Cruce"
L["The Culling of Stratholme"] = "La Matanza de Stratholme"
L["The Deadmines"] = "Minas de la Muerte"
L["The Dragon Soul"] = "Alma de Dragón"
L["The Everbloom"] = "Vergel Eterno"
L["The Eye"] = "El Ojo"
L["The Eye of Eternity"] = "El Ojo de la Eternidad"
L["The Forge of Souls"] = "La Forja de Almas"
L["The Forgotten Coast"] = "La Costa Olvidada"
L["The Frozen Halls"] = "Las Cámaras Heladas"
L["The Great Forge"] = "La Gran Fundición"
L["The Halls of Reflection"] = "Cámaras de Reflexión"
L["The Hinterlands"] = "Tierras del Interior"
L["The Mechanar"] = "El Mechanar"
L["The Nexus"] = "El Nexo"
L["The Obsidian Sanctum"] = "El Sagrario Obsidiana"
L["The Oculus"] = "El Oculus"
L["The Old Kingdom"] = "El Antiguo Reino"
L["The Pit of Saron"] = "Foso de Saron"
L["The Ruby Sanctum"] = "El Sagrario Rubí"
L["The Sepulcher"] = "El Sepulcro"
L["The Shattered Halls"] = "Las Salas Arrasadas"
L["The Stockade"] = "Las Mazmorras"
L["The Stonecore"] = "Núcleo Pétreo"
L["The Violet Hold"] = "El Bastión Violeta"
L["The Vortex Pinnacle"] = "La Cumbre del Vórtice"
L["The Waning Crescent"] = "El Creciente Menguante"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Isla Theramore"
L["Thorium Point"] = "Puesto del Torio"
L["Thousand Needles"] = "Las Mil Agujas"
L["Throne of the Four Winds"] = "Trono de los Cuatro Vientos"
L["Throne of the Tides"] = "Trono de las Mareas"
L["Throne of Thunder"] = "Solio del Trueno"
L["Thunder Bluff"] = "Cima del Trueno"
L["Tinker Town"] = "Ciudad Manitas"
L["Tint unexplored areas"] = "Teñir áreas inexploradas"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["Tomb of Sargeras"] = "Tumba de Sargeras"
L["Trade District"] = "Distrito de Mercaderes"
L["Trade Quarter"] = "Barrio del Comercio"
L["Tram to"] = "Tranvía a"
L["Transparency"] = "Transparencia"
L["Trial of the Champion"] = "Prueba del Campeón"
L["Trial of the Crusader"] = "Prueba del Cruzado"
L["Twilight Vineyards"] = "Viñedos Crepusculares"
L["Uldaman"] = "Uldaman"
L["Ulduar"] = "Ulduar"
L["Underbog"] = "La Sotiénaga"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Unlock map frame"] = "Desbloquear mapa"
L["Upper Blackrock Spire"] = "Cumbre de Roca Negra Superior"
L["Use default map"] = "Mapa predeterminado"
L["Use stationary opacity while pointing at map"] = "Usa opacidad estacionaria mientras apunta al mapa"
L["Utgarde Keep"] = "Fortaleza de Utgarde"
L["Utgarde Pinnacle"] = "Pináculo de Utgarde"
L["Valley of Strength"] = "El Valle de la Fuerza"
L["Valormok"] = "Valormok"
L["Vault of Archavon"] = "La Cámara de Archavon"
L["Version"] = "Versión"
L["Vol'mar"] = "Vol'mar"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["Well of Eternity"] = "Pozo de la Eternidad"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Wetlands"] = "Los Humedales"
L["Winterspring"] = "Cuna del Invierno"
L["Wyrmrest Temple"] = "Templo del Reposo del Dragón"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su IU necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga de inmediato, pero debe hacer clic en él cuando haya terminado de hacer cambios y desea que los cambios surtan efecto."
L["Your UI needs to be reloaded."] = "La IU necesita ser recargada."
L["Zeppelin to"] = "Zepelín a"
L["Zoram'gar Outpost"] = "Ensenada de Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- esES: Spanish (Spain)
if GameLocale == "esES" then
L["/ltm help - Show this information."] = "/ltm help - Mostrar información."
L["/ltm reset - Reset the panel position."] = "/ltm reset - Restablecer la posición del panel."
L["/ltm wipe - Wipe all settings and reload."] = "/ltm wipe - Limpiar la configuración y recargar."
L["A stop error has occurred but no need to worry.  It can happen from time to time.  Click the reload button to resolve it."] = "Se ha producido un error de detención, pero no hay que preocuparse. Puede suceder de vez en cuando. Haga clic en el botón de recarga para resolverlo."
L["Aerie Peak"] = "Pico Nidal"
L["Alpha"] = "Alfa"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Ashenvale"] = "Vallefresno"
L["Astranaar"] = "Astranaar"
L["Astravar Harbor"] = "Puerto de los Astravar"
L["Auberdine"] = "Auberdine"
L["Auchenai Crypts"] = "Criptas Auchenai"
L["Auchindoun"] = "Auchindoun"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Back to Main Menu"] = "Volver a menú principal"
L["Badlands"] = "Tierras Inhóspitas"
L["Baradin Hold"] = "Bastión de Baradin"
L["Black Morass"] = "Ciénaga Negra"
L["Black Temple"] = "Templo Oscuro"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Caverns"] = "Cavernas Roca Negra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackrock Foundry"] = "Fundición Roca Negra"
L["Blackrock Mountain"] = "Montaña Roca Negra"
L["Blackrock Spire"] = "Cumbre de Roca Negra"
L["Blackwing Descent"] = "Descenso de Alanegra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Bloodmaul Slag Mines"] = "Minas Machacasangre"
L["Bloodvenom Post"] = "Puesto del Veneno"
L["Blue"] = "Azul"
L["Boat to"] = "Barco a"
L["Booty Bay"] = "Bahía del Botín"
L["Brackenwall Village"] = "Poblado Murohelecho"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Camp Mojache"] = "Campamento Mojache"
L["Camp Taurajo"] = "Campamento Taurajo"
L["Caverns of Time"] = "Cavernas del Tiempo"
L["Cenarion Hold"] = "Fuerte Cenarion"
L["Central Mesa"] = "Meseta Central"
L["Chillwind Camp"] = "Campamento del Orvallo"
L["Class colored icons"] = "Iconos coloreados"
L["Class Colored Icons"] = "Iconos Coloreados por Clase"
L["Classic"] = "Clásico"
L["Click to configure the settings for this option."] = "Haga clic para configurar los ajustes para esta opción."
L["Click to reset the position and scale of the map frame."] = "Haga clic para restablecer la posición y la escala del marco del mapa."
L["Click to reset the settings on this page."] = "Haga clic para restablecer la configuración en esta página."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal."
L["Coilfang Reservoir"] = "Reserva Colmillo Torcido"
L["Configuration Panel"] = "Panel de Configuración"
L["Culling of Stratholme"] = "La Matanza de Stratholme"
L["Cursor"] = "Cursor"
L["Darkshire"] = "Villa Oscura"
L["Darkshore"] = "Costa Oscura"
L["Darnassus"] = "Darnassus"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Desolace"] = "Desolace"
L["Dire Maul"] = "La Masacre"
L["Dire Maul (East)"] = "La Masacre (Este)"
L["Dire Maul (North)"] = "La Masacre (Norte)"
L["Dire Maul (West)"] = "La Masacre (Oeste)"
L["Dire Maul: Capital Gardens"] = "La Masacre: Jardines de la Capital"
L["Dire Maul: Gordok Commons"] = "La Masacre: Ágora de Gordok"
L["Dire Maul: Warpwood Quarter"] = "La Masacre: Barrio Alabeo"
L["Disable reading emote when opening the map"] = "Deshabilita la lectura de emoticones al abrir el mapa"
L["Drag"] = "Arrastrar"
L["Drag to set the amount of blue."] = "Arrastra para establecer la cantidad de azul."
L["Drag to set the amount of green."] = "Arrastra para establecer la cantidad de verde."
L["Drag to set the amount of red."] = "Arrastra para establecer la cantidad de rojo."
L["Drag to set the group icon size."] = "Arrastra para establecer el tamaño del icono de grupo."
L["Drag to set the map opacity for when your character is moving."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje se esté moviendo."
L["Drag to set the map opacity for when your character is stationary."] = "Arrastra para establecer la opacidad del mapa para cuando su personaje esté estacionario."
L["Drag to set the opacity."] = "Arrastra para establecer la opacidad."
L["Drag to set the player arrow size.|n|nWow Classic default is 16.|nWow Retail default is 27."] = "Arrastra para establecer el tamaño de la flecha del jugador.|n|nEl valor predeterminado de WoW Classic es 16.|nEl valor predeterminado de WoW Retail es 27."
L["Dragon Soul"] = "Alma de Dragón"
L["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon"
L["Druid only flight point to Darnassus"] = "Punto de vuelo a Darnassus solo para druidas"
L["Druid only flight point to Thunder Bluff"] = "Punto de vuelo a Cima del Trueno solo para druidas"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeon"] = "Mazmorra"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Dwarven District"] = "Distrito de los Enanos"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["Elements"] = "Visibilidad"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["End Time"] = "Fin de los Días"
L["Enlarge player arrow"] = "Flecha de jugador"
L["Enlarge Player Arrow"] = "Flecha de Jugador"
L["Enter"] = "Entrar"
L["Eternal Guardian"] = "Guardián eterno"
L["Everlook"] = "Vista Eterna"
L["Evermoon Terrace"] = "Terraza Lunaeterna"
L["Eye of Azshara"] = "Ojo de Azshara"
L["Falanaar"] = "Falanaar"
L["Feathermoon Stronghold"] = "Bastión Plumaluna"
L["Felsoul Hold"] = "Bastión Alma Vil"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Firelands"] = "Tierras de Fuego"
L["Fishing"] = "Pesca"
L["Flame Crest"] = "Peñasco Llamarada"
L["Freewind Post"] = "Poblado Viento Libre"
L["Gadgetzan"] = "Gadgetzan"
L["Gate of the Setting Sun"] = "Puerta del Sol Poniente"
L["Gnomeregan"] = "Gnomeregan"
L["Green"] = "Verde"
L["Grim Batol"] = "Grim Batol"
L["Grimrail Depot"] = "Terminal Malavía"
L["Grom'gol Base Camp"] = "Campamento Grom'gol"
L["Group Icons"] = "Iconos de grupo"
L["Gruul's Lair"] = "Guarida de Gruul"
L["Gundrak"] = "Gundrak"
L["Gundrak (rear entrance)"] = "Gundrak (entrada trasera)"
L["Halls of Lightning"] = "Cámaras de Relámpagos"
L["Halls of Origination"] = "Cámaras de los Orígenes"
L["Halls of Stone"] = "Cámaras de Piedra"
L["Halls of Valor"] = "Cámaras del Valor"
L["Hammerfall"] = "Sentencia"
L["Heart of Fear"] = "Corazón del Miedo"
L["Hellfire Citadel"] = "Ciudadela del Fuego Infernal"
L["Hellfire Ramparts"] = "Murallas del Fuego Infernal"
L["Hide town and city icons"] = "Pueblos y ciudades"
L["Highmaul"] = "Ogrópolis"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Hour of Twilight"] = "Hora del Crepúsculo"
L["Hyjal Summit"] = "La Cima Hyjal"
L["Icecrown"] = "Corona de Hielo"
L["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo"
L["Icons"] = "Iconos"
L["If checked, boat harbors, zeppelin towers and tram stations will be shown."] = "Si está marcado, se mostrarán los puertos de los barcos, las torres de los zepelines y las estaciones de tranvía."
L["If checked, coordinates will be shown."] = "Si está marcado, se mostrarán las coordenadas."
L["If checked, dungeons and raids will be shown."] = "Si está marcado, se mostrarán mazmorras y bandas."
L["If checked, flight points will be shown."] = "Si está marcado, se mostrarán los puntos de vuelo."
L["If checked, group icons will use a modern, class-colored design."] = "Si está marcado, los iconos de grupo usarán un diseño moderno, de color de clase."
L["If checked, opening the map will use the same zoom level from when you last closed it as long as the map zone has not changed."] = "Si está marcado, al abrir el mapa se usará el mismo nivel de zoom desde la última vez que lo cerró, siempre que la zona del mapa no haya cambiado."
L["If checked, pointing at the map while your character is moving will cause the stationary opacity setting to be applied."] = "Si está marcado, apuntar al mapa mientras tu personaje se mueve hará que se aplique la configuración de opacidad estacionaria."
L["If checked, points of interest will be shown."] = "Si está marcado, se mostrarán puntos de interés."
L["If checked, the default fullscreen map will be used.|n|nNote that enabling this option will prevent you from unlocking the map or removing the map border."] = "Si está marcado, se usará el mapa predeterminado de pantalla completa.|n|nTenga en cuenta que habilitar esta opción le impedirá desbloquear el mapa o eliminar el borde del mapa."
L["If checked, the map border will be removed."] = "Si está marcado, se eliminará el borde del mapa."
L["If checked, the minimap button will be shown."] = "Si está marcado, se mostrará el botón del minimapa."
L["If checked, the minimum fishing skill levels will be shown."] = "Si está marcado, se mostrarán los niveles mínimos de habilidad de pesca."
L["If checked, town and city icons will not be shown on the continent maps."] = "Si está marcado, los iconos de pueblos y ciudades no se mostrarán en los mapas continentes."
L["If checked, unexplored areas of the map will be shown."] = "Si está marcado, se mostrarán áreas inexploradas del mapa."
L["If checked, unexplored areas will be tinted."] = "Si está marcado, las áreas inexploradas se teñirán."
L["If checked, you will be able to enlarge the player arrow."] = "Si está marcado, podrá ampliar la flecha del jugador."
L["If checked, you will be able to scale and move the map.|n|nScale the map by dragging the scale handle in the bottom-right corner.|n|nMove the map by dragging the border and frame edges.  If you have removed the map border, a drag button will be shown in the top-left corner."] = "Si está marcado, podrá escalar y mover el mapa.|n|nEscale el mapa arrastrando el controlador de escala en la esquina inferior derecha.|n|nMueva el mapa arrastrando el borde y los bordes del marco. Si ha eliminado el borde del mapa, se mostrará un botón de arrastre en la esquina superior izquierda."
L["If checked, you will be able to set the opacity of the map."] = "Si está marcado, podrá establecer la opacidad del mapa."
L["If checked, zone, dungeon and fishing skill levels will be shown."] = "Si está marcado, se mostrarán los niveles de zona, mazmorra y hablidad de pesca."
L["Invalid command.  Enter /ltm help for help."] = "Comando inválido. Escribe / ltm help para obtener ayuda."
L["Iron Docks"] = "Puerto de Hierro"
L["Ironforge"] = "Forjaz"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Kargath"
L["Lake Elune'ara"] = "Lago Elune'ara"
L["Lake Everstill"] = "Lago Sempiterno"
L["Large Scarab Coffer"] = "Arca del escarabajo grande"
L["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz"
L["Lion's Watch"] = "Avanzada del León"
L["Loch Modan"] = "Loch Modan"
L["Lost City of the Tol'vir"] = "Ciudad Perdida de los Tol'vir"
L["Lower Blackrock Spire"] = "Cumbre de Roca Negra Inferior"
L["Lower Wilds"] = "Thalanaar"
L["Lunastre Estate"] = "Finca de Lunastre"
L["Magisters' Terrace"] = "Bancal del Magister"
L["Magtheridon's Lair"] = "Guarida de Magtheridon"
L["Mana-Tombs"] = "Tumbas de Maná"
L["Map frame scale"] = "Escala del marco del mapa"
L["Maraudon"] = "Maraudon"
L["Maraudon: Earth Song Falls"] = "Maraudon: Cascadas del Canto de la Tierra"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Gruta de la Espora Fétida"
L["Maraudon: The Wicked Grotto"] = "Maraudon: La Gruta Maldita"
L["Marshal's Refuge"] = "Refugio de Marshal"
L["Mechanics"] = "Mecánicas"
L["Memory Usage"] = "Uso de memoria"
L["Menethil Harbor"] = "Puerto de Menethil"
L["Miscellaneous"] = "Miscelánea"
L["Mogu'shan Palace"] = "Palacio Mogu'shan"
L["Mogu'shan Vaults"] = "Cámaras Mogu'shan"
L["Molten Core"] = "Núcleo de Magma"
L["Moon Guard Stronghold"] = "Bastión de la Guardia Lunar"
L["Moonglade"] = "Claro de la Luna"
L["Morgan's Vigil"] = "Vigilia de Morgan"
L["Mount Hyjal"] = "Monte Hyjal"
L["Moving"] = "Movimiento"
L["Mulgore"] = "Mulgore"
L["Naxxramas"] = "Naxxramas"
L["Nethergarde Keep"] = "Castillo de Nethergarde"
L["Nighthaven"] = "Amparo de la Noche"
L["Nijel's Point"] = "Punta de Nijel"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Maps."] = "¡ATENCIÓN!|nDebes reiniciar completamente tu cliente de juego antes de poder usar esta versión de Leatrix Maps."
L["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabaloma"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["Opacity"] = "Opacidad"
L["or click the minimap button to open Leatrix Maps."] = "o haga clic en el botón de minimapa para abrir Leatrix Maps."
L["Orgrimmar"] = "Orgrimmar"
L["Player"] = "Jugador"
L["Player Arrow"] = "Flecha de jugador"
L["Portal"] = "Portal"
L["Portal from Zephyr"] = "Portal de Zephyr"
L["Preview"] = "Prevista"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Ratchet"] = "Trinquete"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Red"] = "Rojo"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Refuge Pointe"] = "Refugio de la Zaga"
L["Reload"] = "Recargar"
L["Remember zoom level"] = "Recordar nivel de zoom"
L["Remove map border"] = "Borde del mapa"
L["Requires UI reload."] = "Requiere recargar la IU"
L["Reset"] = "Restablecer"
L["Reset Map Layout"] = "Restablecer el diseño del mapa"
L["Return to Karazhan"] = "Regresar a Karazhan"
L["Revantusk Village"] = "Poblado Sañadiente"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinas de Elune'eth"
L["Rut'theran Village"] = "Aldea Rut'theran"
L["Sanctum of Order"] = "Sagrario de Orden"
L["Scale"] = "Escala"
L["Scarlet Halls"] = "Cámaras Escarlata"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Sentinel Hill"] = "Colina del Centinela"
L["Serpentshrine Cavern"] = "Caverna Santuario Serpiente"
L["Set map opacity"] = "Opacidad del mapa"
L["Set Map Opacity"] = "Opacidad del Mapa"
L["Set map opacity while stationary and while moving."] = "Establece la opacidad del mapa mientras está parado y en movimiento."
L["Set the group icon size."] = "Establece el tamaño del icono de grupo."
L["Set the player arrow size."] = "Establece el tamaño de la flecha del jugador."
L["Sethekk Halls"] = "Salas Sethekk"
L["Settings"] = "Configuración"
L["Shado-Pan Monastery"] = "Monasterio del Shadopan"
L["Shadow Labyrinth"] = "Laberinto de las Sombras"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowmoon Burial Grounds"] = "Cementerio de Sombraluna"
L["Shadowprey Village"] = "Aldea Cazasombras"
L["Shal'Aran"] = "Shal'Aran"
L["Show boats, zeppelins and trams"] = "Mostrar barcos, zepelines y tranvías"
L["Show coordinates"] = "Coordenadas"
L["Show dungeons and raids"] = "Mostrar mazmorras y bandas"
L["Show flight points"] = "Mostrar puntos de vuelo"
L["Show minimap button"] = "Botón de minimapa"
L["Show minimap travel"] = "Mostrar viaja de minimapa"
L["Show minimum fishing skill levels"] = "Mostrar niveles mínimos de habilidad de pesca"
L["Show points of interest"] = "Puntos de interés"
L["Show Points Of Interest"] = "Puntos de Interés"
L["Show scale handle"] = "Mostrar asa de escala"
L["Show travel points"] = "Mostrar puntos de viaje"
L["Show unexplored areas"] = "Áreas inexploradas"
L["Show Unexplored Areas"] = "Áreas Inexploradas"
L["Show zone levels"] = "Nivel de zona"
L["Show Zone Levels"] = "Nivel de Zona"
L["Siege of Niuzao Temple"] = "Asedio del Templo Niuzao"
L["Siege of Orgrimmar"] = "Asedio de Orgrimmar"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Skyreach"] = "Trecho Celestial"
L["Slave Pens"] = "Recinto de los Esclavos"
L["Southshore"] = "Costasur"
L["Splintertree Post"] = "Puesto del Hachazo"
L["Stationary"] = "Estacionario"
L["Steamvault"] = "La Cámara de Vapor"
L["Stonard"] = "Rocal"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stonetalon Peak"] = "Cima del Espolón"
L["Stormstout Brewery"] = "Cervecería del Trueno"
L["Stormwind"] = "Ventormenta"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme (Main Gate)"] = "Stratholme: Entrada Principal"
L["Stratholme (Service Gate)"] = "Stratholme: Entrada de Servicio"
L["Sun Rock Retreat"] = "Refugio Roca del Sol"
L["Sunwell Plateau"] = "Meseta de La Fuente del Sol"
L["Swamp of Sorrows"] = "Pantanos de las Penas"
L["Talonbranch Glade"] = "Claro Ramaespolón"
L["Talrendis Point"] = "Punta Talrendis"
L["Tanaris"] = "Tanaris"
L["Tarren Mill"] = "Molino Tarren"
L["Tel'anor"] = "Tel'anor"
L["Teldrassil"] = "Teldrassil"
L["Tempest Keep"] = "El Castillo de la Tempestad"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Temple of the Jade Serpent"] = "Templo del Dragón de Jade"
L["Terrace of Endless Spring"] = "Veranda de la Primavera Eterna"
L["The Arcatraz"] = "El Arcatraz"
L["The Barrens"] = "Los Baldíos"
L["The Bastion of Twilight"] = "El Bastión del Crepúsculo"
L["The Black Morass"] = "La Ciénaga Negra"
L["The Blood Furnace"] = "El Horno de Sangre"
L["The Botanica"] = "El Invernáculo"
L["The Crossroads"] = "El Cruce"
L["The Culling of Stratholme"] = "La Matanza de Stratholme"
L["The Deadmines"] = "Minas de la Muerte"
L["The Dragon Soul"] = "Alma de Dragón"
L["The Everbloom"] = "Vergel Eterno"
L["The Eye"] = "El Ojo"
L["The Eye of Eternity"] = "El Ojo de la Eternidad"
L["The Forge of Souls"] = "La Forja de Almas"
L["The Forgotten Coast"] = "La Costa Olvidada"
L["The Frozen Halls"] = "Las Cámaras Heladas"
L["The Great Forge"] = "La Gran Fundición"
L["The Halls of Reflection"] = "Cámaras de Reflexión"
L["The Hinterlands"] = "Tierras del Interior"
L["The Mechanar"] = "El Mechanar"
L["The Nexus"] = "El Nexo"
L["The Obsidian Sanctum"] = "El Sagrario Obsidiana"
L["The Oculus"] = "El Oculus"
L["The Old Kingdom"] = "El Antiguo Reino"
L["The Pit of Saron"] = "Foso de Saron"
L["The Ruby Sanctum"] = "El Sagrario Rubí"
L["The Sepulcher"] = "El Sepulcro"
L["The Shattered Halls"] = "Las Salas Arrasadas"
L["The Stockade"] = "Las Mazmorras"
L["The Stonecore"] = "Núcleo Pétreo"
L["The Violet Hold"] = "El Bastión Violeta"
L["The Vortex Pinnacle"] = "La Cumbre del Vórtice"
L["The Waning Crescent"] = "El Creciente Menguante"
L["Thelsamar"] = "Thelsamar"
L["Theramore Isle"] = "Isla Theramore"
L["Thorium Point"] = "Puesto del Torio"
L["Thousand Needles"] = "Las Mil Agujas"
L["Throne of the Four Winds"] = "Trono de los Cuatro Vientos"
L["Throne of the Tides"] = "Trono de las Mareas"
L["Throne of Thunder"] = "Solio del Trueno"
L["Thunder Bluff"] = "Cima del Trueno"
L["Tinker Town"] = "Ciudad Manitas"
L["Tint unexplored areas"] = "Teñir áreas inexploradas"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["Tomb of Sargeras"] = "Tumba de Sargeras"
L["Trade District"] = "Distrito de Mercaderes"
L["Trade Quarter"] = "Barrio del Comercio"
L["Tram to"] = "Tranvía a"
L["Transparency"] = "Transparencia"
L["Trial of the Champion"] = "Prueba del Campeón"
L["Trial of the Crusader"] = "Prueba del Cruzado"
L["Twilight Vineyards"] = "Viñedos Crepusculares"
L["Uldaman"] = "Uldaman"
L["Ulduar"] = "Ulduar"
L["Underbog"] = "La Sotiénaga"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Unlock map frame"] = "Desbloquear mapa"
L["Upper Blackrock Spire"] = "Cumbre de Roca Negra Superior"
L["Use default map"] = "Mapa predeterminado"
L["Use stationary opacity while pointing at map"] = "Usa opacidad estacionaria mientras apunta al mapa"
L["Utgarde Keep"] = "Fortaleza de Utgarde"
L["Utgarde Pinnacle"] = "Pináculo de Utgarde"
L["Valley of Strength"] = "El Valle de la Fuerza"
L["Valormok"] = "Valormok"
L["Vault of Archavon"] = "La Cámara de Archavon"
L["Version"] = "Versión"
L["Vol'mar"] = "Vol'mar"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["Well of Eternity"] = "Pozo de la Eternidad"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Wetlands"] = "Los Humedales"
L["Winterspring"] = "Cuna del Invierno"
L["Wyrmrest Temple"] = "Templo del Reposo del Dragón"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su IU necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga de inmediato, pero debe hacer clic en él cuando haya terminado de hacer cambios y desea que los cambios surtan efecto."
L["Your UI needs to be reloaded."] = "La IU necesita ser recargada."
L["Zeppelin to"] = "Zepelín a"
L["Zoram'gar Outpost"] = "Ensenada de Zoram'gar"
L["Zul'Aman"] = "Zul'Aman"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"

end

-- frFR: French
if GameLocale == "frFR" then

end

-- itIT: Italian
if GameLocale == "itIT" then

end

-- ptBR: Portugese (Brazil)
if GameLocale == "ptBR" then

end
