/**
 * @parent eBase
 *
 * EPGMedia Object 
 */
$.Class.extend('EPGMedia',{
	init:function()
	{
		this.mp = new MediaPlayer("LiveTV");
		this.mpPIP;
		this.initMeida();
		this.status = 0;		// 0:直播频道没有正在播放状态	1：正在播放某个频道
		//this.initPIPMeida();
	},	
	initMeida:function()
	{
		var playerInstanceId = this.mp.getNativePlayerInstanceID();
		var playListFlag = 0;
		var videoDisplayMode = 1;
		var height = 0;
		var width = 0;
		var left = 0;
		var top = 0;
		var muteFlag = 1;
		var subtitleFlag = 0;
		var videoAlpha = 0;
		var cycleFlag = 0;
		var randomFlag = 0;
		var autoDelFlag = 0;
		var useNativeUIFlag = 0;
		//初始化媒体播放参数
		//this.mp.initMediaPlayer(playerInstanceId,playListFlag,videoDisplayMode,720,1280,0,0,muteFlag,useNativeUIFlag,subtitleFlag,videoAlpha,cycleFlag,randomFlag,autoD//elFlag);
	},
	initPIPMeida:function()
	{
		var playerInstanceId = this.mpPIP.getNativePlayerInstanceID();
		var playListFlag = 0;
		var videoDisplayMode = 0;
		var height = 0;
		var width = 0;
		var left = 0;
		var top = 0;
		var muteFlag = 1;
		var subtitleFlag = 0;
		var videoAlpha = 0;
		var cycleFlag = 0;
		var randomFlag = 0;
		var autoDelFlag = 0;
		var useNativeUIFlag = 0;
		//初始化媒体播放参数
		this.mpPIP.initMediaPlayer(playerInstanceId,playListFlag,videoDisplayMode,155,280,935,75,muteFlag,useNativeUIFlag,subtitleFlag,videoAlpha,cycleFlag,randomFlag,autoDelFlag);
	},
	/**
	 * 停止正在播放的媒体并释放资源
	 */
	stop : function ()
	{
		this.status = 0;

		this.mp.stop();
	},

	/**
	 * 暂停当前播放的媒体
	 */
	pause : function ()
	{

		this.mp.pause();
	},

	/**
	 * 从当前媒体的暂停状态恢复正常播放
	 */
	resume : function ()
	{

		this.mp.resume();
	},

	joinChannel : function (userChannelId)
	{
		this.status = 1;
		this.mp.joinChannel(parseInt(userChannelId,10));
	},
	mpPIPJoinChannel: function (userChannelId)
	{
		this.mpPIP.joinChannel(parseInt(userChannelId,10));
	},
	mpPIPsetVideoDisplayArea:function (left,top,width,height)
	{

		this.left=left;
		this.top=top;
		this.width=width;
		this.height=height;
		this.mpPIP.setVideoDisplayArea(this.left,this.top,this.width,this.height);
	},
	mpPIPleaveChannel: function(userChannelId)
	{
		this.mpPIP.leaveChannel(userChannelId)
	},
	mpPIPCloseWindow: function()
	{
		this.mpPIP.releaseMediaPlayer(this.mpPIP.getNativePlayerInstanceID());
	},
	leaveChannel: function(userChannelId)
	{
		this.status = 0;
		this.mp.leaveChannel(userChannelId)
	},
	closeWindow: function()
	{
		this.status = 0;
		/* 切换到直播或点播时，如果当前有消息则需要清除 */
		eBaseService.closeTVMS();

		this.mp.releaseMediaPlayer(this.mp.getNativePlayerInstanceID());
	},
	/**
	 * 跳到媒体最初位置播放
	 */
	gotoStart : function ()
	{

		this.mp.gotoStart();
	},

	/**
	 * 跳到媒体末端播放
	 */
	gotoEnd : function ()
	{

		this.mp.gotoEnd();
	},
	/**
	 * 快进
	 */
	fastForward : function (iScale)
	{

		//允许Trickmode操作
		//if(this.allowTrickmodeFlag==0)
		//{

			this.mp.fastForward(0);
		//}
	},

	/**
	 * 快退
	 */
	fastRewind : function (iScale)
	{

		//if(this.allowTrickmodeFlag==0)
		//{

			this.mp.fastRewind(0);
		//}
	},

	/**
	 * 从媒体起始点开始播放
	 */
	playFromStart : function ()
	{

		this.mp.playFromStart();
	},

	/**
	 * 从媒体指定时间点开始播放
	 */
	playByTime : function (type,timestamp,speed)
	{

		this.mp.playByTime(type,timestamp,speed);
		//media.AV.seek(timestamp + "");
	},

	/**
	 * 设置静音状态
	 */
	setMuteFlag : function (muteFlag)	//0:设置为有声 (默认值);1:设置为静音
	{

		if(this.mp.getMuteFlag() != muteFlag) {	//0：表示未静音;1：表示静音
			var VolumeNum = this.mp.getVolume();
			if(muteFlag == 0)	{
				//media.sound.resume();
				this.mp.setMuteFlag(muteFlag);
				this.mp.setVolume(VolumeNum);
				this.muteFlag = muteFlag;
			} else if(muteFlag == 1) {
				this.mp.setMuteFlag(muteFlag);
				this.muteFlag = muteFlag;
			}
		}
	},

	/**
	 * 获取静音属性值
	 * return 0 表示有声，1静音
	 */
	getMuteFlag : function ()
	{

		return this.mp.getMuteFlag();
	},

	/**
	 * 设置音量
	 */
	setVolume : function (volume)
	{
		if (volume >= 0 || volume <= 100) {
			this.mp.setVolume(volume);
		}
	},

	/**
	 * 获取音量
	 */
	getVolume : function ()
	{

		return this.mp.getVolume();
	},

	/**
	 * 可选的属性：保留此属性，但可以不实现功能,播放器是否需要显示字幕。设置后立即生效。
	 */
	setSubtitileFlag : function (subtitileFlag)
	{

		this.mp.setSubtitileFlag(subtitileFlag)
	},

	getSubtitileFlag : function ()
	{

		return this.mp.getSubtitileFlag();
	},

	/**
	 * 设置声道类型
	 */
	setCurrentAudioChannel : function(type)
	{

		//media.sound.mode = type;
		this.mp.setCurrentAudioChannel(type);
	},

	/**
	 * 获取当前的声道类型
	 */
	getCurrentAudioChannel : function ()
	{

		return this.mp.getCurrentAudioChannel();
		//return iPanel.ioctlRead("AudioChannel");	//参数需要作修改?
	},

	setSingleMedia : function (mediaStr)
	{

		
			//Log.v("mediaStr = " + mediaStr);
			//var mediaJson = eval(mediaStr);
	//		//alert(mediaJson.length);
	//		Log.v("mediaJson.length = " + mediaJson.length);
			//this.playList = mediaJson;
	//		this.currentIndex = 0;
	//		Log.v("mediaJson.mediaUrl = " + this.playList[this.currentIndex].mediaUrl);
	//		Log.v("mediaJson.mediaType = " + this.playList[this.currentIndex].mediaType);
	//		this.mediaType = "VOD";
	//		this.mediaUrl = this.playList[this.currentIndex].mediaUrl;
	//		media.AV.open(this.mediaUrl, this.mediaType);
			//media.AV.play();	//open后直接play
			
			/*modify by dingzhe 直接传入Json字符串(包括带宽信息) at 2010-01-27*/
			this.mp.setSingleMedia(mediaStr);
			//media.AV.open(mediaStr, "VOD");
	},

	/**
	 * 获取媒体播放到的当前时间点
	 */
	getCurrentPlayTime : function ()
	{


		return this.mp.getCurrentPlayTime();

	},

	getMediaStatus : function()
	{
		eval("eventJson = " + this.mp.getPlaybackMode()+" ");

		var playStatus = eventJson.PlayMode;
/*		var playStautsStr = "play";
		
		switch(playStatus)
		{
			case 0:
				playStautsStr = "stop";
				break;
			case 1:
				playStautsStr = "pause";
				break;
			case 2:
				playStautsStr = "Normal Play";
				break;
			case 3:
				playStautsStr = "Trick Mode";
				break;
			default:
				playStautsStr = "play";
				break;	
		}*/
		

		return playStautsStr;
	},

	/**
	*功能：当STB 播放器的playback mode 发生改变的时候以虚拟键及事件的方式通知EPG
	* 取值和参数：播放器的当前播放模式。返回值为JSON 字符串，其中至少包括“播放模式”和“模式相关参数” 两类信息，播放模式分：Normal Play，Pause，Trickmode；当模式为Trickmode 时必须带2x/-2x, 4x/-4x,8x/-8x, 16x/-16x, 32x/-32x 参数来表示快进/快退的速度参数，如：{PlayMode:“Normal Play”,Speed:1x}
	*/	 
	/*alter by zhongping*/
	getPlaybackMode : function ()
	{
		//var playbackStatus = this.getMediaStatus();
		
		var mode={};
		eval("eventJson = " + this.mp.getPlaybackMode()+" ");
		mode = eventJson;
		if(eventJson.PlayMode == "play") {
			mode.PlayMode = "Normal Play";
			//mode.Speed = this.mp.getPlaybackMode().play_rate+"x";
		}else if(eventJson.PlayMode == "pause") {
			mode.PlayMode = "Pause";
			//mode.Speed = 0 + "x";
		}else if(eventJson.PlayMode == "Trick Mode") {     
			mode.PlayMode = "Trickmode";
			//mode.Speed = this.mp.getPlaybackMode().play_rate + "x";
		}

		return mode;
	},

	/**
	 * 获取当前播放的媒体的总时长
	 */
	getMediaDuration : function ()
	{


	 	return this.mp.getMediaDuration();
	},

	/**
	 * 设置当前播放媒体的状态：0，按设置的位置显示，1，全屏
	 */
	setVideoDisplayMode:function (videoDisplayMode)
	{

		this.mp.setVideoDisplayMode(videoDisplayMode);
		this.mp.refreshVideoDisplay();
		this.videoDisplayMode=videoDisplayMode;
	},

	/**
	 * 设置当前播放媒体的窗口大小
	 */
	setVideoDisplayArea:function (left,top,width,height)
	{

		this.left=left;
		this.top=top;
		this.width=width;
		this.height=height;
		this.mp.setVideoDisplayArea(this.left,this.top,this.width,this.height);
	},
	/**
	 * 获取媒体播放到的当前时间点
	 */
	getCurrentPlayMilliSecondTime:function ()
	{
		var currPlayTime = 0;
		//if(undefined != this.mp.elapsed) currPlayTime = this.mp.elapsed;
		currPlayTime = this.mp.elapsed;
		return currPlayTime;
	}
	
},{});


